/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.csv;

import com.opencsv.CSVParserWriter;
import com.opencsv.ICSVParser;
import com.opencsv.RFC4180ParserBuilder;
import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.tribuo.Dataset;
import org.tribuo.Example;
import org.tribuo.Feature;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.Output;
import org.tribuo.VariableIDInfo;
import org.tribuo.VariableInfo;

public class CSVSaver
implements Configurable {
    private static final Logger logger = Logger.getLogger(CSVSaver.class.getName());
    public static final String DEFAULT_RESPONSE = "Response";
    @Config(description="The column separator.")
    private char separator = (char)44;
    @Config(description="The quote character.")
    private char quote = (char)34;

    public CSVSaver(char separator, char quote) {
        if (separator == quote) {
            throw new IllegalArgumentException("Quote and separator must be different characters.");
        }
        this.separator = separator;
        this.quote = quote;
    }

    public CSVSaver() {
        this(',', '\"');
    }

    public <T extends Output<T>> void save(Path csvPath, Dataset<T> dataset, String responseName) throws IOException {
        this.save(csvPath, dataset, Collections.singleton(responseName));
    }

    public <T extends Output<T>> void save(Path csvPath, Dataset<T> dataset, Set<String> responseNames) throws IOException {
        boolean isMultiOutput = responseNames.size() > 1;
        ImmutableFeatureMap features = dataset.getFeatureIDMap();
        int ncols = features.size() + responseNames.size();
        String[] headerLine = new String[ncols];
        HashMap<String, Integer> responseToColumn = new HashMap<String, Integer>();
        int col = 0;
        Iterator iterator = responseNames.iterator();
        while (iterator.hasNext()) {
            String response;
            headerLine[col] = response = iterator.next();
            responseToColumn.put(response, col);
            ++col;
        }
        for (VariableInfo feature : features) {
            headerLine[col++] = feature.getName();
        }
        try (CSVParserWriter writer = new CSVParserWriter((Writer)Files.newBufferedWriter(csvPath, StandardCharsets.UTF_8, new OpenOption[0]), (ICSVParser)new RFC4180ParserBuilder().withSeparator(this.separator).withQuoteChar(this.quote).build(), "\n");){
            writer.writeNext(headerLine);
            for (Example e : dataset) {
                String[] denseOutput = isMultiOutput ? CSVSaver.densifyMultiOutput(e, responseToColumn) : CSVSaver.densifySingleOutput(e);
                String[] featureArr = CSVSaver.generateFeatureArray(e, features);
                if (featureArr.length != features.size()) {
                    throw new IllegalStateException(String.format("Invalid example: had %d features, expected %d.", featureArr.length, features.size()));
                }
                String[] line = new String[ncols];
                System.arraycopy(denseOutput, 0, line, 0, denseOutput.length);
                System.arraycopy(featureArr, 0, line, denseOutput.length, featureArr.length);
                writer.writeNext(line);
            }
        }
    }

    private static <T extends Output<T>> String[] densifySingleOutput(Example<T> e) {
        return new String[]{e.getOutput().getSerializableForm(false)};
    }

    private static <T extends Output<T>> String[] densifyMultiOutput(Example<T> e, Map<String, Integer> responseToColumn) {
        String[] sparseOutput;
        Object[] denseOutput = new String[responseToColumn.size()];
        Arrays.fill(denseOutput, "0");
        String csv = e.getOutput().getSerializableForm(false);
        if (csv.isEmpty()) {
            return denseOutput;
        }
        for (String elem : sparseOutput = csv.split(",")) {
            String[] kv = elem.split("=");
            if (kv.length != 2) {
                throw new IllegalArgumentException("Bad serialized string element: '" + elem + "'");
            }
            String responseName = kv[0];
            String responseValue = kv[1];
            int index = responseToColumn.getOrDefault(responseName, -1);
            if (index == -1) {
                if (responseName.equals("")) continue;
                throw new IllegalStateException(String.format("Invalid example: unknown response name '%s'. (known response names: %s)", responseName, responseToColumn.keySet()));
            }
            denseOutput[index] = responseValue;
        }
        return denseOutput;
    }

    private static <T extends Output<T>> String[] generateFeatureArray(Example<T> example, ImmutableFeatureMap features) {
        String[] output = new String[features.size()];
        HashMap<Integer, Double> featureMap = new HashMap<Integer, Double>();
        for (Feature f : example) {
            VariableIDInfo info = features.get(f.getName());
            if (info == null) continue;
            featureMap.put(info.getID(), f.getValue());
        }
        for (int i = 0; i < features.size(); ++i) {
            Double curFeature = (Double)featureMap.get(i);
            output[i] = curFeature == null ? "0" : curFeature.toString();
        }
        return output;
    }
}

