/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.io.Writer;
import org.apache.commons.io.build.AbstractStreamBuilder;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.IOFunction;
import org.apache.commons.io.function.IOIntConsumer;
import org.apache.commons.io.function.IORunnable;
import org.apache.commons.io.function.IOTriConsumer;
import org.apache.commons.io.function.IOTriFunction;
import org.apache.commons.io.function.Uncheck;

public final class UncheckedFilterWriter
extends FilterWriter {
    public static Builder builder() {
        return new Builder();
    }

    private UncheckedFilterWriter(Builder builder) throws IOException {
        super(builder.getWriter());
    }

    @Override
    public Writer append(char c) throws UncheckedIOException {
        return (Writer)Uncheck.apply((IOFunction<Character, Writer> & Serializable)x$0 -> super.append((char)x$0), Character.valueOf(c));
    }

    @Override
    public Writer append(CharSequence csq) throws UncheckedIOException {
        return (Writer)Uncheck.apply((IOFunction<CharSequence, Writer> & Serializable)x$0 -> super.append((CharSequence)x$0), csq);
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws UncheckedIOException {
        return (Writer)Uncheck.apply((IOTriFunction<CharSequence, Integer, Integer, Writer> & Serializable)(x$0, x$1, x$2) -> super.append((CharSequence)x$0, (int)x$1, (int)x$2), csq, start, end);
    }

    @Override
    public void close() throws UncheckedIOException {
        Uncheck.run((IORunnable & Serializable)() -> super.close());
    }

    @Override
    public void flush() throws UncheckedIOException {
        Uncheck.run((IORunnable & Serializable)() -> super.flush());
    }

    @Override
    public void write(char[] cbuf) throws UncheckedIOException {
        Uncheck.accept((IOConsumer<char[]> & Serializable)x$0 -> super.write((char[])x$0), cbuf);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws UncheckedIOException {
        Uncheck.accept((IOTriConsumer<char[], Integer, Integer> & Serializable)(x$0, x$1, x$2) -> super.write((char[])x$0, (int)x$1, (int)x$2), cbuf, off, len);
    }

    @Override
    public void write(int c) throws UncheckedIOException {
        Uncheck.accept((IOIntConsumer & Serializable)x$0 -> super.write(x$0), c);
    }

    @Override
    public void write(String str) throws UncheckedIOException {
        Uncheck.accept((IOConsumer<String> & Serializable)x$0 -> super.write((String)x$0), str);
    }

    @Override
    public void write(String str, int off, int len) throws UncheckedIOException {
        Uncheck.accept((IOTriConsumer<String, Integer, Integer> & Serializable)(x$0, x$1, x$2) -> super.write((String)x$0, (int)x$1, (int)x$2), str, off, len);
    }

    public static class Builder
    extends AbstractStreamBuilder<UncheckedFilterWriter, Builder> {
        @Override
        public UncheckedFilterWriter get() throws IOException {
            return new UncheckedFilterWriter(this);
        }
    }
}

