/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.CharBuffer;
import org.apache.commons.io.build.AbstractStreamBuilder;
import org.apache.commons.io.function.IOBooleanSupplier;
import org.apache.commons.io.function.IOFunction;
import org.apache.commons.io.function.IOIntConsumer;
import org.apache.commons.io.function.IOIntSupplier;
import org.apache.commons.io.function.IORunnable;
import org.apache.commons.io.function.IOSupplier;
import org.apache.commons.io.function.IOTriFunction;
import org.apache.commons.io.function.Uncheck;

public final class UncheckedFilterReader
extends FilterReader {
    public static Builder builder() {
        return new Builder();
    }

    private UncheckedFilterReader(Builder builder) throws IOException {
        super(builder.getReader());
    }

    @Override
    public void close() throws UncheckedIOException {
        Uncheck.run((IORunnable & Serializable)() -> super.close());
    }

    @Override
    public void mark(int readAheadLimit) throws UncheckedIOException {
        Uncheck.accept((IOIntConsumer & Serializable)x$0 -> super.mark(x$0), readAheadLimit);
    }

    @Override
    public int read() throws UncheckedIOException {
        return Uncheck.getAsInt((IOIntSupplier & Serializable)() -> super.read());
    }

    @Override
    public int read(char[] cbuf) throws UncheckedIOException {
        return (Integer)Uncheck.apply((IOFunction<char[], Integer> & Serializable)x$0 -> super.read((char[])x$0), cbuf);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws UncheckedIOException {
        return (Integer)Uncheck.apply((IOTriFunction<char[], Integer, Integer, Integer> & Serializable)(x$0, x$1, x$2) -> super.read((char[])x$0, (int)x$1, (int)x$2), cbuf, off, len);
    }

    @Override
    public int read(CharBuffer target) throws UncheckedIOException {
        return (Integer)Uncheck.apply((IOFunction<CharBuffer, Integer> & Serializable)x$0 -> super.read((CharBuffer)x$0), target);
    }

    @Override
    public boolean ready() throws UncheckedIOException {
        return Uncheck.getAsBoolean((IOBooleanSupplier & Serializable)() -> super.ready());
    }

    @Override
    public void reset() throws UncheckedIOException {
        Uncheck.run((IORunnable & Serializable)() -> super.reset());
    }

    @Override
    public long skip(long n) throws UncheckedIOException {
        return (Long)Uncheck.apply((IOFunction<Long, Long> & Serializable)x$0 -> super.skip((long)x$0), n);
    }

    public static class Builder
    extends AbstractStreamBuilder<UncheckedFilterReader, Builder> {
        @Override
        public UncheckedFilterReader get() {
            return (UncheckedFilterReader)Uncheck.get((IOSupplier<UncheckedFilterReader> & Serializable)() -> new UncheckedFilterReader(this));
        }
    }
}

