/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import org.apache.commons.io.build.AbstractStreamBuilder;
import org.apache.commons.io.function.IOFunction;
import org.apache.commons.io.function.IOIntSupplier;
import org.apache.commons.io.function.IORunnable;
import org.apache.commons.io.function.IOSupplier;
import org.apache.commons.io.function.IOTriFunction;
import org.apache.commons.io.function.Uncheck;

public final class UncheckedFilterInputStream
extends FilterInputStream {
    public static Builder builder() {
        return new Builder();
    }

    private UncheckedFilterInputStream(Builder builder) throws IOException {
        super(builder.getInputStream());
    }

    @Override
    public int available() throws UncheckedIOException {
        return Uncheck.getAsInt((IOIntSupplier & Serializable)() -> super.available());
    }

    @Override
    public void close() throws UncheckedIOException {
        Uncheck.run((IORunnable & Serializable)() -> super.close());
    }

    @Override
    public int read() throws UncheckedIOException {
        return Uncheck.getAsInt((IOIntSupplier & Serializable)() -> super.read());
    }

    @Override
    public int read(byte[] b) throws UncheckedIOException {
        return (Integer)Uncheck.apply((IOFunction<byte[], Integer> & Serializable)x$0 -> super.read((byte[])x$0), b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws UncheckedIOException {
        return (Integer)Uncheck.apply((IOTriFunction<byte[], Integer, Integer, Integer> & Serializable)(x$0, x$1, x$2) -> super.read((byte[])x$0, (int)x$1, (int)x$2), b, off, len);
    }

    @Override
    public synchronized void reset() throws UncheckedIOException {
        Uncheck.run((IORunnable & Serializable)() -> super.reset());
    }

    @Override
    public long skip(long n) throws UncheckedIOException {
        return (Long)Uncheck.apply((IOFunction<Long, Long> & Serializable)x$0 -> super.skip((long)x$0), n);
    }

    public static class Builder
    extends AbstractStreamBuilder<UncheckedFilterInputStream, Builder> {
        @Override
        public UncheckedFilterInputStream get() {
            return (UncheckedFilterInputStream)Uncheck.get((IOSupplier<UncheckedFilterInputStream> & Serializable)() -> new UncheckedFilterInputStream(this));
        }
    }
}

