/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.commons.io.file.NoopPathVisitor;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.PathVisitor;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.function.IOSupplier;
import org.gradle.internal.classpath.declarations.FileInterceptorsDeclaration;
import org.gradle.internal.classpath.declarations.NioFileInterceptors;

public class PathVisitorFileFilter
extends AbstractFileFilter {
    private final PathVisitor pathVisitor;

    public PathVisitorFileFilter(PathVisitor pathVisitor) {
        this.pathVisitor = pathVisitor == null ? NoopPathVisitor.INSTANCE : pathVisitor;
    }

    @Override
    public boolean accept(File file) {
        try {
            Path path = file.toPath();
            return this.visitFile(path, FileInterceptorsDeclaration.intercept_exists((File)file, (String)"org.apache.commons.io.filefilter.PathVisitorFileFilter") ? PathUtils.readBasicFileAttributes(path) : null) == FileVisitResult.CONTINUE;
        }
        catch (IOException e) {
            return this.handle(e) == FileVisitResult.CONTINUE;
        }
    }

    @Override
    public boolean accept(File dir, String name) {
        try {
            Path path = dir.toPath().resolve(name);
            return this.accept(path, PathUtils.readBasicFileAttributes(path)) == FileVisitResult.CONTINUE;
        }
        catch (IOException e) {
            return this.handle(e) == FileVisitResult.CONTINUE;
        }
    }

    @Override
    public FileVisitResult accept(Path path, BasicFileAttributes attributes) {
        return this.get((IOSupplier<FileVisitResult> & Serializable)() -> NioFileInterceptors.intercept_isDirectory((Path)path, (LinkOption[])new LinkOption[0], (String)"org.apache.commons.io.filefilter.PathVisitorFileFilter") ? this.pathVisitor.postVisitDirectory(path, null) : this.visitFile(path, attributes));
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes attributes) throws IOException {
        return this.pathVisitor.visitFile(path, attributes);
    }
}

