/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.function.IOSupplier;
import org.gradle.internal.classpath.declarations.FileInterceptorsDeclaration;
import org.gradle.internal.classpath.declarations.NioFileInterceptors;

public class EmptyFileFilter
extends AbstractFileFilter
implements Serializable {
    public static final IOFileFilter EMPTY = new EmptyFileFilter();
    public static final IOFileFilter NOT_EMPTY = EMPTY.negate();
    private static final long serialVersionUID = 3631422087512832211L;

    protected EmptyFileFilter() {
    }

    @Override
    public boolean accept(File file) {
        if (file == null) {
            return true;
        }
        if (FileInterceptorsDeclaration.intercept_isDirectory((File)file, (String)"org.apache.commons.io.filefilter.EmptyFileFilter")) {
            Object[] files = FileInterceptorsDeclaration.intercept_listFiles((File)file, (String)"org.apache.commons.io.filefilter.EmptyFileFilter");
            return IOUtils.length(files) == 0;
        }
        return FileInterceptorsDeclaration.intercept_length((File)file, (String)"org.apache.commons.io.filefilter.EmptyFileFilter") == 0L;
    }

    @Override
    public FileVisitResult accept(Path file, BasicFileAttributes attributes) {
        if (file == null) {
            return this.toFileVisitResult(true);
        }
        return this.get((IOSupplier<FileVisitResult> & Serializable)() -> {
            if (NioFileInterceptors.intercept_isDirectory((Path)file, (LinkOption[])new LinkOption[0], (String)"org.apache.commons.io.filefilter.EmptyFileFilter")) {
                try (Stream stream = NioFileInterceptors.intercept_list((Path)file, (String)"org.apache.commons.io.filefilter.EmptyFileFilter");){
                    FileVisitResult fileVisitResult = this.toFileVisitResult(!stream.findFirst().isPresent());
                    return fileVisitResult;
                }
            }
            return this.toFileVisitResult(Files.size(file) == 0L);
        });
    }
}

