/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.apache.commons.io.function.IOBiFunction;
import org.apache.commons.io.function.IOFunction;
import org.apache.commons.io.function.IOTriFunction;
import org.apache.commons.io.function.Uncheck;
import org.gradle.internal.classpath.declarations.NioFileInterceptors;

public final class FilesUncheck {
    public static long copy(InputStream in, Path target, CopyOption ... options) {
        return (Long)Uncheck.apply(Files::copy, in, target, options);
    }

    public static long copy(Path source, OutputStream out) {
        return (Long)Uncheck.apply(Files::copy, source, out);
    }

    public static Path copy(Path source, Path target, CopyOption ... options) {
        return (Path)Uncheck.apply(Files::copy, source, target, options);
    }

    public static Path createDirectories(Path dir, FileAttribute<?> ... attrs) {
        return (Path)Uncheck.apply(Files::createDirectories, dir, attrs);
    }

    public static Path createDirectory(Path dir, FileAttribute<?> ... attrs) {
        return (Path)Uncheck.apply(Files::createDirectory, dir, attrs);
    }

    public static Path createFile(Path path, FileAttribute<?> ... attrs) {
        return (Path)Uncheck.apply(Files::createFile, path, attrs);
    }

    public static Path createLink(Path link, Path existing) {
        return (Path)Uncheck.apply(Files::createLink, link, existing);
    }

    public static Path createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) {
        return (Path)Uncheck.apply(Files::createSymbolicLink, link, target, attrs);
    }

    public static Path createTempDirectory(Path dir, String prefix, FileAttribute<?> ... attrs) {
        return (Path)Uncheck.apply(Files::createTempDirectory, dir, prefix, attrs);
    }

    public static Path createTempDirectory(String prefix, FileAttribute<?> ... attrs) {
        return (Path)Uncheck.apply(Files::createTempDirectory, prefix, attrs);
    }

    public static Path createTempFile(Path dir, String prefix, String suffix, FileAttribute<?> ... attrs) {
        return (Path)Uncheck.apply(Files::createTempFile, dir, prefix, suffix, attrs);
    }

    public static Path createTempFile(String prefix, String suffix, FileAttribute<?> ... attrs) {
        return (Path)Uncheck.apply(Files::createTempFile, prefix, suffix, attrs);
    }

    public static void delete(Path path) {
        Uncheck.accept(Files::delete, path);
    }

    public static boolean deleteIfExists(Path path) {
        return (Boolean)Uncheck.apply(Files::deleteIfExists, path);
    }

    public static Stream<Path> find(Path start, int maxDepth, BiPredicate<Path, BasicFileAttributes> matcher, FileVisitOption ... options) {
        return (Stream)Uncheck.apply(Files::find, start, maxDepth, matcher, options);
    }

    public static Object getAttribute(Path path, String attribute, LinkOption ... options) {
        return Uncheck.apply(Files::getAttribute, path, attribute, options);
    }

    public static FileStore getFileStore(Path path) {
        return (FileStore)Uncheck.apply(Files::getFileStore, path);
    }

    public static FileTime getLastModifiedTime(Path path, LinkOption ... options) {
        return (FileTime)Uncheck.apply(Files::getLastModifiedTime, path, options);
    }

    public static UserPrincipal getOwner(Path path, LinkOption ... options) {
        return (UserPrincipal)Uncheck.apply(Files::getOwner, path, options);
    }

    public static Set<PosixFilePermission> getPosixFilePermissions(Path path, LinkOption ... options) {
        return (Set)Uncheck.apply(Files::getPosixFilePermissions, path, options);
    }

    public static boolean isHidden(Path path) {
        return (Boolean)Uncheck.apply(Files::isHidden, path);
    }

    public static boolean isSameFile(Path path, Path path2) {
        return (Boolean)Uncheck.apply(Files::isSameFile, path, path2);
    }

    public static Stream<String> lines(Path path2) {
        return (Stream)Uncheck.apply((IOFunction<Path, Stream> & Serializable)path -> NioFileInterceptors.intercept_lines((Path)path, (String)"org.apache.commons.io.file.FilesUncheck"), path2);
    }

    public static Stream<String> lines(Path path2, Charset cs) {
        return (Stream)Uncheck.apply((IOBiFunction<Path, Charset, Stream> & Serializable)(path, charset) -> NioFileInterceptors.intercept_lines((Path)path, (Charset)charset, (String)"org.apache.commons.io.file.FilesUncheck"), path2, cs);
    }

    public static Stream<Path> list(Path dir) {
        return (Stream)Uncheck.apply((IOFunction<Path, Stream> & Serializable)path -> NioFileInterceptors.intercept_list((Path)path, (String)"org.apache.commons.io.file.FilesUncheck"), dir);
    }

    public static Path move(Path source, Path target, CopyOption ... options) {
        return (Path)Uncheck.apply(Files::move, source, target, options);
    }

    public static BufferedReader newBufferedReader(Path path2) {
        return (BufferedReader)Uncheck.apply((IOFunction<Path, BufferedReader> & Serializable)path -> NioFileInterceptors.intercept_newBufferedReader((Path)path, (String)"org.apache.commons.io.file.FilesUncheck"), path2);
    }

    public static BufferedReader newBufferedReader(Path path2, Charset cs) {
        return (BufferedReader)Uncheck.apply((IOBiFunction<Path, Charset, BufferedReader> & Serializable)(path, charset) -> NioFileInterceptors.intercept_newBufferedReader((Path)path, (Charset)charset, (String)"org.apache.commons.io.file.FilesUncheck"), path2, cs);
    }

    public static BufferedWriter newBufferedWriter(Path path, Charset cs, OpenOption ... options) {
        return (BufferedWriter)Uncheck.apply(Files::newBufferedWriter, path, cs, options);
    }

    public static BufferedWriter newBufferedWriter(Path path, OpenOption ... options) {
        return (BufferedWriter)Uncheck.apply(Files::newBufferedWriter, path, options);
    }

    public static SeekableByteChannel newByteChannel(Path path2, OpenOption ... options) {
        return (SeekableByteChannel)Uncheck.apply((IOBiFunction<Path, OpenOption[], SeekableByteChannel> & Serializable)(path, openOptionArray) -> NioFileInterceptors.intercept_newByteChannel((Path)path, (OpenOption[])openOptionArray, (String)"org.apache.commons.io.file.FilesUncheck"), path2, options);
    }

    public static SeekableByteChannel newByteChannel(Path path2, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) {
        return (SeekableByteChannel)Uncheck.apply((IOTriFunction<Path, Set, FileAttribute[], SeekableByteChannel> & Serializable)(path, set, fileAttributeArray) -> NioFileInterceptors.intercept_newByteChannel((Path)path, (Set)set, (FileAttribute[])fileAttributeArray, (String)"org.apache.commons.io.file.FilesUncheck"), path2, options, attrs);
    }

    public static DirectoryStream<Path> newDirectoryStream(Path dir) {
        return (DirectoryStream)Uncheck.apply((IOFunction<Path, DirectoryStream> & Serializable)path -> NioFileInterceptors.intercept_newDirectoryStream((Path)path, (String)"org.apache.commons.io.file.FilesUncheck"), dir);
    }

    public static DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter2) {
        return (DirectoryStream)Uncheck.apply((IOBiFunction<Path, DirectoryStream.Filter, DirectoryStream> & Serializable)(path, filter) -> NioFileInterceptors.intercept_newDirectoryStream((Path)path, (DirectoryStream.Filter)filter, (String)"org.apache.commons.io.file.FilesUncheck"), dir, filter2);
    }

    public static DirectoryStream<Path> newDirectoryStream(Path dir, String glob) {
        return (DirectoryStream)Uncheck.apply((IOBiFunction<Path, String, DirectoryStream> & Serializable)(path, string) -> NioFileInterceptors.intercept_newDirectoryStream((Path)path, (String)string, (String)"org.apache.commons.io.file.FilesUncheck"), dir, glob);
    }

    public static InputStream newInputStream(Path path2, OpenOption ... options) {
        return (InputStream)Uncheck.apply((IOBiFunction<Path, OpenOption[], InputStream> & Serializable)(path, openOptionArray) -> NioFileInterceptors.intercept_newInputStream((Path)path, (OpenOption[])openOptionArray, (String)"org.apache.commons.io.file.FilesUncheck"), path2, options);
    }

    public static OutputStream newOutputStream(Path path, OpenOption ... options) {
        return (OutputStream)Uncheck.apply(Files::newOutputStream, path, options);
    }

    public static String probeContentType(Path path2) {
        return (String)Uncheck.apply((IOFunction<Path, String> & Serializable)path -> NioFileInterceptors.intercept_probeContentType((Path)path, (String)"org.apache.commons.io.file.FilesUncheck"), path2);
    }

    public static byte[] readAllBytes(Path path2) {
        return (byte[])Uncheck.apply((IOFunction<Path, byte[]> & Serializable)path -> NioFileInterceptors.intercept_readAllBytes((Path)path, (String)"org.apache.commons.io.file.FilesUncheck"), path2);
    }

    public static List<String> readAllLines(Path path2) {
        return (List)Uncheck.apply((IOFunction<Path, List> & Serializable)path -> NioFileInterceptors.intercept_readAllLines((Path)path, (String)"org.apache.commons.io.file.FilesUncheck"), path2);
    }

    public static List<String> readAllLines(Path path2, Charset cs) {
        return (List)Uncheck.apply((IOBiFunction<Path, Charset, List> & Serializable)(path, charset) -> NioFileInterceptors.intercept_readAllLines((Path)path, (Charset)charset, (String)"org.apache.commons.io.file.FilesUncheck"), path2, cs);
    }

    public static <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) {
        return (A)((BasicFileAttributes)Uncheck.apply(Files::readAttributes, path, type, options));
    }

    public static Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) {
        return (Map)Uncheck.apply(Files::readAttributes, path, attributes, options);
    }

    public static Path readSymbolicLink(Path link) {
        return (Path)Uncheck.apply(Files::readSymbolicLink, link);
    }

    public static Path setAttribute(Path path, String attribute, Object value, LinkOption ... options) {
        return (Path)Uncheck.apply(Files::setAttribute, path, attribute, value, options);
    }

    public static Path setLastModifiedTime(Path path, FileTime time) {
        return (Path)Uncheck.apply(Files::setLastModifiedTime, path, time);
    }

    public static Path setOwner(Path path, UserPrincipal owner) {
        return (Path)Uncheck.apply(Files::setOwner, path, owner);
    }

    public static Path setPosixFilePermissions(Path path, Set<PosixFilePermission> perms) {
        return (Path)Uncheck.apply(Files::setPosixFilePermissions, path, perms);
    }

    public static long size(Path path) {
        return (Long)Uncheck.apply(Files::size, path);
    }

    public static Stream<Path> walk(Path start, FileVisitOption ... options) {
        return (Stream)Uncheck.apply(Files::walk, start, options);
    }

    public static Stream<Path> walk(Path start, int maxDepth, FileVisitOption ... options) {
        return (Stream)Uncheck.apply(Files::walk, start, maxDepth, options);
    }

    public static Path walkFileTree(Path start, FileVisitor<? super Path> visitor) {
        return (Path)Uncheck.apply(Files::walkFileTree, start, visitor);
    }

    public static Path walkFileTree(Path start, Set<FileVisitOption> options, int maxDepth, FileVisitor<? super Path> visitor) {
        return (Path)Uncheck.apply(Files::walkFileTree, start, options, maxDepth, visitor);
    }

    public static Path write(Path path, byte[] bytes, OpenOption ... options) {
        return (Path)Uncheck.apply(Files::write, path, bytes, options);
    }

    public static Path write(Path path, Iterable<? extends CharSequence> lines, Charset cs, OpenOption ... options) {
        return (Path)Uncheck.apply(Files::write, path, lines, cs, options);
    }

    public static Path write(Path path, Iterable<? extends CharSequence> lines, OpenOption ... options) {
        return (Path)Uncheck.apply(Files::write, path, lines, options);
    }

    private FilesUncheck() {
    }
}

