/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.comparator;

import java.io.File;
import java.io.Serializable;
import java.util.Comparator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.AbstractFileComparator;
import org.apache.commons.io.comparator.ReverseFileComparator;
import org.gradle.internal.classpath.declarations.FileInterceptorsDeclaration;

public class SizeFileComparator
extends AbstractFileComparator
implements Serializable {
    private static final long serialVersionUID = -1201561106411416190L;
    public static final Comparator<File> SIZE_COMPARATOR = new SizeFileComparator();
    public static final Comparator<File> SIZE_REVERSE = new ReverseFileComparator(SIZE_COMPARATOR);
    public static final Comparator<File> SIZE_SUMDIR_COMPARATOR = new SizeFileComparator(true);
    public static final Comparator<File> SIZE_SUMDIR_REVERSE = new ReverseFileComparator(SIZE_SUMDIR_COMPARATOR);
    private final boolean sumDirectoryContents;

    public SizeFileComparator() {
        this.sumDirectoryContents = false;
    }

    public SizeFileComparator(boolean sumDirectoryContents) {
        this.sumDirectoryContents = sumDirectoryContents;
    }

    @Override
    public int compare(File file1, File file2) {
        long size2;
        long size1 = FileInterceptorsDeclaration.intercept_isDirectory((File)file1, (String)"org.apache.commons.io.comparator.SizeFileComparator") ? (this.sumDirectoryContents && FileInterceptorsDeclaration.intercept_exists((File)file1, (String)"org.apache.commons.io.comparator.SizeFileComparator") ? FileUtils.sizeOfDirectory(file1) : 0L) : FileInterceptorsDeclaration.intercept_length((File)file1, (String)"org.apache.commons.io.comparator.SizeFileComparator");
        long result = size1 - (size2 = FileInterceptorsDeclaration.intercept_isDirectory((File)file2, (String)"org.apache.commons.io.comparator.SizeFileComparator") ? (this.sumDirectoryContents && FileInterceptorsDeclaration.intercept_exists((File)file2, (String)"org.apache.commons.io.comparator.SizeFileComparator") ? FileUtils.sizeOfDirectory(file2) : 0L) : FileInterceptorsDeclaration.intercept_length((File)file2, (String)"org.apache.commons.io.comparator.SizeFileComparator"));
        if (result < 0L) {
            return -1;
        }
        if (result > 0L) {
            return 1;
        }
        return 0;
    }

    @Override
    public String toString() {
        return super.toString() + "[sumDirectoryContents=" + this.sumDirectoryContents + "]";
    }
}

