/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.dtree.impurity;

import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenancable;
import java.util.Map;

public interface LabelImpurity
extends Configurable,
Provenancable<ConfiguredObjectProvenance> {
    public double impurityNormed(double[] var1);

    default public double impurityWeighted(double[] input) {
        double[] prob = new double[input.length];
        double sum = 0.0;
        for (double i : input) {
            sum += i;
        }
        for (int i = 0; i < input.length; ++i) {
            prob[i] = input[i] / sum;
        }
        return sum * this.impurityNormed(prob);
    }

    default public double impurity(double[] input) {
        double[] prob = new double[input.length];
        double sum = 0.0;
        for (double i : input) {
            sum += i;
        }
        for (int i = 0; i < input.length; ++i) {
            prob[i] = input[i] / sum;
        }
        return this.impurityNormed(prob);
    }

    default public double impurityWeighted(float[] input) {
        int i;
        double[] prob = new double[input.length];
        double sum = 0.0;
        for (i = 0; i < input.length; ++i) {
            float f = input[i];
            sum += (double)f;
        }
        for (i = 0; i < input.length; ++i) {
            prob[i] = (double)input[i] / sum;
        }
        return sum * this.impurityNormed(prob);
    }

    default public double impurity(float[] input) {
        double[] prob = new double[input.length];
        double sum = 0.0;
        float[] fArray = input;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            double i2 = fArray[i];
            sum += i2;
        }
        for (int i = 0; i < input.length; ++i) {
            prob[i] = (double)input[i] / sum;
        }
        return this.impurityNormed(prob);
    }

    default public double impurity(int[] input) {
        double[] prob = new double[input.length];
        int sum = 0;
        for (int i : input) {
            sum += i;
        }
        double sumFloat = sum;
        for (int i = 0; i < input.length; ++i) {
            prob[i] = (double)input[i] / sumFloat;
        }
        return this.impurityNormed(prob);
    }

    default public double impurity(Map<String, Double> counts) {
        double[] prob = new double[counts.size()];
        double sum = 0.0;
        int i = 0;
        for (Map.Entry<String, Double> e : counts.entrySet()) {
            sum += e.getValue().doubleValue();
            prob[i] = e.getValue();
            ++i;
        }
        int j = 0;
        while (j < prob.length) {
            int n = j++;
            prob[n] = prob[n] / sum;
        }
        return this.impurityNormed(prob);
    }
}

