/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.dtree.impl;

import com.oracle.labs.mlrg.olcut.util.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tribuo.classification.dtree.impl.InvertedFeature;
import org.tribuo.common.tree.impl.IntArrayContainer;
import org.tribuo.util.Util;

class TreeFeature
implements Iterable<InvertedFeature>,
Serializable {
    private final int id;
    private final List<InvertedFeature> feature;
    private final Map<Double, InvertedFeature> valueMap;
    private final int numLabels;
    private final int[] labels;
    private final float[] weights;
    private boolean sorted = true;

    TreeFeature(int id, int numLabels, int[] labels, float[] weights) {
        this.id = id;
        this.numLabels = numLabels;
        this.feature = new ArrayList<InvertedFeature>();
        this.valueMap = new HashMap<Double, InvertedFeature>();
        this.labels = labels;
        this.weights = weights;
    }

    private TreeFeature(int id, int numLabels, List<InvertedFeature> data) {
        this.id = id;
        this.numLabels = numLabels;
        this.feature = data;
        this.valueMap = null;
        this.labels = null;
        this.weights = null;
    }

    @Override
    public Iterator<InvertedFeature> iterator() {
        return this.feature.iterator();
    }

    public List<InvertedFeature> getFeature() {
        return this.feature;
    }

    public void observeValue(double value, int exampleID) {
        InvertedFeature f = this.valueMap.get(value);
        if (f == null) {
            f = new InvertedFeature(value, exampleID, this.numLabels, this.labels, this.weights);
            this.valueMap.put(value, f);
            this.feature.add(f);
            this.sorted = false;
        } else {
            f.add(exampleID);
        }
    }

    public void sort() {
        this.feature.sort(null);
        this.sorted = true;
    }

    public void fixSize() {
        this.feature.forEach(InvertedFeature::fixSize);
    }

    public float[] getWeightedLabelCounts() {
        float[] weightedLabelCounts = new float[this.numLabels];
        for (InvertedFeature f : this.feature) {
            Util.inPlaceAdd((float[])weightedLabelCounts, (float[])f.getWeightedLabelCounts());
        }
        return weightedLabelCounts;
    }

    public Pair<TreeFeature, TreeFeature> split(IntArrayContainer leftIndices, IntArrayContainer firstBuffer, IntArrayContainer secondBuffer) {
        if (!this.sorted) {
            throw new IllegalStateException("TreeFeature must be sorted before split is called");
        }
        ArrayList<InvertedFeature> leftFeatures = new ArrayList<InvertedFeature>();
        ArrayList<InvertedFeature> rightFeatures = new ArrayList<InvertedFeature>();
        firstBuffer.fill(leftIndices);
        for (InvertedFeature f : this.feature) {
            if (firstBuffer.size > 0) {
                Pair<InvertedFeature, InvertedFeature> split = f.split(firstBuffer, secondBuffer);
                IntArrayContainer tmp = secondBuffer;
                secondBuffer = firstBuffer;
                firstBuffer = tmp;
                InvertedFeature left = (InvertedFeature)split.getA();
                InvertedFeature right = (InvertedFeature)split.getB();
                if (left != null) {
                    leftFeatures.add(left);
                }
                if (right == null) continue;
                rightFeatures.add(right);
                continue;
            }
            rightFeatures.add(f);
        }
        return new Pair((Object)new TreeFeature(this.id, this.numLabels, leftFeatures), (Object)new TreeFeature(this.id, this.numLabels, rightFeatures));
    }

    public String toString() {
        return "TreeFeature(id=" + this.id + ",values=" + this.feature.toString() + ")";
    }
}

