/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.dtree;

import com.oracle.labs.mlrg.olcut.config.ConfigurationManager;
import com.oracle.labs.mlrg.olcut.config.Options;
import com.oracle.labs.mlrg.olcut.config.UsageException;
import java.io.IOException;
import java.util.logging.Logger;
import org.tribuo.Model;
import org.tribuo.Trainer;
import org.tribuo.classification.TrainTestHelper;
import org.tribuo.classification.dtree.CARTClassificationOptions;
import org.tribuo.classification.dtree.CARTClassificationTrainer;
import org.tribuo.data.DataOptions;

public class TrainTest {
    private static final Logger logger = Logger.getLogger(TrainTest.class.getName());

    public static void main(String[] args) throws IOException {
        TrainTestOptions o = new TrainTestOptions();
        try (ConfigurationManager cm = new ConfigurationManager(args, (Options)o);){
            CARTClassificationTrainer trainer = o.cartOptions.getTrainer();
            Model model = TrainTestHelper.run((ConfigurationManager)cm, (DataOptions)o.generalOptions, (Trainer)trainer);
            if (o.cartOptions.cartPrintTree) {
                logger.info(model.toString());
            }
        }
        catch (UsageException e) {
            logger.info(e.getMessage());
        }
    }

    public static class TrainTestOptions
    implements Options {
        public DataOptions generalOptions;
        public CARTClassificationOptions cartOptions;

        public String getOptionsDescription() {
            return "A simple train/test program for Classification trees.";
        }
    }
}

