/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.dtree;

import com.oracle.labs.mlrg.olcut.config.Option;
import org.tribuo.classification.ClassificationOptions;
import org.tribuo.classification.dtree.CARTClassificationTrainer;
import org.tribuo.classification.dtree.impurity.Entropy;
import org.tribuo.classification.dtree.impurity.GiniIndex;
import org.tribuo.classification.dtree.impurity.LabelImpurity;

public class CARTClassificationOptions
implements ClassificationOptions<CARTClassificationTrainer> {
    @Option(longName="cart-max-depth", usage="Maximum depth in the decision tree.")
    public int cartMaxDepth = 6;
    @Option(longName="cart-min-child-weight", usage="Minimum child weight.")
    public float cartMinChildWeight = 5.0f;
    @Option(longName="cart-min-impurity-decrease", usage="Minimum impurity decrease.")
    public float cartMinImpurityDecrease = 0.0f;
    @Option(longName="cart-split-fraction", usage="Fraction of features in split.")
    public float cartSplitFraction = 1.0f;
    @Option(longName="cart-random-split", usage="Whether to choose split points for features at random.")
    public boolean cartRandomSplit = false;
    @Option(longName="cart-impurity", usage="Impurity measure to use. Defaults to GINI.")
    public ImpurityType cartImpurity = ImpurityType.GINI;
    @Option(longName="cart-print-tree", usage="Prints the decision tree.")
    public boolean cartPrintTree;
    @Option(longName="cart-tree-algorithm", usage="Tree algorithm to use (options are CART).")
    public TreeType cartTreeAlgorithm = TreeType.CART;
    @Option(longName="cart-seed", usage="RNG seed.")
    public long cartSeed = 12345L;

    public String getOptionsDescription() {
        return "Options for decision/classification trees.";
    }

    public CARTClassificationTrainer getTrainer() {
        CARTClassificationTrainer trainer;
        LabelImpurity impurity;
        switch (this.cartImpurity) {
            case GINI: {
                impurity = new GiniIndex();
                break;
            }
            case ENTROPY: {
                impurity = new Entropy();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown impurity type " + (Object)((Object)this.cartImpurity));
            }
        }
        switch (this.cartTreeAlgorithm) {
            case CART: {
                trainer = new CARTClassificationTrainer(this.cartMaxDepth, this.cartMinChildWeight, this.cartMinImpurityDecrease, this.cartSplitFraction, this.cartRandomSplit, impurity, this.cartSeed);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown tree type " + (Object)((Object)this.cartTreeAlgorithm));
            }
        }
        return trainer;
    }

    public static enum ImpurityType {
        GINI,
        ENTROPY;

    }

    public static enum TreeType {
        CART;

    }
}

