/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement.global;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.CompilationUnit;
import it.unive.lisa.program.Global;
import it.unive.lisa.program.annotations.Annotation;
import it.unive.lisa.program.annotations.Annotations;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.program.cfg.statement.UnaryExpression;
import it.unive.lisa.program.language.hierarchytraversal.HierarcyTraversalStrategy;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.heap.AccessChild;
import it.unive.lisa.symbolic.heap.HeapDereference;
import it.unive.lisa.symbolic.value.Variable;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.Untyped;
import java.util.HashSet;
import java.util.Set;

public class AccessInstanceGlobal
extends UnaryExpression {
    private final String target;

    public AccessInstanceGlobal(CFG cfg, CodeLocation location, Expression receiver, String target) {
        super(cfg, location, "::", (Type)Untyped.INSTANCE, receiver);
        this.target = target;
        receiver.setParentStatement((Statement)this);
    }

    public Expression getReceiver() {
        return this.getSubExpression();
    }

    public String getTarget() {
        return this.target;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AccessInstanceGlobal other = (AccessInstanceGlobal)((Object)obj);
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }

    protected int compareSameClassAndParams(Statement o) {
        AccessInstanceGlobal other = (AccessInstanceGlobal)o;
        return this.target.compareTo(other.target);
    }

    public String toString() {
        return this.getSubExpression() + "::" + this.target;
    }

    public <A extends AbstractState<A>> AnalysisState<A> fwdUnarySemantics(InterproceduralAnalysis<A> interprocedural, AnalysisState<A> state, SymbolicExpression expr, StatementStore<A> expressions) throws SemanticException {
        HeapDereference container;
        CodeLocation loc = this.getLocation();
        AnalysisState result = state.bottom();
        boolean atLeastOne = false;
        Set types = state.getState().getRuntimeTypesOf(expr, (ProgramPoint)this, (SemanticOracle)state.getState());
        for (Object recType : types) {
            Type inner;
            if (!recType.isPointerType() || !(inner = recType.asPointerType().getInnerType()).isUnitType()) continue;
            container = new HeapDereference(inner, expr, loc);
            CompilationUnit unit = inner.asUnitType().getUnit();
            HashSet<CompilationUnit> seen = new HashSet<CompilationUnit>();
            HierarcyTraversalStrategy strategy = this.getProgram().getFeatures().getTraversalStrategy();
            for (CompilationUnit cu : strategy.traverse((Statement)this, unit)) {
                Global global;
                if (!seen.add(unit) || (global = cu.getInstanceGlobal(this.target, false)) == null) continue;
                Variable var = global.toSymbolicVariable(loc);
                AccessChild access = new AccessChild(var.getStaticType(), (SymbolicExpression)container, (SymbolicExpression)var, loc);
                result = (AnalysisState)result.lub((BaseLattice)state.smallStepSemantics((SymbolicExpression)access, (ProgramPoint)this));
                atLeastOne = true;
            }
        }
        if (atLeastOne) {
            return result;
        }
        HashSet<Type> rectypes = new HashSet<Type>();
        for (Type t : types) {
            if (!t.isPointerType()) continue;
            rectypes.add(t.asPointerType().getInnerType());
        }
        if (rectypes.isEmpty()) {
            return state.bottom();
        }
        Type rectype = Type.commonSupertype(rectypes, (Type)Untyped.INSTANCE);
        Variable var = new Variable((Type)Untyped.INSTANCE, this.target, new Annotations(new Annotation[0]), this.getLocation());
        container = new HeapDereference(rectype, expr, this.getLocation());
        AccessChild access = new AccessChild((Type)Untyped.INSTANCE, (SymbolicExpression)container, (SymbolicExpression)var, this.getLocation());
        return state.smallStepSemantics((SymbolicExpression)access, (ProgramPoint)this);
    }
}

