/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement.global;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.ConstantGlobal;
import it.unive.lisa.program.Global;
import it.unive.lisa.program.Unit;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.program.cfg.edge.Edge;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Variable;
import it.unive.lisa.util.datastructures.graph.Graph;
import it.unive.lisa.util.datastructures.graph.GraphVisitor;
import it.unive.lisa.util.datastructures.graph.Node;

public class AccessGlobal
extends Expression {
    private final Unit container;
    private final Global target;

    public AccessGlobal(CFG cfg, CodeLocation location, Unit container, Global target) {
        super(cfg, location, target.getStaticType());
        this.container = container;
        this.target = target;
    }

    public Unit getContainer() {
        return this.container;
    }

    public Global getTarget() {
        return this.target;
    }

    public <V> boolean accept(GraphVisitor<CFG, Statement, Edge, V> visitor, V tool) {
        return visitor.visit(tool, (Graph)this.getCFG(), (Node)this);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.container == null ? 0 : this.container.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AccessGlobal other = (AccessGlobal)((Object)obj);
        if (this.container == null ? other.container != null : !this.container.equals(other.container)) {
            return false;
        }
        return !(this.target == null ? other.target != null : !this.target.equals((Object)other.target));
    }

    protected int compareSameClass(Statement o) {
        AccessGlobal other = (AccessGlobal)o;
        int cmp = this.container.getName().compareTo(other.container.getName());
        if (cmp != 0) {
            return cmp;
        }
        return this.target.getName().compareTo(other.target.getName());
    }

    public String toString() {
        return this.container.getName() + "::" + this.target.getName();
    }

    public <A extends AbstractState<A>> AnalysisState<A> forwardSemantics(AnalysisState<A> entryState, InterproceduralAnalysis<A> interprocedural, StatementStore<A> expressions) throws SemanticException {
        if (this.target instanceof ConstantGlobal) {
            return entryState.smallStepSemantics((SymbolicExpression)((ConstantGlobal)this.target).getConstant(), (ProgramPoint)this);
        }
        return entryState.smallStepSemantics((SymbolicExpression)new Variable(this.target.getStaticType(), this.toString(), this.target.getAnnotations(), this.getLocation()), (ProgramPoint)this);
    }
}

