/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.interprocedural.context.recursion;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.OptimizedAnalyzedCFG;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.lattices.GenericMapLattice;
import it.unive.lisa.conf.FixpointConfiguration;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.interprocedural.InterproceduralAnalysisException;
import it.unive.lisa.interprocedural.OpenCallPolicy;
import it.unive.lisa.interprocedural.ScopeId;
import it.unive.lisa.interprocedural.callgraph.CallGraph;
import it.unive.lisa.interprocedural.context.ContextBasedAnalysis;
import it.unive.lisa.interprocedural.context.ContextSensitivityToken;
import it.unive.lisa.interprocedural.context.recursion.BaseCasesFinder;
import it.unive.lisa.interprocedural.context.recursion.Recursion;
import it.unive.lisa.program.Application;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.program.cfg.fixpoints.CFGFixpoint;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.program.cfg.statement.call.CFGCall;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.PushInv;
import it.unive.lisa.util.StringUtilities;
import it.unive.lisa.util.collections.workset.WorkingSet;
import it.unive.lisa.util.datastructures.graph.algorithms.FixpointException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecursionSolver<A extends AbstractState<A>>
extends ContextBasedAnalysis<A> {
    private static final Logger LOG = LogManager.getLogger(RecursionSolver.class);
    private final Recursion<A> recursion;
    private final boolean returnsVoid;
    private final Map<CFGCall, Pair<AnalysisState<A>, ContextSensitivityToken>> finalEntryStates;
    private final BaseCasesFinder<A> baseCases;
    private GenericMapLattice<CFGCall, AnalysisState<A>> previousApprox;
    private GenericMapLattice<CFGCall, AnalysisState<A>> recursiveApprox;
    private AnalysisState<A> base;

    public RecursionSolver(ContextBasedAnalysis<A> backing, Recursion<A> recursion) {
        super(backing);
        this.recursion = recursion;
        this.finalEntryStates = new HashMap<CFGCall, Pair<AnalysisState<A>, ContextSensitivityToken>>();
        this.returnsVoid = this.returnsVoid(recursion.getInvocation(), null);
        this.baseCases = new BaseCasesFinder<A>(backing, recursion, this.returnsVoid);
    }

    @Override
    public void init(Application app, CallGraph callgraph, OpenCallPolicy policy) throws InterproceduralAnalysisException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fixpoint(AnalysisState<A> entryState, Class<? extends WorkingSet<Statement>> fixpointWorkingSet, FixpointConfiguration conf) throws FixpointException {
        throw new UnsupportedOperationException();
    }

    @Override
    public AnalysisState<A> getAbstractResultOf(CFGCall call, AnalysisState<A> entryState, ExpressionSet[] parameters, StatementStore<A> expressions) throws SemanticException {
        boolean inRecursion = this.recursion.getMembers().contains(call.getCFG());
        if (inRecursion && call.getTargetedCFGs().contains(this.recursion.getRecursionHead())) {
            this.finalEntryStates.put(call, Pair.of(entryState, (Object)this.token));
            AnalysisState<A> approx = null;
            if (this.recursiveApprox.getMap() != null) {
                approx = (AnalysisState<A>)this.recursiveApprox.getMap().get(call);
            }
            if (approx == null) {
                approx = this.transferToCallsite(this.recursion.getInvocation(), call, this.base);
            }
            AnalysisState res = (AnalysisState)approx.lub(entryState);
            Identifier meta = call.getMetaVariable();
            if (!res.getState().knowsIdentifier(meta)) {
                PushInv inv = new PushInv(meta.getStaticType(), call.getLocation());
                res = res.assign(meta, (SymbolicExpression)inv, (ProgramPoint)call);
            }
            return res;
        }
        return super.getAbstractResultOf(call, entryState, parameters, expressions);
    }

    @Override
    protected boolean canShortcut(CFG cfg) {
        return !this.recursion.getMembers().contains(cfg);
    }

    @Override
    protected boolean shouldCheckForRecursions() {
        return false;
    }

    public void solve() throws SemanticException {
        int recursionCount = 0;
        Call start = this.recursion.getInvocation();
        Set<CFGCall> ends = this.finalEntryStates.keySet();
        CFGFixpoint.CompoundState<A> entryState = this.recursion.getEntryState();
        LOG.info("Solving recursion at " + start.getLocation() + " for context " + this.recursion.getInvocationToken());
        this.recursiveApprox = new GenericMapLattice((Lattice)entryState.postState.bottom());
        this.recursiveApprox = this.recursiveApprox.bottom();
        this.base = this.baseCases.find();
        Expression[] actuals = start.getParameters();
        ExpressionSet[] params = new ExpressionSet[actuals.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = ((AnalysisState)entryState.intermediateStates.getState((Object)actuals[i])).getComputedExpressions();
        }
        do {
            LOG.debug(StringUtilities.ordinal((int)(recursionCount + 1)) + " evaluation of recursive chain at " + start.getLocation());
            this.previousApprox = this.recursiveApprox;
            this.token = this.recursion.getInvocationToken();
            AnalysisState post = start.forwardSemanticsAux((InterproceduralAnalysis)this, entryState.postState, params, entryState.intermediateStates);
            for (CFGCall end : ends) {
                this.recursiveApprox = (GenericMapLattice)this.recursiveApprox.putState((Object)end, this.transferToCallsite(start, end, post));
            }
            if (this.conf.recursionWideningThreshold < 0) {
                this.recursiveApprox = (GenericMapLattice)this.previousApprox.lub(this.recursiveApprox);
                continue;
            }
            if (recursionCount == this.conf.recursionWideningThreshold) {
                this.recursiveApprox = (GenericMapLattice)this.previousApprox.widening(this.recursiveApprox);
                continue;
            }
            ++recursionCount;
            this.recursiveApprox = (GenericMapLattice)this.previousApprox.lub(this.recursiveApprox);
        } while (!this.recursiveApprox.lessOrEqual(this.previousApprox));
        if (this.conf.optimize) {
            for (CFGCall call : ends) {
                Pair<AnalysisState<A>, ContextSensitivityToken> pair = this.finalEntryStates.get(call);
                AnalysisState callEntry = (AnalysisState)pair.getLeft();
                ContextSensitivityToken callingToken = (ContextSensitivityToken)pair.getRight();
                OptimizedAnalyzedCFG caller = (OptimizedAnalyzedCFG)this.results.get(call.getCFG()).get((ScopeId)callingToken);
                CFGCall source = call;
                while (source.getSource() != null) {
                    source = source.getSource();
                }
                if (caller.hasPostStateOf((Statement)source)) continue;
                AnalysisState<A> local = this.transferToCallsite(start, call, this.base);
                AnalysisState returned = (AnalysisState)callEntry.lub((BaseLattice)((AnalysisState)((AnalysisState)this.recursiveApprox.getState((Object)call)).lub(local)));
                Identifier meta = call.getMetaVariable();
                if (!returned.getState().knowsIdentifier(meta)) {
                    PushInv inv = new PushInv(meta.getStaticType(), call.getLocation());
                    returned = returned.assign(meta, (SymbolicExpression)inv, (ProgramPoint)call);
                }
                caller.storePostStateOf((Statement)source, returned);
            }
        }
    }

    private AnalysisState<A> transferToCallsite(Call original, CFGCall destination, AnalysisState<A> state) throws SemanticException {
        AnalysisState res = state.bottom();
        Identifier meta = destination.getMetaVariable();
        if (this.returnsVoid) {
            res = state;
        } else {
            for (Identifier variable : original.getMetaVariables()) {
                res = (AnalysisState)res.lub((BaseLattice)state.assign(meta, (SymbolicExpression)variable, (ProgramPoint)original));
            }
        }
        if (!res.getState().knowsIdentifier(meta)) {
            PushInv inv = new PushInv(meta.getStaticType(), destination.getLocation());
            res = res.assign(meta, (SymbolicExpression)inv, (ProgramPoint)destination);
        }
        res = res.forgetIdentifiersIf(i -> i.canBeScoped() && !i.equals((Object)meta));
        return res;
    }
}

