/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.interprocedural.context.recursion;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.interprocedural.context.ContextSensitivityToken;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeMember;
import it.unive.lisa.program.cfg.fixpoints.CFGFixpoint;
import it.unive.lisa.program.cfg.statement.call.Call;
import java.util.Collection;

public class Recursion<A extends AbstractState<A>> {
    private final Call start;
    private final CFG head;
    private final Collection<CodeMember> members;
    private final ContextSensitivityToken invocationToken;
    private final CFGFixpoint.CompoundState<A> entryState;

    public Recursion(Call invocation, ContextSensitivityToken invocationToken, CFGFixpoint.CompoundState<A> entryState, CFG recursionHead, Collection<CodeMember> members) {
        this.start = invocation;
        this.head = recursionHead;
        this.members = members;
        this.invocationToken = invocationToken;
        this.entryState = entryState;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entryState == null ? 0 : this.entryState.hashCode());
        result = 31 * result + (this.head == null ? 0 : this.head.hashCode());
        result = 31 * result + (this.invocationToken == null ? 0 : this.invocationToken.hashCode());
        result = 31 * result + (this.members == null ? 0 : this.members.hashCode());
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Recursion other = (Recursion)obj;
        if (this.entryState == null ? other.entryState != null : !this.entryState.equals(other.entryState)) {
            return false;
        }
        if (this.head == null ? other.head != null : !this.head.equals(other.head)) {
            return false;
        }
        if (this.invocationToken == null ? other.invocationToken != null : !this.invocationToken.equals(other.invocationToken)) {
            return false;
        }
        if (this.members == null ? other.members != null : !this.members.equals(other.members)) {
            return false;
        }
        return !(this.start == null ? other.start != null : !this.start.equals((Object)other.start));
    }

    public Call getInvocation() {
        return this.start;
    }

    public CFG getRecursionHead() {
        return this.head;
    }

    public ContextSensitivityToken getInvocationToken() {
        return this.invocationToken;
    }

    public CFGFixpoint.CompoundState<A> getEntryState() {
        return this.entryState;
    }

    public Collection<CodeMember> getMembers() {
        return this.members;
    }

    public String toString() {
        return this.members.toString() + " (started at " + this.start.getLocation() + ")";
    }
}

