/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.interprocedural.context.recursion;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.conf.FixpointConfiguration;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.interprocedural.InterproceduralAnalysisException;
import it.unive.lisa.interprocedural.OpenCallPolicy;
import it.unive.lisa.interprocedural.callgraph.CallGraph;
import it.unive.lisa.interprocedural.context.ContextBasedAnalysis;
import it.unive.lisa.interprocedural.context.recursion.Recursion;
import it.unive.lisa.program.Application;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.program.cfg.fixpoints.CFGFixpoint;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.program.cfg.statement.call.CFGCall;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.util.collections.workset.WorkingSet;
import it.unive.lisa.util.datastructures.graph.algorithms.FixpointException;

public class BaseCasesFinder<A extends AbstractState<A>>
extends ContextBasedAnalysis<A> {
    private final Recursion<A> recursion;
    private final boolean returnsVoid;

    public BaseCasesFinder(ContextBasedAnalysis<A> backing, Recursion<A> recursion, boolean returnsVoid) {
        super(backing);
        this.recursion = recursion;
        this.returnsVoid = returnsVoid;
    }

    @Override
    public void init(Application app, CallGraph callgraph, OpenCallPolicy policy) throws InterproceduralAnalysisException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fixpoint(AnalysisState<A> entryState, Class<? extends WorkingSet<Statement>> fixpointWorkingSet, FixpointConfiguration conf) throws FixpointException {
        throw new UnsupportedOperationException();
    }

    @Override
    public AnalysisState<A> getAbstractResultOf(CFGCall call, AnalysisState<A> entryState, ExpressionSet[] parameters, StatementStore<A> expressions) throws SemanticException {
        boolean inRecursion = this.recursion.getMembers().contains(call.getCFG());
        if (inRecursion && call.getTargetedCFGs().contains(this.recursion.getRecursionHead())) {
            if (this.returnsVoid) {
                return entryState.bottom();
            }
            return entryState.bottom().smallStepSemantics((SymbolicExpression)call.getMetaVariable(), (ProgramPoint)call);
        }
        return super.getAbstractResultOf(call, entryState, parameters, expressions);
    }

    @Override
    protected boolean canShortcut(CFG cfg) {
        return !this.recursion.getMembers().contains(cfg);
    }

    @Override
    protected boolean shouldCheckForRecursions() {
        return false;
    }

    @Override
    protected boolean shouldStoreFixpointResults() {
        return false;
    }

    public AnalysisState<A> find() throws SemanticException {
        Call start = this.recursion.getInvocation();
        CFGFixpoint.CompoundState<A> entryState = this.recursion.getEntryState();
        this.token = this.recursion.getInvocationToken();
        Expression[] actuals = start.getParameters();
        ExpressionSet[] params = new ExpressionSet[actuals.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = ((AnalysisState)entryState.intermediateStates.getState((Object)actuals[i])).getComputedExpressions();
        }
        return start.forwardSemanticsAux((InterproceduralAnalysis)this, entryState.postState.withTopValues(), params, entryState.intermediateStates);
    }
}

