/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.interprocedural.context;

import it.unive.lisa.interprocedural.context.ContextSensitivityToken;
import it.unive.lisa.program.cfg.statement.call.CFGCall;
import it.unive.lisa.util.collections.CollectionUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class KDepthToken
implements ContextSensitivityToken {
    private final List<CFGCall> calls;
    private final int k;

    private KDepthToken(int k) {
        this.k = k;
        this.calls = Collections.emptyList();
    }

    private KDepthToken(int k, KDepthToken source, CFGCall newToken) {
        this.k = k;
        int oldlen = source.calls.size();
        if (oldlen < k) {
            this.calls = new ArrayList<CFGCall>(oldlen + 1);
            source.calls.forEach(this.calls::add);
            this.calls.add(newToken);
        } else {
            this.calls = new ArrayList<CFGCall>(k);
            source.calls.stream().skip(oldlen - k + 1).forEach(this.calls::add);
            this.calls.add(newToken);
        }
    }

    public static KDepthToken getSingleton(int k) {
        return new KDepthToken(k);
    }

    public String toString() {
        if (this.calls.isEmpty()) {
            return "<empty>";
        }
        return "[" + (String)this.calls.stream().map(call -> call.getLocation()).collect(new CollectionUtilities.StringCollector(", ")) + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KDepthToken other = (KDepthToken)obj;
        return !(this.calls == null ? other.calls != null : !this.calls.equals(other.calls));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.calls == null) {
            result = 31 * result;
        } else {
            for (CFGCall call : this.calls) {
                result = 31 * result + call.getLocation().hashCode();
            }
        }
        return result;
    }

    @Override
    public ContextSensitivityToken startingId() {
        return KDepthToken.getSingleton(this.k);
    }

    public boolean isStartingId() {
        return this.calls.isEmpty();
    }

    @Override
    public ContextSensitivityToken push(CFGCall c) {
        return new KDepthToken(this.k, this, c);
    }
}

