/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.interprocedural.context;

import it.unive.lisa.interprocedural.context.ContextSensitivityToken;
import it.unive.lisa.program.cfg.statement.call.CFGCall;
import it.unive.lisa.util.collections.CollectionUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FullStackToken
implements ContextSensitivityToken {
    private static final FullStackToken SINGLETON = new FullStackToken();
    private final List<CFGCall> calls;

    private FullStackToken() {
        this.calls = Collections.emptyList();
    }

    private FullStackToken(FullStackToken source, CFGCall newToken) {
        this.calls = new ArrayList<CFGCall>(source.calls.size() + 1);
        source.calls.forEach(this.calls::add);
        this.calls.add(newToken);
    }

    public static FullStackToken getSingleton() {
        return SINGLETON;
    }

    public String toString() {
        if (this.calls.isEmpty()) {
            return "<empty>";
        }
        return "[" + (String)this.calls.stream().map(call -> call.getLocation()).collect(new CollectionUtilities.StringCollector(", ")) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.calls == null) {
            result = 31 * result;
        } else {
            for (CFGCall call : this.calls) {
                result = 31 * result + call.getLocation().hashCode();
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FullStackToken other = (FullStackToken)obj;
        return !(this.calls == null ? other.calls != null : !this.calls.equals(other.calls));
    }

    @Override
    public ContextSensitivityToken startingId() {
        return FullStackToken.getSingleton();
    }

    public boolean isStartingId() {
        return this.calls.isEmpty();
    }

    @Override
    public ContextSensitivityToken push(CFGCall c) {
        return new FullStackToken(this, c);
    }
}

