/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.interprocedural.context;

import it.unive.lisa.AnalysisExecutionException;
import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.AnalyzedCFG;
import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.FixpointInfo;
import it.unive.lisa.analysis.OptimizedAnalyzedCFG;
import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.conf.FixpointConfiguration;
import it.unive.lisa.interprocedural.CFGResults;
import it.unive.lisa.interprocedural.CallGraphBasedAnalysis;
import it.unive.lisa.interprocedural.FixpointResults;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.interprocedural.InterproceduralAnalysisException;
import it.unive.lisa.interprocedural.NoEntryPointException;
import it.unive.lisa.interprocedural.OpenCallPolicy;
import it.unive.lisa.interprocedural.ScopeId;
import it.unive.lisa.interprocedural.callgraph.CallGraph;
import it.unive.lisa.interprocedural.context.ContextSensitivityToken;
import it.unive.lisa.interprocedural.context.LastCallToken;
import it.unive.lisa.interprocedural.context.recursion.Recursion;
import it.unive.lisa.interprocedural.context.recursion.RecursionSolver;
import it.unive.lisa.logging.IterationLogger;
import it.unive.lisa.program.Application;
import it.unive.lisa.program.CodeElement;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeMember;
import it.unive.lisa.program.cfg.Parameter;
import it.unive.lisa.program.cfg.fixpoints.CFGFixpoint;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.program.cfg.statement.call.CFGCall;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.program.language.parameterassignment.ParameterAssigningStrategy;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.util.StringUtilities;
import it.unive.lisa.util.collections.workset.WorkingSet;
import it.unive.lisa.util.datastructures.graph.algorithms.FixpointException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContextBasedAnalysis<A extends AbstractState<A>>
extends CallGraphBasedAnalysis<A> {
    private static final Logger LOG = LogManager.getLogger(ContextBasedAnalysis.class);
    private final Collection<CodeMember> triggers;
    private boolean pendingRecursions;
    protected FixpointResults<A> results;
    private Class<? extends WorkingSet<Statement>> workingSet;
    protected ContextSensitivityToken token;
    protected FixpointConfiguration conf;

    public ContextBasedAnalysis() {
        this(LastCallToken.getSingleton());
    }

    public ContextBasedAnalysis(ContextSensitivityToken token) {
        this.token = token;
        this.triggers = new HashSet<CodeMember>();
    }

    protected ContextBasedAnalysis(ContextBasedAnalysis<A> other) {
        super(other);
        this.conf = other.conf;
        this.results = other.results;
        this.token = other.token;
        this.triggers = other.triggers;
        this.workingSet = other.workingSet;
        this.pendingRecursions = false;
    }

    @Override
    public void init(Application app, CallGraph callgraph, OpenCallPolicy policy) throws InterproceduralAnalysisException {
        super.init(app, callgraph, policy);
        this.conf = null;
        this.results = null;
        this.token = this.token.startingId();
        this.workingSet = null;
        this.pendingRecursions = false;
        this.triggers.clear();
    }

    public void fixpoint(AnalysisState<A> entryState, Class<? extends WorkingSet<Statement>> fixpointWorkingSet, FixpointConfiguration conf) throws FixpointException {
        this.workingSet = fixpointWorkingSet;
        this.conf = conf;
        this.results = null;
        if (this.app.getEntryPoints().isEmpty()) {
            throw new NoEntryPointException();
        }
        int iter = 0;
        ContextSensitivityToken empty = this.token.startingId();
        TreeSet<CFG> entryPoints = new TreeSet<CFG>((c1, c2) -> c1.getDescriptor().getLocation().compareTo((Object)c2.getDescriptor().getLocation()));
        entryPoints.addAll(this.app.getEntryPoints());
        do {
            LOG.info("Performing {} fixpoint iteration", (Object)StringUtilities.ordinal((int)(iter + 1)));
            this.triggers.clear();
            this.pendingRecursions = false;
            this.processEntrypoints(entryState, empty, entryPoints);
            if (this.pendingRecursions) {
                HashSet<Recursion<A>> recursions = new HashSet<Recursion<A>>();
                for (Collection rec : this.callgraph.getRecursions()) {
                    this.buildRecursion(entryState, recursions, rec);
                }
                this.solveRecursions(recursions);
            }
            Collection toRemove = this.callgraph.getCallersTransitively(this.triggers);
            toRemove.removeAll(this.triggers);
            toRemove.stream().filter(CFG.class::isInstance).map(CFG.class::cast).forEach(arg_0 -> this.results.forget(arg_0));
            ++iter;
        } while (!this.triggers.isEmpty());
    }

    private void solveRecursions(Set<Recursion<A>> recursions) {
        ArrayList<Recursion<A>> orderedRecursions = new ArrayList<Recursion<A>>(recursions.size());
        for (Recursion<A> recursion : recursions) {
            int pos;
            for (pos = 0; pos < orderedRecursions.size() && !((Recursion)orderedRecursions.get(pos)).getMembers().contains(recursion.getInvocation().getCFG()); ++pos) {
            }
            orderedRecursions.add(pos, recursion);
        }
        try {
            for (Recursion<Object> recursion : orderedRecursions) {
                new RecursionSolver<Object>(this, recursion).solve();
                this.triggers.addAll(recursion.getMembers());
            }
        }
        catch (SemanticException e) {
            throw new AnalysisExecutionException("Unable to solve one or more recursions", (Throwable)e);
        }
    }

    private void buildRecursion(AnalysisState<A> entryState, Set<Recursion<A>> recursions, Collection<CodeMember> rec) {
        Collection starters = this.callgraph.getCallSites(rec).stream().filter(site -> !rec.contains(site.getCFG())).collect(Collectors.toSet());
        for (Call starter : starters) {
            Set heads = this.callgraph.getCallees((CodeMember)starter.getCFG()).stream().filter(callee -> rec.contains(callee)).filter(CFG.class::isInstance).map(CFG.class::cast).collect(Collectors.toSet());
            HashSet<Pair> entries = new HashSet<Pair>();
            for (Map.Entry res : this.results.get(starter.getCFG())) {
                StatementStore params = new StatementStore(entryState.bottom());
                Expression[] parameters = starter.getParameters();
                if (this.conf.optimize) {
                    for (Expression actual : parameters) {
                        params.put((Statement)actual, ((OptimizedAnalyzedCFG)res.getValue()).getUnwindedAnalysisStateAfter((Statement)actual, this.conf));
                    }
                } else {
                    for (Expression actual : parameters) {
                        params.put((Statement)actual, ((AnalyzedCFG)res.getValue()).getAnalysisStateAfter((Statement)actual));
                    }
                }
                entries.add(Pair.of((Object)((ContextSensitivityToken)res.getKey()), (Object)CFGFixpoint.CompoundState.of((AnalysisState)((AnalysisState)params.getState((Object)parameters[parameters.length - 1])), (StatementStore)params)));
            }
            for (CFG head : heads) {
                for (Pair entry : entries) {
                    Recursion recursion = new Recursion(starter, (ContextSensitivityToken)entry.getLeft(), (CFGFixpoint.CompoundState)entry.getRight(), head, rec);
                    recursions.add(recursion);
                }
            }
        }
    }

    private void processEntrypoints(AnalysisState<A> entryState, ContextSensitivityToken empty, Collection<CFG> entryPoints) {
        for (CFG cfg : IterationLogger.iterate((Logger)LOG, entryPoints, (String)"Processing entrypoints", (String)"entries")) {
            try {
                if (this.results == null) {
                    OptimizedAnalyzedCFG graph = this.conf.optimize ? new OptimizedAnalyzedCFG(cfg, (ScopeId)empty, entryState.bottom(), (InterproceduralAnalysis)this) : new AnalyzedCFG(cfg, (ScopeId)empty, entryState);
                    CFGResults value = new CFGResults((AnalyzedCFG)graph);
                    this.results = new FixpointResults(value.top());
                }
                this.token = empty;
                AnalysisState<A> entryStateCFG = this.prepareEntryStateOfEntryPoint(entryState, cfg);
                this.results.putResult(cfg, (ScopeId)empty, cfg.fixpoint(entryStateCFG, (InterproceduralAnalysis)this, WorkingSet.of(this.workingSet), this.conf, (ScopeId)empty));
            }
            catch (SemanticException e) {
                throw new AnalysisExecutionException("Error while creating the entrystate for " + cfg, (Throwable)e);
            }
            catch (FixpointException e) {
                throw new AnalysisExecutionException("Error while computing fixpoint for entrypoint " + cfg, (Throwable)e);
            }
        }
    }

    public Collection<AnalyzedCFG<A>> getAnalysisResultsOf(CFG cfg) {
        if (this.results.contains(cfg)) {
            return ((CFGResults)this.results.getState((Object)cfg)).getAll();
        }
        return Collections.emptySet();
    }

    private AnalyzedCFG<A> computeFixpoint(CFG cfg, ContextSensitivityToken token, AnalysisState<A> entryState) throws FixpointException, SemanticException {
        AnalyzedCFG fixpointResult = cfg.fixpoint(entryState, (InterproceduralAnalysis)this, WorkingSet.of(this.workingSet), this.conf, (ScopeId)token);
        if (this.shouldStoreFixpointResults()) {
            Pair res = this.results.putResult(cfg, (ScopeId)token, fixpointResult);
            if (this.shouldStoreFixpointResults() && Boolean.TRUE.equals(res.getLeft())) {
                this.triggers.add((CodeMember)cfg);
            }
            fixpointResult = (AnalyzedCFG)res.getRight();
        }
        return fixpointResult;
    }

    protected boolean canShortcut(CFG cfg) {
        return true;
    }

    protected boolean shouldCheckForRecursions() {
        return true;
    }

    protected boolean shouldStoreFixpointResults() {
        return true;
    }

    public FixpointResults<A> getFixpointResults() {
        return this.results;
    }

    private Pair<AnalysisState<A>, ExpressionSet[]> prepareEntryState(CFGCall call, AnalysisState<A> entryState, ExpressionSet[] parameters, StatementStore<A> expressions, ScopeToken scope, CFG cfg) throws SemanticException {
        Parameter[] formals = cfg.getDescriptor().getFormals();
        Pair scoped = this.scope(entryState, scope, parameters);
        AnalysisState callState = (AnalysisState)scoped.getLeft();
        ExpressionSet[] locals = (ExpressionSet[])scoped.getRight();
        ParameterAssigningStrategy strategy = call.getProgram().getFeatures().getAssigningStrategy();
        Pair prepared = strategy.prepare((Call)call, callState, (InterproceduralAnalysis)this, expressions, formals, locals);
        return prepared;
    }

    public AnalysisState<A> getAbstractResultOf(CFGCall call, AnalysisState<A> entryState, ExpressionSet[] parameters, StatementStore<A> expressions) throws SemanticException {
        this.callgraph.registerCall(call);
        if (this.shouldCheckForRecursions()) {
            if (call.getTargetedCFGs().stream().anyMatch(call.getCFG()::equals) || this.callgraph.getCalleesTransitively(call.getTargets()).contains(call.getCFG())) {
                this.pendingRecursions = true;
                LOG.info("Found recursion at " + call.getLocation());
                if (this.returnsVoid((Call)call, null)) {
                    return entryState.bottom();
                }
                return new AnalysisState((AbstractState)entryState.getState().bottom(), (SymbolicExpression)call.getMetaVariable(), FixpointInfo.BOTTOM);
            }
        }
        ContextSensitivityToken callerToken = this.token;
        this.token = this.token.push(call);
        ScopeToken scope = new ScopeToken((CodeElement)call);
        AnalysisState result = entryState.bottom();
        for (CFG cfg : call.getTargetedCFGs()) {
            AnalysisState exitState;
            CFGResults localResults = this.results.get(cfg);
            AnalyzedCFG states = localResults == null ? null : localResults.get((ScopeId)this.token);
            Pair<AnalysisState<A>, ExpressionSet[]> prepared = this.prepareEntryState(call, entryState, parameters, expressions, scope, cfg);
            if (this.canShortcut(cfg) && states != null && ((AnalysisState)prepared.getLeft()).lessOrEqual((BaseLattice)states.getEntryState())) {
                exitState = states.getExitState();
            } else {
                AnalyzedCFG<A> fixpointResult = null;
                try {
                    fixpointResult = this.computeFixpoint(cfg, this.token, (AnalysisState)prepared.getLeft());
                }
                catch (FixpointException e) {
                    throw new SemanticException("Exception during the interprocedural analysis", (Throwable)e);
                }
                exitState = fixpointResult.getExitState();
            }
            result = (AnalysisState)result.lub((BaseLattice)this.unscope(call, scope, exitState));
        }
        this.token = callerToken;
        return result;
    }
}

