/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.interprocedural;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.AnalyzedCFG;
import it.unive.lisa.analysis.OptimizedAnalyzedCFG;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.symbols.SymbolAliasing;
import it.unive.lisa.conf.FixpointConfiguration;
import it.unive.lisa.interprocedural.CFGResults;
import it.unive.lisa.interprocedural.FixpointResults;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.interprocedural.InterproceduralAnalysisException;
import it.unive.lisa.interprocedural.OpenCallPolicy;
import it.unive.lisa.interprocedural.ScopeId;
import it.unive.lisa.interprocedural.UniqueScope;
import it.unive.lisa.interprocedural.callgraph.CallGraph;
import it.unive.lisa.interprocedural.callgraph.CallResolutionException;
import it.unive.lisa.logging.IterationLogger;
import it.unive.lisa.program.Application;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.Parameter;
import it.unive.lisa.program.cfg.statement.Assignment;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.program.cfg.statement.VariableRef;
import it.unive.lisa.program.cfg.statement.call.CFGCall;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.program.cfg.statement.call.OpenCall;
import it.unive.lisa.program.cfg.statement.call.UnresolvedCall;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.collections.workset.WorkingSet;
import it.unive.lisa.util.datastructures.graph.algorithms.FixpointException;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModularWorstCaseAnalysis<A extends AbstractState<A>>
implements InterproceduralAnalysis<A> {
    private static final Logger LOG = LogManager.getLogger(ModularWorstCaseAnalysis.class);
    private static final ScopeId ID = new UniqueScope();
    private Application app;
    private OpenCallPolicy policy;
    private FixpointResults<A> results;

    public boolean needsCallGraph() {
        return false;
    }

    public void fixpoint(AnalysisState<A> entryState, Class<? extends WorkingSet<Statement>> fixpointWorkingSet, FixpointConfiguration conf) throws FixpointException {
        this.results = null;
        TreeSet all = new TreeSet((c1, c2) -> c1.getDescriptor().getLocation().compareTo((Object)c2.getDescriptor().getLocation()));
        all.addAll(this.app.getAllCFGs());
        for (CFG cfg : IterationLogger.iterate((Logger)LOG, all, (String)"Computing fixpoint over the whole program", (String)"cfgs")) {
            try {
                AnalysisState st = entryState.bottom();
                StatementStore store = new StatementStore(st);
                if (this.results == null) {
                    OptimizedAnalyzedCFG graph = conf.optimize ? new OptimizedAnalyzedCFG(cfg, ID, st, (InterproceduralAnalysis)this) : new AnalyzedCFG(cfg, ID, entryState);
                    CFGResults value = new CFGResults((AnalyzedCFG)graph);
                    this.results = new FixpointResults(value.top());
                }
                AnalysisState prepared = entryState;
                for (Parameter arg : cfg.getDescriptor().getFormals()) {
                    CodeLocation loc = arg.getLocation();
                    Assignment a = new Assignment(cfg, loc, (Expression)new VariableRef(cfg, loc, arg.getName()), arg.getStaticType().unknownValue(cfg, loc));
                    prepared = a.forwardSemantics(prepared, (InterproceduralAnalysis)this, store);
                }
                this.results.putResult(cfg, ID, cfg.fixpoint(prepared, (InterproceduralAnalysis)this, WorkingSet.of(fixpointWorkingSet), conf, ID));
            }
            catch (SemanticException e) {
                throw new FixpointException("Error while creating the entrystate for " + cfg, (Throwable)e);
            }
        }
    }

    public Collection<AnalyzedCFG<A>> getAnalysisResultsOf(CFG cfg) {
        return ((CFGResults)this.results.getState((Object)cfg)).getAll();
    }

    public AnalysisState<A> getAbstractResultOf(CFGCall call, AnalysisState<A> entryState, ExpressionSet[] parameters, StatementStore<A> expressions) throws SemanticException {
        OpenCall open = new OpenCall(call.getCFG(), call.getLocation(), call.getCallType(), call.getQualifier(), call.getTargetName(), call.getStaticType(), call.getParameters());
        return this.getAbstractResultOf(open, entryState, parameters, expressions);
    }

    public AnalysisState<A> getAbstractResultOf(OpenCall call, AnalysisState<A> entryState, ExpressionSet[] parameters, StatementStore<A> expressions) throws SemanticException {
        return this.policy.apply(call, entryState, parameters);
    }

    public void init(Application app, CallGraph callgraph, OpenCallPolicy policy) throws InterproceduralAnalysisException {
        this.app = app;
        this.policy = policy;
        this.results = null;
    }

    public Call resolve(UnresolvedCall call, Set<Type>[] types, SymbolAliasing aliasing) throws CallResolutionException {
        return new OpenCall(call);
    }

    public FixpointResults<A> getFixpointResults() {
        return this.results;
    }
}

