/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.interprocedural;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.symbols.SymbolAliasing;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.interprocedural.InterproceduralAnalysisException;
import it.unive.lisa.interprocedural.OpenCallPolicy;
import it.unive.lisa.interprocedural.callgraph.CallGraph;
import it.unive.lisa.interprocedural.callgraph.CallResolutionException;
import it.unive.lisa.program.Application;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.Parameter;
import it.unive.lisa.program.cfg.statement.Assignment;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.VariableRef;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.program.cfg.statement.call.OpenCall;
import it.unive.lisa.program.cfg.statement.call.UnresolvedCall;
import it.unive.lisa.type.Type;
import java.util.Set;

public abstract class CallGraphBasedAnalysis<A extends AbstractState<A>>
implements InterproceduralAnalysis<A> {
    protected CallGraph callgraph;
    protected Application app;
    protected OpenCallPolicy policy;

    protected CallGraphBasedAnalysis() {
    }

    protected CallGraphBasedAnalysis(CallGraphBasedAnalysis<A> other) {
        this.callgraph = other.callgraph;
        this.app = other.app;
        this.policy = other.policy;
    }

    public boolean needsCallGraph() {
        return true;
    }

    public void init(Application app, CallGraph callgraph, OpenCallPolicy policy) throws InterproceduralAnalysisException {
        this.callgraph = callgraph;
        this.app = app;
        this.policy = policy;
    }

    public Call resolve(UnresolvedCall call, Set<Type>[] types, SymbolAliasing aliasing) throws CallResolutionException {
        return this.callgraph.resolve(call, (Set[])types, aliasing);
    }

    public AnalysisState<A> prepareEntryStateOfEntryPoint(AnalysisState<A> entryState, CFG cfg) throws SemanticException {
        AnalysisState prepared = entryState;
        AnalysisState st = entryState.bottom();
        StatementStore store = new StatementStore(st);
        for (Parameter arg : cfg.getDescriptor().getFormals()) {
            CodeLocation loc = arg.getLocation();
            Assignment a = new Assignment(cfg, loc, (Expression)new VariableRef(cfg, loc, arg.getName()), arg.getStaticType().unknownValue(cfg, loc));
            prepared = a.forwardSemantics(prepared, (InterproceduralAnalysis)this, store);
        }
        return new AnalysisState(prepared.getState(), new ExpressionSet());
    }

    public AnalysisState<A> getAbstractResultOf(OpenCall call, AnalysisState<A> entryState, ExpressionSet[] parameters, StatementStore<A> expressions) throws SemanticException {
        return this.policy.apply(call, entryState, parameters);
    }
}

