/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.types;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.nonrelational.value.BaseNonRelationalTypeDomain;
import it.unive.lisa.analysis.nonrelational.value.TypeEnvironment;
import it.unive.lisa.analysis.types.InferredTypes;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.BinaryExpression;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.PushAny;
import it.unive.lisa.symbolic.value.PushInv;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.binary.TypeCast;
import it.unive.lisa.symbolic.value.operator.binary.TypeConv;
import it.unive.lisa.type.NullType;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.TypeSystem;
import it.unive.lisa.type.Untyped;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class StaticTypes
implements BaseNonRelationalTypeDomain<StaticTypes> {
    private static final StaticTypes BOTTOM = new StaticTypes(null, null);
    private final Type type;
    private final TypeSystem types;

    public StaticTypes() {
        this(null, (Type)Untyped.INSTANCE);
    }

    StaticTypes(TypeSystem types, Type type) {
        this.type = type;
        this.types = types;
    }

    public Set<Type> getRuntimeTypes() {
        if (this.isBottom()) {
            Collections.emptySet();
        }
        return this.type.allInstances(this.types);
    }

    public StaticTypes top() {
        return new StaticTypes(this.types, (Type)Untyped.INSTANCE);
    }

    public boolean isTop() {
        return this.type == Untyped.INSTANCE;
    }

    public StaticTypes bottom() {
        return BOTTOM;
    }

    public StructuredRepresentation representation() {
        if (this.isTop()) {
            return Lattice.topRepresentation();
        }
        if (this.isBottom()) {
            return Lattice.bottomRepresentation();
        }
        return new StringRepresentation(this.type.toString());
    }

    public StaticTypes evalIdentifier(Identifier id, TypeEnvironment<StaticTypes> environment, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        StaticTypes eval = (StaticTypes)super.evalIdentifier(id, environment, pp, oracle);
        if (!eval.isTop() && !eval.isBottom()) {
            return eval;
        }
        return new StaticTypes(pp.getProgram().getTypes(), id.getStaticType());
    }

    public StaticTypes evalPushAny(PushAny pushAny, ProgramPoint pp, SemanticOracle oracle) {
        return new StaticTypes(pp.getProgram().getTypes(), pushAny.getStaticType());
    }

    public StaticTypes evalPushInv(PushInv pushInv, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return new StaticTypes(pp.getProgram().getTypes(), pushInv.getStaticType());
    }

    public StaticTypes evalNullConstant(ProgramPoint pp, SemanticOracle oracle) {
        return new StaticTypes(pp.getProgram().getTypes(), (Type)NullType.INSTANCE);
    }

    public StaticTypes evalNonNullConstant(Constant constant, ProgramPoint pp, SemanticOracle oracle) {
        return new StaticTypes(pp.getProgram().getTypes(), constant.getStaticType());
    }

    public StaticTypes eval(ValueExpression expression, TypeEnvironment<StaticTypes> environment, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (expression instanceof BinaryExpression) {
            TypeSystem types = pp.getProgram().getTypes();
            BinaryExpression binary = (BinaryExpression)expression;
            if (binary.getOperator() instanceof TypeCast || binary.getOperator() instanceof TypeConv) {
                BaseNonRelationalTypeDomain left = null;
                BaseNonRelationalTypeDomain right = null;
                try {
                    left = this.eval((ValueExpression)binary.getLeft(), (TypeEnvironment)environment, pp, oracle);
                    right = this.eval((ValueExpression)binary.getRight(), (TypeEnvironment)environment, pp, oracle);
                }
                catch (ClassCastException e) {
                    throw new SemanticException(expression + " is not a value expression");
                }
                Set lelems = left.type.allInstances(types);
                Set relems = right.type.allInstances(types);
                Set inferred = binary.getOperator().typeInference(types, lelems, relems);
                if (inferred.isEmpty()) {
                    return BOTTOM;
                }
                return new StaticTypes(pp.getProgram().getTypes(), Type.commonSupertype((Collection)inferred, (Type)Untyped.INSTANCE));
            }
        }
        return new StaticTypes(pp.getProgram().getTypes(), expression.getStaticType());
    }

    public Satisfiability satisfiesBinaryExpression(BinaryOperator operator, StaticTypes left, StaticTypes right, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        TypeSystem types = pp.getProgram().getTypes();
        Set lelems = left.type.allInstances(types);
        Set relems = right.type.allInstances(types);
        return new InferredTypes().satisfiesBinaryExpression(operator, new InferredTypes(types, (Set<Type>)lelems), new InferredTypes(types, (Set<Type>)relems), pp, oracle);
    }

    public StaticTypes lubAux(StaticTypes other) throws SemanticException {
        return new StaticTypes(this.types, this.type.commonSupertype(other.type));
    }

    public boolean lessOrEqualAux(StaticTypes other) throws SemanticException {
        return this.type.canBeAssignedTo(other.type);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StaticTypes other = (StaticTypes)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

