/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.types;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.nonrelational.value.BaseNonRelationalTypeDomain;
import it.unive.lisa.analysis.nonrelational.value.TypeEnvironment;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.BinaryExpression;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.PushAny;
import it.unive.lisa.symbolic.value.PushInv;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonEq;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonNe;
import it.unive.lisa.symbolic.value.operator.binary.TypeCast;
import it.unive.lisa.symbolic.value.operator.binary.TypeCheck;
import it.unive.lisa.symbolic.value.operator.ternary.TernaryOperator;
import it.unive.lisa.symbolic.value.operator.unary.UnaryOperator;
import it.unive.lisa.type.NullType;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.TypeSystem;
import it.unive.lisa.util.representation.SetRepresentation;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class InferredTypes
implements BaseNonRelationalTypeDomain<InferredTypes> {
    private static final InferredTypes BOTTOM = new InferredTypes(null, Collections.emptySet());
    private final Set<Type> elements;
    private final boolean isTop;

    public InferredTypes() {
        this(null, (Set<Type>)null);
    }

    public InferredTypes(TypeSystem typeSystem, Type type) {
        this(typeSystem, Collections.singleton(type));
    }

    public InferredTypes(TypeSystem typeSystem, Set<Type> types) {
        this(typeSystem != null && types.equals(typeSystem.getTypes()), types);
    }

    public InferredTypes(boolean isTop, Set<Type> types) {
        this.elements = types;
        this.isTop = isTop;
    }

    public Set<Type> getRuntimeTypes() {
        if (this.elements == null) {
            Collections.emptySet();
        }
        return this.elements;
    }

    public InferredTypes top() {
        return new InferredTypes(true, null);
    }

    public boolean isTop() {
        return super.isTop() || this.isTop;
    }

    public InferredTypes bottom() {
        return BOTTOM;
    }

    public boolean isBottom() {
        return super.isBottom() || InferredTypes.BOTTOM.elements.equals(this.elements);
    }

    public String toString() {
        return this.representation().toString();
    }

    public StructuredRepresentation representation() {
        if (this.isTop()) {
            return Lattice.topRepresentation();
        }
        if (this.isBottom()) {
            return Lattice.bottomRepresentation();
        }
        return new SetRepresentation(this.elements, StringRepresentation::new);
    }

    public InferredTypes evalIdentifier(Identifier id, TypeEnvironment<InferredTypes> environment, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        InferredTypes eval = (InferredTypes)super.evalIdentifier(id, environment, pp, oracle);
        if (!eval.isTop()) {
            return eval;
        }
        TypeSystem types = pp.getProgram().getTypes();
        return new InferredTypes(types, (Set<Type>)id.getStaticType().allInstances(types));
    }

    public InferredTypes evalPushAny(PushAny pushAny, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        TypeSystem types = pp.getProgram().getTypes();
        if (pushAny.getStaticType().isUntyped()) {
            return new InferredTypes(true, (Set<Type>)types.getTypes());
        }
        return new InferredTypes(types, (Set<Type>)pushAny.getStaticType().allInstances(types));
    }

    public InferredTypes evalPushInv(PushInv pushInv, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return this.bottom();
    }

    public InferredTypes evalNullConstant(ProgramPoint pp, SemanticOracle oracle) {
        return new InferredTypes(pp.getProgram().getTypes(), (Type)NullType.INSTANCE);
    }

    public InferredTypes evalNonNullConstant(Constant constant, ProgramPoint pp, SemanticOracle oracle) {
        return new InferredTypes(pp.getProgram().getTypes(), constant.getStaticType());
    }

    public InferredTypes evalUnaryExpression(UnaryOperator operator, InferredTypes arg, ProgramPoint pp, SemanticOracle oracle) {
        Set<Type> elems;
        TypeSystem types = pp.getProgram().getTypes();
        Set inferred = operator.typeInference(types, elems = arg.isTop() ? types.getTypes() : arg.elements);
        if (inferred.isEmpty()) {
            return BOTTOM;
        }
        return new InferredTypes(types, (Set<Type>)inferred);
    }

    public InferredTypes evalBinaryExpression(BinaryOperator operator, InferredTypes left, InferredTypes right, ProgramPoint pp, SemanticOracle oracle) {
        Set<Type> relems;
        Set<Type> lelems;
        TypeSystem types = pp.getProgram().getTypes();
        Set inferred = operator.typeInference(types, lelems = left.isTop() ? types.getTypes() : left.elements, relems = right.isTop() ? types.getTypes() : right.elements);
        if (inferred.isEmpty()) {
            return BOTTOM;
        }
        return new InferredTypes(types, (Set<Type>)inferred);
    }

    public InferredTypes evalTernaryExpression(TernaryOperator operator, InferredTypes left, InferredTypes middle, InferredTypes right, ProgramPoint pp, SemanticOracle oracle) {
        Set<Type> relems;
        Set<Type> melems;
        Set<Type> lelems;
        TypeSystem types = pp.getProgram().getTypes();
        Set inferred = operator.typeInference(types, lelems = left.isTop() ? types.getTypes() : left.elements, melems = middle.isTop() ? types.getTypes() : middle.elements, relems = right.isTop() ? types.getTypes() : right.elements);
        if (inferred.isEmpty()) {
            return BOTTOM;
        }
        return new InferredTypes(types, (Set<Type>)inferred);
    }

    public Satisfiability satisfiesBinaryExpression(BinaryOperator operator, InferredTypes left, InferredTypes right, ProgramPoint pp, SemanticOracle oracle) {
        Set<Type> relems;
        TypeSystem types = pp.getProgram().getTypes();
        Set<Type> lelems = left.isTop() ? types.getTypes() : left.elements;
        Set<Type> set = relems = right.isTop() ? types.getTypes() : right.elements;
        if (operator == ComparisonEq.INSTANCE || operator == ComparisonNe.INSTANCE) {
            Set<Type> lfiltered = lelems.stream().filter(Type::isTypeTokenType).collect(Collectors.toSet());
            Set<Type> rfiltered = relems.stream().filter(Type::isTypeTokenType).collect(Collectors.toSet());
            if (lelems.size() != lfiltered.size() || relems.size() != rfiltered.size()) {
                return Satisfiability.UNKNOWN;
            }
            if (operator == ComparisonEq.INSTANCE) {
                if (lelems.size() == 1 && lelems.equals(relems)) {
                    return Satisfiability.SATISFIED;
                }
                if (CollectionUtils.intersection(lelems, relems).isEmpty() && !InferredTypes.typeTokensIntersect(lfiltered, rfiltered)) {
                    return Satisfiability.NOT_SATISFIED;
                }
                return Satisfiability.UNKNOWN;
            }
            if (CollectionUtils.intersection(lelems, relems).isEmpty() && !InferredTypes.typeTokensIntersect(lfiltered, rfiltered)) {
                return Satisfiability.SATISFIED;
            }
            if (lelems.size() == 1 && lelems.equals(relems)) {
                return Satisfiability.NOT_SATISFIED;
            }
            return Satisfiability.UNKNOWN;
        }
        if (operator == TypeCheck.INSTANCE) {
            if (this.evalBinaryExpression((BinaryOperator)TypeCast.INSTANCE, left, right, pp, oracle).isBottom()) {
                return Satisfiability.NOT_SATISFIED;
            }
            AtomicBoolean mightFail = new AtomicBoolean();
            Set set2 = types.cast(lelems, relems, mightFail);
            if (lelems.equals(set2) && !mightFail.get()) {
                return Satisfiability.SATISFIED;
            }
            return Satisfiability.UNKNOWN;
        }
        return Satisfiability.UNKNOWN;
    }

    static boolean typeTokensIntersect(Set<Type> lfiltered, Set<Type> rfiltered) {
        for (Type l : lfiltered) {
            for (Type r : rfiltered) {
                if (CollectionUtils.intersection((Iterable)l.asTypeTokenType().getTypes(), (Iterable)r.asTypeTokenType().getTypes()).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public InferredTypes lubAux(InferredTypes other) throws SemanticException {
        HashSet<Type> lub = new HashSet<Type>(this.elements);
        lub.addAll(other.elements);
        return new InferredTypes(null, lub);
    }

    public boolean lessOrEqualAux(InferredTypes other) throws SemanticException {
        return other.elements.containsAll(this.elements);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        result = 31 * result + (this.isTop ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InferredTypes other = (InferredTypes)obj;
        if (this.elements == null ? other.elements != null : !this.elements.equals(other.elements)) {
            return false;
        }
        return this.isTop == other.isTop;
    }

    public InferredTypes evalTypeCast(BinaryExpression cast, InferredTypes left, InferredTypes right, ProgramPoint pp, SemanticOracle oracle) {
        TypeSystem types = pp.getProgram().getTypes();
        Set<Type> lelems = left.isTop() ? types.getTypes() : left.elements;
        Set<Type> relems = right.isTop() ? types.getTypes() : right.elements;
        Set inferred = cast.getOperator().typeInference(types, lelems, relems);
        if (inferred.isEmpty()) {
            return BOTTOM;
        }
        return new InferredTypes(types, (Set<Type>)inferred);
    }

    public InferredTypes evalTypeConv(BinaryExpression conv, InferredTypes left, InferredTypes right, ProgramPoint pp, SemanticOracle oracle) {
        TypeSystem types = pp.getProgram().getTypes();
        Set<Type> lelems = left.isTop() ? types.getTypes() : left.elements;
        Set<Type> relems = right.isTop() ? types.getTypes() : right.elements;
        Set inferred = conv.getOperator().typeInference(types, lelems, relems);
        if (inferred.isEmpty()) {
            return BOTTOM;
        }
        return new InferredTypes(types, (Set<Type>)inferred);
    }
}

