/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.traces;

import it.unive.lisa.analysis.traces.Branching;
import it.unive.lisa.analysis.traces.LoopIteration;
import it.unive.lisa.analysis.traces.LoopSummary;
import it.unive.lisa.analysis.traces.TraceToken;
import it.unive.lisa.program.cfg.ProgramPoint;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class ExecutionTrace {
    private static final TraceToken[] EMPTY_TRACE = new TraceToken[0];
    private final TraceToken[] tokens;

    public ExecutionTrace() {
        this.tokens = EMPTY_TRACE;
    }

    private ExecutionTrace(TraceToken[] tokens) {
        this.tokens = tokens;
    }

    public ExecutionTrace push(TraceToken token) {
        int len = this.tokens.length;
        TraceToken[] tokens = new TraceToken[len + 1];
        System.arraycopy(this.tokens, 0, tokens, 0, len);
        tokens[len] = token;
        return new ExecutionTrace(tokens);
    }

    public ExecutionTrace pop() {
        if (this.tokens.length == 0) {
            return this;
        }
        int len = this.tokens.length;
        TraceToken[] tokens = new TraceToken[len - 1];
        System.arraycopy(this.tokens, 0, tokens, 0, len - 1);
        return new ExecutionTrace(tokens);
    }

    public TraceToken getHead() {
        return this.tokens[this.tokens.length - 1];
    }

    public int numberOfBranches() {
        int count = 0;
        for (TraceToken token : this.tokens) {
            if (!(token instanceof Branching)) continue;
            ++count;
        }
        return count;
    }

    public TraceToken lastLoopTokenFor(ProgramPoint guard) {
        for (int i = this.tokens.length - 1; i >= 0; --i) {
            TraceToken tok = this.tokens[i];
            if (!(tok instanceof LoopSummary) && !(tok instanceof LoopIteration) || tok.getProgramPoint() != guard) continue;
            return tok;
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.tokens);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExecutionTrace other = (ExecutionTrace)obj;
        return Arrays.equals(this.tokens, other.tokens);
    }

    public String toString() {
        return "<" + StringUtils.join((Object[])this.tokens, (String)"::") + ">";
    }
}

