/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.taint;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.nonrelational.value.BaseNonRelationalValueDomain;
import it.unive.lisa.analysis.nonrelational.value.ValueEnvironment;
import it.unive.lisa.program.annotations.Annotation;
import it.unive.lisa.program.annotations.Annotations;
import it.unive.lisa.program.annotations.matcher.AnnotationMatcher;
import it.unive.lisa.program.annotations.matcher.BasicAnnotationMatcher;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.BinaryExpression;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.PushAny;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.ternary.TernaryOperator;
import it.unive.lisa.symbolic.value.operator.unary.UnaryOperator;

public abstract class BaseTaint<T extends BaseTaint<T>>
implements BaseNonRelationalValueDomain<T> {
    public static final Annotation TAINTED_ANNOTATION = new Annotation("lisa.taint.Tainted");
    public static final AnnotationMatcher TAINTED_MATCHER = new BasicAnnotationMatcher(TAINTED_ANNOTATION);
    public static final Annotation CLEAN_ANNOTATION = new Annotation("lisa.taint.Clean");
    public static final AnnotationMatcher CLEAN_MATCHER = new BasicAnnotationMatcher(CLEAN_ANNOTATION);

    protected abstract T tainted();

    protected abstract T clean();

    public abstract boolean isAlwaysTainted();

    public abstract boolean isPossiblyTainted();

    public boolean isAlwaysClean() {
        return !this.isPossiblyTainted() && !this.isBottom();
    }

    public boolean isPossiblyClean() {
        return !this.isAlwaysTainted();
    }

    protected T defaultApprox(Identifier id, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        Annotations annots = id.getAnnotations();
        if (annots.isEmpty()) {
            return (T)((BaseTaint)super.fixedVariable(id, pp, oracle));
        }
        if (annots.contains(TAINTED_MATCHER)) {
            return this.tainted();
        }
        if (annots.contains(CLEAN_MATCHER)) {
            return this.clean();
        }
        return (T)((BaseTaint)this.bottom());
    }

    public T fixedVariable(Identifier id, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        T def = this.defaultApprox(id, pp, oracle);
        if (!def.isBottom()) {
            return def;
        }
        return (T)((BaseTaint)super.fixedVariable(id, pp, oracle));
    }

    public T evalIdentifier(Identifier id, ValueEnvironment<T> environment, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        T def = this.defaultApprox(id, pp, oracle);
        if (!def.isBottom()) {
            return def;
        }
        return (T)((BaseTaint)super.evalIdentifier(id, environment, pp, oracle));
    }

    public T evalPushAny(PushAny pushAny, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return (T)((BaseTaint)this.top());
    }

    public T evalNullConstant(ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return this.clean();
    }

    public T evalNonNullConstant(Constant constant, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return this.clean();
    }

    public T evalUnaryExpression(UnaryOperator operator, T arg, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return arg;
    }

    public T evalBinaryExpression(BinaryOperator operator, T left, T right, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return (T)((BaseTaint)left.lub(right));
    }

    public T evalTernaryExpression(TernaryOperator operator, T left, T middle, T right, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return (T)((BaseTaint)((BaseTaint)left.lub(middle)).lub((BaseLattice)right));
    }

    public T evalTypeCast(BinaryExpression cast, T left, T right, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return left;
    }

    public T evalTypeConv(BinaryExpression conv, T left, T right, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return left;
    }

    public Satisfiability satisfies(ValueExpression expression, ValueEnvironment<T> environment, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return Satisfiability.UNKNOWN;
    }

    public ValueEnvironment<T> assume(ValueEnvironment<T> environment, ValueExpression expression, ProgramPoint src, ProgramPoint dest, SemanticOracle oracle) throws SemanticException {
        return environment;
    }
}

