/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.string.tarsis;

import it.unive.lisa.analysis.string.tarsis.RegexAutomaton;
import it.unive.lisa.util.datastructures.automaton.State;
import it.unive.lisa.util.datastructures.automaton.Transition;
import it.unive.lisa.util.datastructures.regex.RegularExpression;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.Vector;

public class StringSearcher {
    private final RegexAutomaton automaton;
    private String searchString;
    private boolean matching;

    public StringSearcher(RegexAutomaton origin) {
        this.automaton = origin;
        this.searchString = null;
        this.matching = false;
    }

    public Set<Vector<Transition<RegularExpression>>> searchInAllPaths(String toSearch) {
        HashSet<Vector<Transition<RegularExpression>>> collected = new HashSet<Vector<Transition<RegularExpression>>>();
        Set paths = this.automaton.getAllPaths();
        if (paths.size() == 0) {
            return collected;
        }
        for (List v : paths) {
            collected.addAll(this.searchInPath(v, toSearch));
        }
        return collected;
    }

    private Set<Vector<Transition<RegularExpression>>> searchInPath(List<State> v, String toSearch) {
        HashSet<Vector<Transition<RegularExpression>>> collected = new HashSet<Vector<Transition<RegularExpression>>>();
        if (v.size() == 1 && toSearch.length() == 1) {
            return this.handleSelfLoop(v, collected);
        }
        Vector<Transition<RegularExpression>> path = new Vector<Transition<RegularExpression>>();
        this.resetSearchState(path, toSearch);
        for (int i = 0; i < v.size() - 1; ++i) {
            State to;
            State from = v.get(i);
            SortedSet transitions = this.automaton.getAllTransitionsConnecting(from, to = v.get(i + 1));
            if (transitions.size() == 0) continue;
            boolean matched = false;
            for (Transition t : transitions) {
                if (this.matching) {
                    if (((RegularExpression)t.getSymbol()).is(this.searchString.substring(0, 1))) {
                        this.advanceSearch(path, (Transition<RegularExpression>)t);
                        matched = true;
                    } else {
                        this.resetSearchState(path, toSearch);
                        if (((RegularExpression)t.getSymbol()).is(this.searchString.substring(0, 1))) {
                            this.startSearch(path, (Transition<RegularExpression>)t);
                            matched = true;
                        }
                    }
                } else if (((RegularExpression)t.getSymbol()).is(this.searchString.substring(0, 1))) {
                    this.startSearch(path, (Transition<RegularExpression>)t);
                    matched = true;
                }
                if (!matched) continue;
                break;
            }
            if (!this.searchString.isEmpty()) continue;
            collected.add((Vector)path.clone());
            this.resetSearchState(path, toSearch);
        }
        return collected;
    }

    private Set<Vector<Transition<RegularExpression>>> handleSelfLoop(List<State> v, Set<Vector<Transition<RegularExpression>>> collected) {
        SortedSet transitions = this.automaton.getAllTransitionsConnecting(v.get(0), v.get(0));
        if (transitions.size() == 0) {
            return collected;
        }
        for (Transition t : transitions) {
            if (!((RegularExpression)t.getSymbol()).is(this.searchString.substring(0, 1))) continue;
            Vector<Transition> result = new Vector<Transition>();
            result.add(t);
            collected.add(result);
        }
        return collected;
    }

    private void advanceSearch(Vector<Transition<RegularExpression>> path, Transition<RegularExpression> t) {
        this.searchString = this.searchString.substring(1);
        path.add(t);
    }

    private void startSearch(Vector<Transition<RegularExpression>> path, Transition<RegularExpression> t) {
        this.matching = true;
        this.advanceSearch(path, t);
    }

    private void resetSearchState(Vector<Transition<RegularExpression>> path, String toSearch) {
        this.matching = false;
        this.searchString = toSearch;
        path.clear();
    }
}

