/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.string.tarsis;

import it.unive.lisa.analysis.string.tarsis.StringReplacer;
import it.unive.lisa.util.datastructures.automaton.AutomataFactory;
import it.unive.lisa.util.datastructures.automaton.Automaton;
import it.unive.lisa.util.datastructures.automaton.CyclicAutomatonException;
import it.unive.lisa.util.datastructures.automaton.State;
import it.unive.lisa.util.datastructures.automaton.Transition;
import it.unive.lisa.util.datastructures.automaton.TransitionSymbol;
import it.unive.lisa.util.datastructures.regex.Atom;
import it.unive.lisa.util.datastructures.regex.RegularExpression;
import it.unive.lisa.util.datastructures.regex.TopAtom;
import it.unive.lisa.util.datastructures.regex.symbolic.SymbolicChar;
import it.unive.lisa.util.datastructures.regex.symbolic.SymbolicString;
import it.unive.lisa.util.datastructures.regex.symbolic.UnknownSymbolicChar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.lang3.tuple.Pair;

public class RegexAutomaton
extends Automaton<RegexAutomaton, RegularExpression> {
    public static RegexAutomaton topString() {
        State q0 = new State(0, true, true);
        State q1 = new State(1, false, true);
        TreeSet<State> states = new TreeSet<State>();
        states.add(q0);
        states.add(q1);
        TreeSet<Transition<RegularExpression>> delta = new TreeSet<Transition<RegularExpression>>();
        delta.add(new Transition(q0, q1, (TransitionSymbol)TopAtom.INSTANCE));
        RegexAutomaton result = new RegexAutomaton(states, delta);
        result.deterministic = Optional.of(true);
        result.minimized = Optional.of(true);
        return result;
    }

    public static RegexAutomaton emptyLang() {
        TreeSet<State> newStates = new TreeSet<State>();
        State initialState = new State(0, true, false);
        newStates.add(initialState);
        RegexAutomaton result = new RegexAutomaton(newStates, Collections.emptySortedSet());
        result.deterministic = Optional.of(true);
        result.minimized = Optional.of(true);
        return result;
    }

    public static RegexAutomaton string(String string) {
        State q0 = new State(0, true, false);
        State q1 = new State(1, false, true);
        TreeSet<State> states = new TreeSet<State>();
        states.add(q0);
        states.add(q1);
        TreeSet<Transition<RegularExpression>> delta = new TreeSet<Transition<RegularExpression>>();
        delta.add(new Transition(q0, q1, (TransitionSymbol)new Atom(string)));
        RegexAutomaton result = new RegexAutomaton(states, delta);
        result.deterministic = Optional.of(true);
        result.minimized = Optional.of(true);
        return result;
    }

    public static RegexAutomaton string(SymbolicString s) {
        ArrayList<RegexAutomaton> result = new ArrayList<RegexAutomaton>();
        Object collector = "";
        for (SymbolicChar ch : s.collapseTopChars()) {
            if (ch instanceof UnknownSymbolicChar) {
                if (!((String)collector).isEmpty()) {
                    result.add(RegexAutomaton.string((String)collector));
                }
                collector = "";
                result.add(RegexAutomaton.topString());
                continue;
            }
            collector = (String)collector + ch.asChar();
        }
        if (!((String)collector).isEmpty()) {
            result.add(RegexAutomaton.string((String)collector));
        }
        if (result.isEmpty()) {
            return RegexAutomaton.emptyStr();
        }
        if (result.size() == 1) {
            return (RegexAutomaton)((Object)result.get(0));
        }
        RegexAutomaton r = (RegexAutomaton)((Object)result.get(0));
        for (int i = 1; i < result.size(); ++i) {
            r = (RegexAutomaton)r.concat((RegexAutomaton)((Object)result.get(i)));
        }
        return r;
    }

    public static RegexAutomaton emptyStr() {
        State q0 = new State(0, true, false);
        State q1 = new State(1, false, true);
        TreeSet<State> states = new TreeSet<State>();
        states.add(q0);
        states.add(q1);
        TreeSet<Transition<RegularExpression>> delta = new TreeSet<Transition<RegularExpression>>();
        delta.add(new Transition(q0, q1, (TransitionSymbol)Atom.EPSILON));
        RegexAutomaton result = new RegexAutomaton(states, delta);
        result.deterministic = Optional.of(true);
        result.minimized = Optional.of(true);
        return result;
    }

    public static RegexAutomaton strings(String ... strings) {
        RegexAutomaton a = RegexAutomaton.emptyLang();
        for (String s : strings) {
            a = (RegexAutomaton)a.union(RegexAutomaton.string(s));
        }
        return a;
    }

    public RegexAutomaton singleString(String string) {
        return RegexAutomaton.string(string);
    }

    public RegexAutomaton unknownString() {
        return RegexAutomaton.topString();
    }

    public RegexAutomaton emptyLanguage() {
        return RegexAutomaton.emptyLang();
    }

    public RegexAutomaton emptyString() {
        return RegexAutomaton.emptyStr();
    }

    public RegexAutomaton from(SortedSet<State> states, SortedSet<Transition<RegularExpression>> transitions) {
        return new RegexAutomaton(states, transitions);
    }

    public RegularExpression epsilon() {
        return Atom.EPSILON;
    }

    public RegularExpression concat(RegularExpression first, RegularExpression second) {
        return first.comp(second);
    }

    public RegularExpression symbolToRegex(RegularExpression symbol) {
        return symbol;
    }

    public RegexAutomaton(SortedSet<State> states, SortedSet<Transition<RegularExpression>> transitions) {
        super(states, transitions);
    }

    public boolean acceptsTopEventually() {
        this.removeUnreachableStates();
        for (Transition t : this.transitions) {
            if (!(t.getSymbol() instanceof TopAtom)) continue;
            return true;
        }
        return false;
    }

    public RegexAutomaton explode() {
        TreeSet<State> exStates = new TreeSet<State>();
        TreeSet<Transition<RegularExpression>> exTransitions = new TreeSet<Transition<RegularExpression>>();
        int counter = 0;
        HashMap<State, State> mapping = new HashMap<State, State>();
        for (State origin : this.states) {
            State st = new State(counter++, origin.isInitial(), origin.isFinal());
            State replaced = mapping.computeIfAbsent(origin, s -> st);
            exStates.add(replaced);
            for (Transition t : this.getOutgoingTransitionsFrom(origin)) {
                State st1 = new State(counter++, t.getDestination().isInitial(), t.getDestination().isFinal());
                State dest = mapping.computeIfAbsent(t.getDestination(), s -> st1);
                exStates.add(dest);
                if (((RegularExpression)t.getSymbol()).maxLength() < 2) {
                    exTransitions.add((Transition<RegularExpression>)new Transition(replaced, dest, (TransitionSymbol)((RegularExpression)t.getSymbol())));
                    continue;
                }
                RegularExpression[] regexes = ((RegularExpression)t.getSymbol()).explode();
                State last = replaced;
                for (RegularExpression regex : regexes) {
                    if (regex == regexes[regexes.length - 1]) {
                        exTransitions.add((Transition<RegularExpression>)new Transition(last, dest, (TransitionSymbol)regex));
                        continue;
                    }
                    State temp = new State(counter++, false, false);
                    exStates.add(temp);
                    exTransitions.add((Transition<RegularExpression>)new Transition(last, temp, (TransitionSymbol)regex));
                    last = temp;
                }
            }
        }
        return (RegexAutomaton)new RegexAutomaton(exStates, exTransitions).minimize();
    }

    public RegexAutomaton intersection(RegexAutomaton other) {
        if (this == other) {
            return this;
        }
        int code = 0;
        HashMap<State, Pair> stateMapping = new HashMap<State, Pair>();
        TreeSet<State> newStates = new TreeSet<State>();
        TreeSet<Transition> newDelta = new TreeSet<Transition>();
        for (State s1 : this.states) {
            for (State s2 : other.states) {
                State s = new State(code++, s1.isInitial() && s2.isInitial(), s1.isFinal() && s2.isFinal());
                stateMapping.put(s, Pair.of((Object)s1, (Object)s2));
                newStates.add(s);
            }
        }
        for (Transition t1 : this.getTransitions()) {
            for (Transition t2 : other.getTransitions()) {
                State from = this.getStateFromPair(stateMapping, Pair.of((Object)t1.getSource(), (Object)t2.getSource()));
                State to = this.getStateFromPair(stateMapping, Pair.of((Object)t1.getDestination(), (Object)t2.getDestination()));
                if (((RegularExpression)t1.getSymbol()).equals(t2.getSymbol())) {
                    newDelta.add(new Transition(from, to, (TransitionSymbol)((RegularExpression)t1.getSymbol())));
                    continue;
                }
                if (t1.getSymbol() == TopAtom.INSTANCE && t2.getSymbol() != TopAtom.INSTANCE) {
                    newDelta.add(new Transition(from, to, (TransitionSymbol)((RegularExpression)t2.getSymbol())));
                    continue;
                }
                if (t1.getSymbol() == TopAtom.INSTANCE || t2.getSymbol() != TopAtom.INSTANCE) continue;
                newDelta.add(new Transition(from, to, (TransitionSymbol)((RegularExpression)t1.getSymbol())));
            }
        }
        RegexAutomaton result = (RegexAutomaton)this.from(newStates, newDelta).minimize();
        return result;
    }

    public RegexAutomaton collapse() {
        HashSet<Vector<State>> collected = new HashSet<Vector<State>>();
        Set paths = this.getAllPaths();
        if (paths.isEmpty()) {
            return this;
        }
        for (List v : paths) {
            collected.addAll(this.findMergableStatesInPath(v));
        }
        if (collected.isEmpty()) {
            return this;
        }
        RegexAutomaton collapsed = (RegexAutomaton)this.copy();
        HashSet<Transition> edgesToRemove = new HashSet<Transition>();
        HashSet<State> statesToRemove = new HashSet<State>();
        for (Vector vector : collected) {
            Object accumulated = "";
            if (vector.size() == 1) {
                statesToRemove.add((State)vector.firstElement());
            } else {
                for (int i = 0; i < vector.size() - 1; ++i) {
                    State from = (State)vector.get(i);
                    State to = (State)vector.get(i + 1);
                    Transition t = (Transition)this.getAllTransitionsConnecting(from, to).iterator().next();
                    accumulated = (String)accumulated + ((Atom)t.getSymbol()).toString();
                    edgesToRemove.add(t);
                    statesToRemove.add(from);
                    statesToRemove.add(to);
                }
            }
            Transition in = (Transition)collapsed.getIngoingTransitionsFrom((State)vector.firstElement()).iterator().next();
            edgesToRemove.add(in);
            accumulated = ((Atom)in.getSymbol()).toString() + (String)accumulated;
            Transition out = (Transition)collapsed.getOutgoingTransitionsFrom((State)vector.lastElement()).iterator().next();
            edgesToRemove.add(out);
            accumulated = (String)accumulated + ((Atom)out.getSymbol()).toString();
            collapsed.addTransition(in.getSource(), out.getDestination(), (TransitionSymbol)new Atom((String)accumulated));
        }
        collapsed.removeTransitions(edgesToRemove);
        collapsed.removeStates(statesToRemove);
        return (RegexAutomaton)collapsed.minimize();
    }

    private Set<Vector<State>> findMergableStatesInPath(List<State> v) {
        HashSet<Vector<State>> collected = new HashSet<Vector<State>>();
        if (v.size() == 1) {
            return collected;
        }
        Vector<State> sequence = new Vector<State>();
        boolean collecting = false;
        for (int i = 0; i < v.size() - 1; ++i) {
            State to;
            State from = v.get(i);
            if (this.getAllTransitionsConnecting(from, to = v.get(i + 1)).size() != 1) {
                if (!collecting) continue;
                collecting = false;
                collected.add(sequence);
                sequence = new Vector();
                continue;
            }
            if (this.getIngoingTransitionsFrom(to).size() != 1) {
                if (!collecting) continue;
                collecting = false;
                collected.add(sequence);
                sequence = new Vector();
                continue;
            }
            SortedSet tmp = this.getOutgoingTransitionsFrom(to);
            if (tmp.size() == 1 && !(((Transition)tmp.iterator().next()).getSymbol() instanceof TopAtom)) {
                sequence.add(to);
                if (collecting) continue;
                collecting = true;
                continue;
            }
            if (!collecting) continue;
            collecting = false;
            collected.add(sequence);
            sequence = new Vector();
        }
        return collected;
    }

    public RegexAutomaton replace(RegexAutomaton toReplace, RegexAutomaton str) throws CyclicAutomatonException {
        ArrayList<RegexAutomaton> automata = new ArrayList<RegexAutomaton>();
        boolean isSingleString = toReplace.getLanguage().size() == 1;
        for (String s : toReplace.getLanguage()) {
            automata.add(new StringReplacer(this).replace(s, str, isSingleString).collapse());
        }
        if (automata.size() == 1) {
            return (RegexAutomaton)((Object)automata.iterator().next());
        }
        return this.union(automata.toArray(new RegexAutomaton[automata.size()]));
    }

    private RegexAutomaton union(RegexAutomaton ... automata) {
        RegexAutomaton result = this.emptyLanguage();
        for (RegexAutomaton a : automata) {
            result = (RegexAutomaton)a.union(result);
        }
        return result;
    }

    public RegexAutomaton repeat(long n) {
        if (n == 0L) {
            return this.emptyString();
        }
        return (RegexAutomaton)((RegexAutomaton)this.toRegex().simplify().repeat(n).toAutomaton((AutomataFactory)this)).minimize();
    }

    public RegexAutomaton trimLeft() {
        return (RegexAutomaton)this.toRegex().trimLeft().simplify().toAutomaton((AutomataFactory)this);
    }

    public RegexAutomaton trimRight() {
        return (RegexAutomaton)this.toRegex().trimRight().simplify().toAutomaton((AutomataFactory)this);
    }

    public RegexAutomaton trim() {
        return (RegexAutomaton)this.toRegex().trimRight().simplify().trimLeft().simplify().toAutomaton((AutomataFactory)this);
    }
}

