/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.string.fsa;

import it.unive.lisa.util.datastructures.automaton.TransitionSymbol;

public class StringSymbol
implements TransitionSymbol<StringSymbol> {
    public static final StringSymbol EPSILON = new StringSymbol("");
    private final String symbol;

    public StringSymbol(String symbol) {
        this.symbol = symbol;
    }

    public StringSymbol(char symbol) {
        this.symbol = Character.toString(symbol);
    }

    public int compareTo(StringSymbol o) {
        return this.symbol.compareTo(o.symbol);
    }

    public boolean isEpsilon() {
        return this == EPSILON || this.symbol.isEmpty();
    }

    public StringSymbol reverse() {
        return this.isEpsilon() ? this : new StringSymbol(new StringBuilder(this.symbol).reverse().toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.symbol == null ? 0 : this.symbol.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringSymbol other = (StringSymbol)obj;
        return !(this.symbol == null ? other.symbol != null : !this.symbol.equals(other.symbol));
    }

    public String toString() {
        return this.symbol;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public StringSymbol concat(StringSymbol other) {
        if (this.isEpsilon()) {
            return other;
        }
        if (other.isEpsilon()) {
            return this;
        }
        return new StringSymbol(this.symbol + other.symbol);
    }

    public int maxLength() {
        return this.symbol.length();
    }

    public int minLength() {
        return this.symbol.length();
    }
}

