/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.string.fsa;

import it.unive.lisa.analysis.numeric.Interval;
import it.unive.lisa.analysis.string.fsa.StringSymbol;
import it.unive.lisa.util.datastructures.automaton.AutomataFactory;
import it.unive.lisa.util.datastructures.automaton.Automaton;
import it.unive.lisa.util.datastructures.automaton.CyclicAutomatonException;
import it.unive.lisa.util.datastructures.automaton.State;
import it.unive.lisa.util.datastructures.automaton.Transition;
import it.unive.lisa.util.datastructures.automaton.TransitionSymbol;
import it.unive.lisa.util.datastructures.regex.Atom;
import it.unive.lisa.util.datastructures.regex.RegularExpression;
import it.unive.lisa.util.numeric.IntInterval;
import it.unive.lisa.util.numeric.MathNumber;
import it.unive.lisa.util.numeric.MathNumberConversionException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;

public final class SimpleAutomaton
extends Automaton<SimpleAutomaton, StringSymbol> {
    public SimpleAutomaton singleString(String string) {
        return new SimpleAutomaton(string);
    }

    public SimpleAutomaton unknownString() {
        TreeSet<State> newStates = new TreeSet<State>();
        TreeSet<Transition<StringSymbol>> newGamma = new TreeSet<Transition<StringSymbol>>();
        State initialState = new State(0, true, true);
        newStates.add(initialState);
        for (char alphabet = '!'; alphabet <= '~'; alphabet = (char)(alphabet + '\u0001')) {
            newGamma.add((Transition<StringSymbol>)new Transition(initialState, initialState, (TransitionSymbol)new StringSymbol(alphabet)));
        }
        return new SimpleAutomaton(newStates, newGamma);
    }

    public SimpleAutomaton emptyLanguage() {
        TreeSet<State> newStates = new TreeSet<State>();
        State initialState = new State(0, true, false);
        newStates.add(initialState);
        return new SimpleAutomaton(newStates, Collections.emptySortedSet());
    }

    public SimpleAutomaton emptyString() {
        return new SimpleAutomaton("");
    }

    public SimpleAutomaton from(SortedSet<State> states, SortedSet<Transition<StringSymbol>> transitions) {
        return new SimpleAutomaton(states, transitions);
    }

    public StringSymbol epsilon() {
        return StringSymbol.EPSILON;
    }

    public StringSymbol concat(StringSymbol first, StringSymbol second) {
        return first.concat(second);
    }

    public RegularExpression symbolToRegex(StringSymbol symbol) {
        return new Atom(symbol.getSymbol());
    }

    public SimpleAutomaton(SortedSet<State> states, SortedSet<Transition<StringSymbol>> transitions) {
        super(states, transitions);
    }

    public SimpleAutomaton(String s) {
        if (s.isEmpty()) {
            this.states.add(new State(0, true, true));
        } else {
            State last = new State(0, true, false);
            this.states.add(last);
            for (int i = 0; i < s.length(); ++i) {
                State next = i != s.length() - 1 ? new State(i + 1, false, false) : new State(i + 1, false, true);
                this.transitions.add(new Transition(last, next, (TransitionSymbol)new StringSymbol(s.charAt(i))));
                last = next;
                this.states.add(last);
            }
        }
        this.deterministic = Optional.of(true);
        this.minimized = Optional.of(true);
    }

    public boolean validateString(String str) {
        TreeSet currentStates = this.epsilonClosure(this.getInitialStates());
        for (int i = 0; i < str.length(); ++i) {
            String c = "" + str.charAt(i);
            TreeSet newCurr = new TreeSet();
            for (State s : currentStates) {
                SortedSet dest = this.transitions.stream().filter(t -> t.getSource().equals((Object)s) && ((StringSymbol)t.getSymbol()).getSymbol().equals(c)).map(Transition::getDestination).collect(Collectors.toSet());
                if (dest.isEmpty()) continue;
                dest = this.epsilonClosure(dest);
                newCurr.addAll(dest);
            }
            currentStates = newCurr;
        }
        return currentStates.stream().anyMatch(State::isFinal);
    }

    public SimpleAutomaton replace(SimpleAutomaton toReplace, SimpleAutomaton str) throws CyclicAutomatonException {
        if (this.hasCycle() || toReplace.hasCycle() || str.hasCycle()) {
            return this.unknownString();
        }
        SimpleAutomaton result = this.emptyLanguage();
        for (String a : this.getLanguage()) {
            for (String b : toReplace.getLanguage()) {
                for (String c : str.getLanguage()) {
                    if (!a.contains(b)) continue;
                    result = (SimpleAutomaton)result.union(new SimpleAutomaton(a.replace(b, c)));
                }
            }
        }
        return result;
    }

    public SimpleAutomaton trimLeft() {
        boolean b;
        SimpleAutomaton result = (SimpleAutomaton)this.copy();
        HashSet<Transition> toAdd = new HashSet<Transition>();
        HashSet<Transition> toRemove = new HashSet<Transition>();
        do {
            for (Transition t : result.getOutgoingTransitionsFrom(result.getInitialState())) {
                if (!((StringSymbol)t.getSymbol()).getSymbol().equals(" ")) continue;
                toRemove.add(t);
                toAdd.add(new Transition(t.getSource(), t.getDestination(), (TransitionSymbol)StringSymbol.EPSILON));
            }
            result.removeTransitions(toRemove);
            result.getTransitions().addAll(toAdd);
            result.minimize();
            b = false;
            for (Transition t : result.getOutgoingTransitionsFrom(result.getInitialState())) {
                if (!((StringSymbol)t.getSymbol()).getSymbol().equals(" ")) continue;
                b = true;
            }
        } while (b);
        return result;
    }

    public SimpleAutomaton trimRight() {
        boolean b;
        SimpleAutomaton result = (SimpleAutomaton)this.copy();
        HashSet<Transition> toAdd = new HashSet<Transition>();
        HashSet<Transition> toRemove = new HashSet<Transition>();
        do {
            for (State qf : result.getFinalStates()) {
                for (Transition t : result.getIngoingTransitionsFrom(qf)) {
                    if (!((StringSymbol)t.getSymbol()).getSymbol().equals(" ")) continue;
                    toRemove.add(t);
                    toAdd.add(new Transition(t.getSource(), t.getDestination(), (TransitionSymbol)StringSymbol.EPSILON));
                }
            }
            result.removeTransitions(toRemove);
            result.getTransitions().addAll(toAdd);
            result.minimize();
            b = false;
            for (State qf : result.getFinalStates()) {
                for (Transition t : result.getIngoingTransitionsFrom(qf)) {
                    if (!((StringSymbol)t.getSymbol()).equals(new StringSymbol(" "))) continue;
                    b = true;
                }
            }
        } while (b);
        return result;
    }

    public SimpleAutomaton trim() {
        return (SimpleAutomaton)this.toRegex().trimRight().simplify().trimLeft().simplify().toAutomaton((AutomataFactory)this);
    }

    public SimpleAutomaton repeat(Interval i) throws MathNumberConversionException {
        if (this.equals((Object)this.emptyString())) {
            return this;
        }
        if (this.hasCycle()) {
            return (SimpleAutomaton)this.star();
        }
        MathNumber high = i.interval.getHigh();
        MathNumber low = i.interval.getLow();
        SimpleAutomaton epsilon = this.emptyString();
        if (low.isMinusInfinity()) {
            if (high.isPlusInfinity()) {
                return (SimpleAutomaton)epsilon.union(this.auxRepeat(new IntInterval(MathNumber.ONE, high), this.getInitialState(), new TreeSet<Transition<StringSymbol>>(), this.emptyLanguage()));
            }
            if (high.isZero()) {
                return this.emptyString();
            }
            return (SimpleAutomaton)epsilon.union(this.auxRepeat(new IntInterval(MathNumber.ONE, high), this.getInitialState(), new TreeSet<Transition<StringSymbol>>(), this.emptyLanguage()));
        }
        long lowInt = low.toLong();
        if (high.isPlusInfinity()) {
            if (lowInt < 0L) {
                return (SimpleAutomaton)epsilon.union(this.auxRepeat(new IntInterval(MathNumber.ONE, high), this.getInitialState(), new TreeSet<Transition<StringSymbol>>(), this.emptyLanguage()));
            }
            if (low.isZero()) {
                return (SimpleAutomaton)epsilon.union(this.auxRepeat(new IntInterval(MathNumber.ONE, high), this.getInitialState(), new TreeSet<Transition<StringSymbol>>(), this.emptyLanguage()));
            }
            if (lowInt > 0L) {
                return (SimpleAutomaton)epsilon.union(this.auxRepeat(i.interval, this.getInitialState(), new TreeSet<Transition<StringSymbol>>(), this.emptyLanguage()));
            }
        }
        long highInt = high.toLong();
        if (lowInt < 0L) {
            if (highInt < 0L) {
                return this.emptyLanguage();
            }
            if (high.isZero()) {
                return this.emptyString();
            }
            return (SimpleAutomaton)epsilon.union(this.auxRepeat(new IntInterval(MathNumber.ONE, high), this.getInitialState(), new TreeSet<Transition<StringSymbol>>(), this.emptyLanguage()));
        }
        if (low.isZero()) {
            if (high.isZero()) {
                return this.emptyString();
            }
            if (highInt > 0L) {
                return (SimpleAutomaton)epsilon.union(this.auxRepeat(new IntInterval(MathNumber.ONE, high), this.getInitialState(), new TreeSet<Transition<StringSymbol>>(), this.emptyLanguage()));
            }
        }
        if (lowInt > 0L && highInt > 0L) {
            return this.auxRepeat(i.interval, this.getInitialState(), new TreeSet<Transition<StringSymbol>>(), this.emptyLanguage());
        }
        return this.emptyLanguage();
    }

    private SimpleAutomaton auxRepeat(IntInterval i, State currentState, SortedSet<Transition<StringSymbol>> delta, SimpleAutomaton result) throws MathNumberConversionException {
        if (currentState.isFinal()) {
            long k;
            TreeSet<State> states = new TreeSet<State>();
            for (State s : this.getStates()) {
                if (!s.equals((Object)currentState)) {
                    states.add(new State(s.getId(), s.isInitial(), false));
                    continue;
                }
                states.add(new State(s.getId(), s.isInitial(), s.isFinal()));
            }
            SimpleAutomaton temp = new SimpleAutomaton(states, delta);
            SimpleAutomaton tempResult = (SimpleAutomaton)temp.copy();
            for (k = 1L; k < i.getLow().toLong(); ++k) {
                tempResult = tempResult.connectAutomaton(temp, tempResult.getFinalStates(), false);
            }
            if (i.getHigh().isPlusInfinity()) {
                tempResult = tempResult.connectAutomaton((SimpleAutomaton)((SimpleAutomaton)temp.copy()).star(), tempResult.getFinalStates(), true);
            } else {
                for (k = i.getLow().toLong(); k < i.getHigh().toLong(); ++k) {
                    tempResult = tempResult.connectAutomaton(temp, tempResult.getFinalStates(), true);
                }
            }
            tempResult = (SimpleAutomaton)tempResult.minimize();
            result = (SimpleAutomaton)result.union(tempResult);
        }
        for (Transition t : this.getOutgoingTransitionsFrom(currentState)) {
            TreeSet<Transition<StringSymbol>> clone = new TreeSet<Transition<StringSymbol>>(delta);
            clone.add((Transition<StringSymbol>)t);
            result = (SimpleAutomaton)this.auxRepeat(i, t.getDestination(), clone, result).union(result);
        }
        return result;
    }

    private SimpleAutomaton connectAutomaton(SimpleAutomaton second, SortedSet<State> connectOn, boolean b) {
        Object newState;
        TreeSet<Transition<StringSymbol>> delta = new TreeSet<Transition<StringSymbol>>();
        TreeSet<State> states = new TreeSet<State>();
        HashMap<State, State> firstMapping = new HashMap<State, State>();
        HashMap<State, Object> secondMapping = new HashMap<State, Object>();
        int c = 0;
        if (this.equals((Object)this.emptyString())) {
            return second;
        }
        if (second.equals((Object)this.emptyString())) {
            return this;
        }
        for (State s : this.getStates()) {
            newState = null;
            newState = b ? new State(c++, s.isInitial(), s.isFinal()) : (connectOn.contains(s) ? new State(c++, s.isInitial(), false) : new State(c++, s.isInitial(), s.isFinal()));
            states.add((State)newState);
            firstMapping.put(s, (State)newState);
        }
        for (Transition t : this.getTransitions()) {
            delta.add(new Transition((State)firstMapping.get(t.getSource()), (State)firstMapping.get(t.getDestination()), (TransitionSymbol)((StringSymbol)t.getSymbol())));
        }
        if (second.getStates().size() == 1 && second.getInitialState().isFinal()) {
            for (Transition t : second.getOutgoingTransitionsFrom(second.getInitialState())) {
                for (State s : connectOn) {
                    State newState2 = new State(((State)firstMapping.get(s)).getId(), s.isInitial(), true);
                    states.remove(firstMapping.get(s));
                    states.add(newState2);
                    delta.add((Transition<StringSymbol>)new Transition(newState2, newState2, (TransitionSymbol)((StringSymbol)t.getSymbol())));
                }
                second.minimize();
            }
        } else {
            for (State s : second.getStates()) {
                newState = new State(c++, s.isInitial(), s.isFinal());
                states.add((State)newState);
                secondMapping.put(s, newState);
            }
            states.remove(secondMapping.get(second.getInitialState()));
            secondMapping.remove(second.getInitialState());
            for (Transition t : second.getTransitions()) {
                if (t.getSource().equals((Object)second.getInitialState()) || t.getDestination().equals((Object)second.getInitialState()) || !secondMapping.containsKey(t.getSource()) || !secondMapping.containsKey(t.getDestination())) continue;
                if (!t.getSource().isInitial() && !t.getDestination().isInitial()) {
                    delta.add((Transition<StringSymbol>)new Transition((State)secondMapping.get(t.getSource()), (State)secondMapping.get(t.getDestination()), (TransitionSymbol)((StringSymbol)t.getSymbol())));
                }
                if (!t.getSource().isInitial()) continue;
                for (State s : connectOn) {
                    if (!states.contains(secondMapping.get(t.getSource()))) continue;
                    delta.add((Transition<StringSymbol>)new Transition((State)secondMapping.get(t.getSource()), (State)firstMapping.get(s), (TransitionSymbol)((StringSymbol)t.getSymbol())));
                }
            }
            for (Transition t : second.getOutgoingTransitionsFrom(second.getInitialState())) {
                for (State s : connectOn) {
                    delta.add((Transition<StringSymbol>)new Transition((State)firstMapping.get(s), (State)secondMapping.get(t.getDestination()), (TransitionSymbol)((StringSymbol)t.getSymbol())));
                }
            }
        }
        return new SimpleAutomaton(states, delta);
    }
}

