/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.string.bricks;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.nonrelational.value.BaseNonRelationalValueDomain;
import it.unive.lisa.analysis.string.ContainsCharProvider;
import it.unive.lisa.analysis.string.bricks.Brick;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.binary.StringConcat;
import it.unive.lisa.symbolic.value.operator.binary.StringContains;
import it.unive.lisa.symbolic.value.operator.binary.StringEndsWith;
import it.unive.lisa.symbolic.value.operator.binary.StringEquals;
import it.unive.lisa.symbolic.value.operator.binary.StringIndexOf;
import it.unive.lisa.symbolic.value.operator.binary.StringStartsWith;
import it.unive.lisa.util.numeric.IntInterval;
import it.unive.lisa.util.numeric.MathNumber;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class Bricks
implements BaseNonRelationalValueDomain<Bricks>,
ContainsCharProvider {
    private final List<Brick> bricks;
    private static final Bricks TOP = new Bricks();
    private static final Bricks BOTTOM = new Bricks(new ArrayList<Brick>());
    public static int kL = 20;
    public static int kI = 20;
    public static int kS = 50;

    public Bricks() {
        this.bricks = new ArrayList<Brick>(1);
        this.bricks.add(new Brick());
    }

    public Bricks(List<Brick> bricks) {
        this.bricks = bricks;
    }

    public Bricks lubAux(Bricks other) throws SemanticException {
        List<Brick> thisPaddedList = this.bricks;
        List<Brick> otherPaddedList = other.bricks;
        if (this.bricks.size() < other.bricks.size()) {
            thisPaddedList = this.padList(other);
        } else if (other.bricks.size() < this.bricks.size()) {
            otherPaddedList = other.padList(this);
        }
        ArrayList<Brick> resultBricks = new ArrayList<Brick>(thisPaddedList.size());
        for (int i = 0; i < thisPaddedList.size(); ++i) {
            resultBricks.add((Brick)thisPaddedList.get(i).lub((BaseLattice)otherPaddedList.get(i)));
        }
        Bricks result = new Bricks(resultBricks);
        result.normBricks();
        return result;
    }

    public boolean lessOrEqualAux(Bricks other) throws SemanticException {
        List<Brick> thisPaddedList = this.bricks;
        List<Brick> otherPaddedList = other.bricks;
        if (this.bricks.size() < other.bricks.size()) {
            thisPaddedList = this.padList(other);
        } else if (other.bricks.size() < this.bricks.size()) {
            otherPaddedList = other.padList(this);
        }
        for (int i = 0; i < thisPaddedList.size(); ++i) {
            Brick second;
            Brick first = thisPaddedList.get(i);
            if (first.lessOrEqual((BaseLattice)(second = otherPaddedList.get(i)))) continue;
            return false;
        }
        return true;
    }

    public Bricks wideningAux(Bricks other) throws SemanticException {
        boolean rel = this.lessOrEqual((BaseLattice)other);
        if (!rel && !other.lessOrEqual((BaseLattice)this)) {
            return TOP;
        }
        if (this.bricks.size() > kL || other.bricks.size() > kL) {
            return TOP;
        }
        if (rel) {
            return this.w(other);
        }
        return other.w(this);
    }

    private Bricks w(Bricks other) throws SemanticException {
        List<Brick> thisPaddedList = this.bricks;
        List<Brick> otherPaddedList = other.bricks;
        if (this.bricks.size() < other.bricks.size()) {
            thisPaddedList = this.padList(other);
        } else if (other.bricks.size() < this.bricks.size()) {
            otherPaddedList = other.padList(this);
        }
        ArrayList<Brick> resultList = new ArrayList<Brick>();
        for (int i = 0; i < thisPaddedList.size(); ++i) {
            Brick thisCurrent = thisPaddedList.get(i);
            Brick otherCurrent = otherPaddedList.get(i);
            resultList.add((Brick)thisCurrent.widening((BaseLattice)otherCurrent));
        }
        Bricks result = new Bricks(resultList);
        result.normBricks();
        return result;
    }

    public Bricks evalBinaryExpression(BinaryOperator operator, Bricks left, Bricks right, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (operator == StringConcat.INSTANCE) {
            ArrayList<Brick> resultList = new ArrayList<Brick>(left.bricks);
            resultList.addAll(right.bricks);
            return new Bricks(resultList);
        }
        if (operator == StringContains.INSTANCE || operator == StringEndsWith.INSTANCE || operator == StringEquals.INSTANCE || operator == StringIndexOf.INSTANCE || operator == StringStartsWith.INSTANCE) {
            return TOP;
        }
        return TOP;
    }

    public Bricks evalNonNullConstant(Constant constant, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (constant.getValue() instanceof String) {
            String str = (String)constant.getValue();
            TreeSet<String> strings = new TreeSet<String>();
            strings.add(str);
            ArrayList<Brick> resultList = new ArrayList<Brick>();
            resultList.add(new Brick(1, 1, strings));
            return new Bricks(resultList);
        }
        return TOP;
    }

    public Satisfiability satisfiesBinaryExpression(BinaryOperator operator, Bricks left, Bricks right, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (left.isTop() || right.isBottom()) {
            return Satisfiability.UNKNOWN;
        }
        if (operator == StringContains.INSTANCE) {
            return left.contains(right);
        }
        return Satisfiability.UNKNOWN;
    }

    private Satisfiability contains(Bricks right) {
        if (right.bricks.size() != 1) {
            return Satisfiability.UNKNOWN;
        }
        if (!right.bricks.get(0).isFinite()) {
            return Satisfiability.UNKNOWN;
        }
        Set<String> strings = right.bricks.get(0).getStrings();
        if (strings.size() != 1) {
            return Satisfiability.UNKNOWN;
        }
        if (strings.iterator().next().length() != 1) {
            return Satisfiability.UNKNOWN;
        }
        String c = strings.iterator().next();
        boolean res = this.bricks.stream().filter(b -> b.getMin().gt(MathNumber.ZERO)).map(b -> b.getStrings()).anyMatch(set -> set == null || set.stream().allMatch(s -> s.contains(c)));
        if (res) {
            return Satisfiability.SATISFIED;
        }
        res = this.bricks.stream().map(b -> b.getStrings()).allMatch(set -> set != null && set.stream().allMatch(s -> !s.contains(c)));
        if (res) {
            return Satisfiability.NOT_SATISFIED;
        }
        return Satisfiability.UNKNOWN;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Bricks bricks1 = (Bricks)object;
        return Objects.equals(this.bricks, bricks1.bricks);
    }

    public int hashCode() {
        return Objects.hash(this.bricks);
    }

    public Bricks top() {
        return TOP;
    }

    public Bricks bottom() {
        return BOTTOM;
    }

    public String toString() {
        return this.representation().toString();
    }

    public StructuredRepresentation representation() {
        if (this.isBottom()) {
            return Lattice.bottomRepresentation();
        }
        if (this.isTop()) {
            return Lattice.topRepresentation();
        }
        return new StringRepresentation(StringUtils.join(this.bricks, (String)" "));
    }

    private void rule2(int first, int second) {
        TreeSet<String> resultSet;
        Brick firstBrick = this.bricks.get(first);
        Brick secondBrick = this.bricks.get(second);
        if (firstBrick.getStrings() == null || secondBrick.getStrings() == null) {
            resultSet = null;
        } else {
            resultSet = new TreeSet<String>();
            firstBrick.getStrings().forEach(string -> secondBrick.getStrings().forEach(otherStr -> resultSet.add(string + otherStr)));
        }
        this.bricks.set(first, new Brick(1, 1, resultSet));
        this.bricks.remove(second);
    }

    private void rule3(int index) {
        Brick brick = this.bricks.get(index);
        this.bricks.set(index, new Brick(1, 1, brick.getReps()));
    }

    private void rule4(int first, int second) {
        Brick firstBrick = this.bricks.get(first);
        Brick secondBrick = this.bricks.get(second);
        this.bricks.set(first, new Brick(firstBrick.getMin().add(secondBrick.getMin()), firstBrick.getMax().add(secondBrick.getMax()), firstBrick.getStrings()));
        this.bricks.remove(second);
    }

    private void rule5(int index) {
        Brick brick = this.bricks.get(index);
        Brick br = new Brick(brick.getMin(), brick.getMin(), brick.getStrings());
        this.bricks.set(index, new Brick(1, 1, br.getReps()));
        this.bricks.add(index + 1, new Brick(MathNumber.ZERO, brick.getMax().subtract(brick.getMin()), brick.getStrings()));
    }

    public void normBricks() {
        if (this.isTop()) {
            return;
        }
        List<Brick> thisBricks = this.bricks;
        ArrayList<Brick> tempList = new ArrayList<Brick>(thisBricks);
        thisBricks.removeIf(brick -> brick.getMin().equals((Object)MathNumber.ZERO) && brick.getMax().equals((Object)MathNumber.ZERO) && brick.getStrings() != null && brick.getStrings().isEmpty());
        for (int i = 0; i < thisBricks.size(); ++i) {
            boolean lastBrick;
            Brick currentBrick = thisBricks.get(i);
            Brick nextBrick = null;
            boolean bl = lastBrick = i == thisBricks.size() - 1;
            if (!lastBrick) {
                nextBrick = thisBricks.get(i + 1);
            }
            if (!lastBrick && currentBrick.getMin().equals((Object)MathNumber.ONE) && currentBrick.getMax().equals((Object)MathNumber.ONE) && nextBrick.getMin().equals((Object)MathNumber.ONE) && nextBrick.getMax().equals((Object)MathNumber.ONE)) {
                this.rule2(i, i + 1);
                boolean bl2 = lastBrick = i == thisBricks.size() - 1;
            }
            if (currentBrick.getMin().equals((Object)currentBrick.getMax()) && !currentBrick.getMin().equals((Object)MathNumber.ONE) && !currentBrick.getMax().equals((Object)MathNumber.ONE) && currentBrick.getStrings() != null) {
                this.rule3(i);
            }
            if (!lastBrick && currentBrick.getStrings() != null && currentBrick.getStrings().equals(nextBrick.getStrings())) {
                this.rule4(i, i + 1);
            }
            if (!MathNumber.ONE.lt(currentBrick.getMin()) || currentBrick.getMin().equals((Object)currentBrick.getMax()) || currentBrick.getStrings() == null) continue;
            this.rule5(i);
        }
        if (!thisBricks.equals(tempList)) {
            this.normBricks();
        }
    }

    public Bricks substring(long e, long b) {
        this.normBricks();
        Brick first = this.bricks.get(0);
        TreeSet<String> result = new TreeSet<String>();
        if (first.getMin().equals((Object)MathNumber.ONE) && first.getMax().equals((Object)MathNumber.ONE) && first.getStrings() != null && !first.getStrings().isEmpty()) {
            first.getStrings().forEach(s -> {
                boolean allGreater;
                boolean bl = allGreater = (long)s.length() >= e;
                if (allGreater) {
                    result.add(s.substring((int)e, (int)b));
                }
            });
        }
        if (result.size() == first.getStrings().size()) {
            ArrayList<Brick> resultList = new ArrayList<Brick>();
            resultList.add(new Brick(new IntInterval(1, 1), result));
            return new Bricks(resultList);
        }
        return TOP;
    }

    public List<Brick> padList(Bricks other) {
        if (this.bricks.size() >= other.bricks.size()) {
            throw new IllegalArgumentException("Other bricks list is longer or equal");
        }
        ArrayList<Brick> l1 = new ArrayList<Brick>(this.bricks);
        ArrayList<Brick> l2 = new ArrayList<Brick>(other.bricks);
        Brick e = new Brick(0, 0, new TreeSet<String>());
        int n1 = l1.size();
        int n2 = l2.size();
        int n = n2 - n1;
        ArrayList<Brick> lnew = new ArrayList<Brick>();
        int emptyBricksAdded = 0;
        for (int i = 0; i < n2; ++i) {
            if (emptyBricksAdded >= n) {
                lnew.add((Brick)l1.get(0));
                l1.remove(0);
                continue;
            }
            if (l1.isEmpty() || !((Brick)l1.get(0)).equals(l2.get(i))) {
                lnew.add(e);
                ++emptyBricksAdded;
                continue;
            }
            lnew.add((Brick)l1.get(0));
            l1.remove(0);
        }
        return lnew;
    }

    public IntInterval length() {
        return new IntInterval(MathNumber.ZERO, MathNumber.PLUS_INFINITY);
    }

    public IntInterval indexOf(Bricks s) {
        return new IntInterval(MathNumber.MINUS_ONE, MathNumber.PLUS_INFINITY);
    }

    @Override
    public Satisfiability containsChar(char c) throws SemanticException {
        if (this.isTop()) {
            return Satisfiability.UNKNOWN;
        }
        if (this.isBottom()) {
            return Satisfiability.BOTTOM;
        }
        Satisfiability sat = Satisfiability.BOTTOM;
        for (Brick b : this.bricks) {
            if (b.getMin().geq(MathNumber.ONE)) {
                Satisfiability bricksat = Satisfiability.BOTTOM;
                for (String s : b.getStrings()) {
                    if (!s.contains(String.valueOf(c))) {
                        bricksat = (Satisfiability)bricksat.lub((Lattice)Satisfiability.NOT_SATISFIED);
                        continue;
                    }
                    bricksat = (Satisfiability)bricksat.lub((Lattice)Satisfiability.SATISFIED);
                }
                if (bricksat == Satisfiability.SATISFIED) {
                    return bricksat;
                }
                sat = (Satisfiability)sat.lub((Lattice)bricksat);
                continue;
            }
            for (String s : b.getStrings()) {
                if (s.contains(String.valueOf(c))) {
                    sat = (Satisfiability)sat.lub((Lattice)Satisfiability.UNKNOWN);
                    continue;
                }
                sat = (Satisfiability)sat.lub((Lattice)Satisfiability.NOT_SATISFIED);
            }
        }
        return sat;
    }
}

