/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.string;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.nonrelational.value.BaseNonRelationalValueDomain;
import it.unive.lisa.analysis.string.ContainsCharProvider;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.binary.StringConcat;
import it.unive.lisa.symbolic.value.operator.binary.StringContains;
import it.unive.lisa.symbolic.value.operator.binary.StringEndsWith;
import it.unive.lisa.symbolic.value.operator.binary.StringEquals;
import it.unive.lisa.symbolic.value.operator.binary.StringIndexOf;
import it.unive.lisa.symbolic.value.operator.binary.StringStartsWith;
import it.unive.lisa.symbolic.value.operator.ternary.StringReplace;
import it.unive.lisa.symbolic.value.operator.ternary.TernaryOperator;
import it.unive.lisa.util.numeric.IntInterval;
import it.unive.lisa.util.numeric.MathNumber;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Objects;

public class Suffix
implements BaseNonRelationalValueDomain<Suffix>,
ContainsCharProvider {
    private static final Suffix TOP = new Suffix();
    private static final Suffix BOTTOM = new Suffix(null);
    private final String suffix;

    public Suffix() {
        this("");
    }

    public Suffix(String suffix) {
        this.suffix = suffix;
    }

    public Suffix lubAux(Suffix other) throws SemanticException {
        String otherSuffix = other.suffix;
        StringBuilder result = new StringBuilder();
        int i = this.suffix.length() - 1;
        for (int j = otherSuffix.length() - 1; i >= 0 && j >= 0 && this.suffix.charAt(i) == otherSuffix.charAt(j); --j) {
            result.append(this.suffix.charAt(i--));
        }
        if (result.length() != 0) {
            return new Suffix(result.reverse().toString());
        }
        return TOP;
    }

    public boolean lessOrEqualAux(Suffix other) throws SemanticException {
        if (other.suffix.length() <= this.suffix.length()) {
            Suffix lub = this.lubAux(other);
            return lub.suffix.length() == other.suffix.length();
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Suffix suffix1 = (Suffix)o;
        return Objects.equals(this.suffix, suffix1.suffix);
    }

    public int hashCode() {
        return Objects.hash(this.suffix);
    }

    public Suffix top() {
        return TOP;
    }

    public Suffix bottom() {
        return BOTTOM;
    }

    public StructuredRepresentation representation() {
        if (this.isBottom()) {
            return Lattice.bottomRepresentation();
        }
        if (this.isTop()) {
            return Lattice.topRepresentation();
        }
        return new StringRepresentation("*" + this.suffix);
    }

    public Suffix evalNonNullConstant(Constant constant, ProgramPoint pp, SemanticOracle oracle) {
        String str;
        if (constant.getValue() instanceof String && !(str = (String)constant.getValue()).isEmpty()) {
            return new Suffix(str);
        }
        return TOP;
    }

    public Suffix evalBinaryExpression(BinaryOperator operator, Suffix left, Suffix right, ProgramPoint pp, SemanticOracle oracle) {
        if (operator == StringConcat.INSTANCE) {
            return right;
        }
        if (operator == StringContains.INSTANCE || operator == StringEndsWith.INSTANCE || operator == StringEquals.INSTANCE || operator == StringIndexOf.INSTANCE || operator == StringStartsWith.INSTANCE) {
            return TOP;
        }
        return TOP;
    }

    public Suffix evalTernaryExpression(TernaryOperator operator, Suffix left, Suffix middle, Suffix right, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (operator == StringReplace.INSTANCE) {
            String replace = right.getSuffix();
            String string = middle.getSuffix();
            String target = left.getSuffix();
            if (!target.contains(replace)) {
                return this;
            }
            return new Suffix(target.replace(replace, string));
        }
        return TOP;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public Suffix substring(long begin, long end) {
        return new Suffix("");
    }

    public IntInterval length() {
        return new IntInterval(new MathNumber((long)this.suffix.length()), MathNumber.PLUS_INFINITY);
    }

    public IntInterval indexOf(Suffix s) {
        return new IntInterval(MathNumber.MINUS_ONE, MathNumber.PLUS_INFINITY);
    }

    @Override
    public Satisfiability containsChar(char c) {
        if (this.isTop()) {
            return Satisfiability.UNKNOWN;
        }
        if (this.isBottom()) {
            return Satisfiability.BOTTOM;
        }
        return this.suffix.contains(String.valueOf(c)) ? Satisfiability.SATISFIED : Satisfiability.UNKNOWN;
    }
}

