/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.string;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.ExpressionInverseSet;
import it.unive.lisa.analysis.lattices.FunctionalLattice;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.program.SyntheticLocation;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.BinaryExpression;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.TernaryExpression;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.symbolic.value.Variable;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.binary.LogicalAnd;
import it.unive.lisa.symbolic.value.operator.binary.LogicalOr;
import it.unive.lisa.symbolic.value.operator.binary.StringConcat;
import it.unive.lisa.symbolic.value.operator.binary.StringContains;
import it.unive.lisa.symbolic.value.operator.binary.StringEndsWith;
import it.unive.lisa.symbolic.value.operator.binary.StringEquals;
import it.unive.lisa.symbolic.value.operator.binary.StringStartsWith;
import it.unive.lisa.symbolic.value.operator.ternary.StringReplace;
import it.unive.lisa.symbolic.value.operator.ternary.StringSubstring;
import it.unive.lisa.type.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SubstringDomain
extends FunctionalLattice<SubstringDomain, Identifier, ExpressionInverseSet>
implements ValueDomain<SubstringDomain> {
    private static final SubstringDomain TOP = new SubstringDomain(new ExpressionInverseSet().top());
    private static final SubstringDomain BOTTOM = new SubstringDomain(new ExpressionInverseSet().bottom());

    public SubstringDomain() {
        this(new ExpressionInverseSet());
    }

    protected SubstringDomain(ExpressionInverseSet lattice, Map<Identifier, ExpressionInverseSet> function) {
        super((Lattice)lattice, function);
    }

    private SubstringDomain(ExpressionInverseSet lattice) {
        super((Lattice)lattice);
    }

    public SubstringDomain lubAux(SubstringDomain other) throws SemanticException {
        return ((SubstringDomain)this.functionalLift(other, (Lattice)((ExpressionInverseSet)this.lattice).top(), (arg_0, arg_1) -> ((SubstringDomain)this).glbKeys(arg_0, arg_1), (o1, o2) -> (ExpressionInverseSet)o1.lub((BaseLattice)o2))).clear();
    }

    public SubstringDomain glbAux(SubstringDomain other) throws SemanticException {
        return ((SubstringDomain)this.functionalLift(other, (Lattice)((ExpressionInverseSet)this.lattice).top(), (arg_0, arg_1) -> ((SubstringDomain)this).lubKeys(arg_0, arg_1), (o1, o2) -> (ExpressionInverseSet)o1.glb((BaseLattice)o2))).closure();
    }

    public SubstringDomain top() {
        return this.isTop() ? this : TOP;
    }

    public SubstringDomain bottom() {
        return this.isBottom() ? this : BOTTOM;
    }

    public ExpressionInverseSet stateOfUnknown(Identifier key) {
        return ((ExpressionInverseSet)this.lattice).top();
    }

    public SubstringDomain mk(ExpressionInverseSet lattice, Map<Identifier, ExpressionInverseSet> function) {
        return new SubstringDomain(lattice.isBottom() ? lattice.bottom() : lattice.top(), function);
    }

    public SubstringDomain assign(Identifier id, ValueExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (oracle != null && pp != null && oracle.getRuntimeTypesOf((SymbolicExpression)expression, pp, oracle).stream().allMatch(t -> !t.isStringType() && !t.isUntyped())) {
            return this;
        }
        Object strType = pp != null ? pp.getProgram().getTypes().getStringType() : expression.getStaticType();
        Set<SymbolicExpression> expressions = this.extrPlus(expression, pp, oracle, (Type)strType);
        SubstringDomain result = this.mk((ExpressionInverseSet)this.lattice, (Map<Identifier, ExpressionInverseSet>)this.mkNewFunction(this.function, false));
        result = result.remove(expressions, id);
        result = result.add(expressions, id);
        result = result.interasg(id, (SymbolicExpression)expression);
        result = result.closure(id);
        return result.clear();
    }

    public SubstringDomain smallStepSemantics(ValueExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return this;
    }

    public SubstringDomain assume(ValueExpression expression, ProgramPoint src, ProgramPoint dest, SemanticOracle oracle) throws SemanticException {
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            BinaryOperator binaryOperator = binaryExpression.getOperator();
            SymbolicExpression left = binaryExpression.getLeft();
            SymbolicExpression right = binaryExpression.getRight();
            Object strType = src != null ? src.getProgram().getTypes().getStringType() : left.getStaticType();
            if (binaryOperator instanceof StringContains || binaryOperator instanceof StringStartsWith || binaryOperator instanceof StringEndsWith) {
                if (!(left instanceof Identifier)) {
                    return this;
                }
                if (!(right instanceof ValueExpression)) {
                    throw new SemanticException("instanceof right");
                }
                Set<SymbolicExpression> extracted = this.extrPlus((ValueExpression)right, src, oracle, (Type)strType);
                SubstringDomain result = this.mk((ExpressionInverseSet)this.lattice, (Map<Identifier, ExpressionInverseSet>)this.mkNewFunction(this.function, false));
                result = result.add(extracted, (Identifier)left);
                result = result.closure();
                return result.clear();
            }
            if (binaryOperator instanceof StringEquals) {
                if (left instanceof Identifier && right instanceof Identifier) {
                    SubstringDomain result = this.mk((ExpressionInverseSet)this.lattice, (Map<Identifier, ExpressionInverseSet>)this.mkNewFunction(this.function, false));
                    result = result.add(left, (Identifier)right);
                    result = result.add(right, (Identifier)left);
                    result = result.closure();
                    return result.clear();
                }
                if (left instanceof Identifier || right instanceof Identifier) {
                    if (right instanceof Identifier) {
                        SymbolicExpression temp = left;
                        left = right;
                        right = temp;
                    }
                    if (!(right instanceof ValueExpression)) {
                        throw new SemanticException("instanceof right != ValueExpression.class");
                    }
                    Set<SymbolicExpression> add = this.extrPlus((ValueExpression)right, src, oracle, (Type)strType);
                    SubstringDomain result = this.mk((ExpressionInverseSet)this.lattice, (Map<Identifier, ExpressionInverseSet>)this.mkNewFunction(this.function, false));
                    result = result.add(add, (Identifier)left);
                    result = result.closure();
                    return result.clear();
                }
            } else if (binaryOperator instanceof LogicalOr || binaryOperator instanceof LogicalAnd) {
                if (!(left instanceof ValueExpression) || !(right instanceof ValueExpression)) {
                    throw new SemanticException("!(left instanceof ValueExpression) || !(right instanceof ValueExpression)");
                }
                ValueExpression rightValueExpression = (ValueExpression)right;
                ValueExpression leftValueExpression = (ValueExpression)left;
                SubstringDomain leftDomain = this.assume(leftValueExpression, src, dest, oracle);
                SubstringDomain rightDomain = this.assume(rightValueExpression, src, dest, oracle);
                if (binaryOperator instanceof LogicalOr) {
                    return ((SubstringDomain)leftDomain.lub((BaseLattice)rightDomain)).clear();
                }
                return ((SubstringDomain)leftDomain.glb((BaseLattice)rightDomain)).clear();
            }
        }
        return this;
    }

    public boolean knowsIdentifier(Identifier id) {
        if (id == null || this.function == null) {
            return false;
        }
        if (this.function.containsKey(id)) {
            return true;
        }
        for (Map.Entry entry : this.function.entrySet()) {
            for (SymbolicExpression expr : ((ExpressionInverseSet)entry.getValue()).elements) {
                if (!SubstringDomain.appears(id, expr)) continue;
                return true;
            }
        }
        return false;
    }

    public SubstringDomain forgetIdentifier(Identifier id) throws SemanticException {
        if (!this.knowsIdentifier(id)) {
            return this;
        }
        Map newFunction = this.mkNewFunction(this.function, false);
        newFunction.remove(id);
        newFunction.replaceAll((key, value) -> SubstringDomain.removeFromSet(value, id));
        return this.mk((ExpressionInverseSet)this.lattice, (Map<Identifier, ExpressionInverseSet>)newFunction);
    }

    public SubstringDomain forgetIdentifiersIf(Predicate<Identifier> test) throws SemanticException {
        if (this.function == null || this.function.keySet().isEmpty()) {
            return this;
        }
        HashSet<Identifier> ids = new HashSet<Identifier>();
        for (Map.Entry entry : this.function.entrySet()) {
            ids.add((Identifier)entry.getKey());
            for (SymbolicExpression s : ((ExpressionInverseSet)entry.getValue()).elements()) {
                if (!(s instanceof Identifier)) continue;
                Identifier id = (Identifier)s;
                ids.add(id);
            }
        }
        SubstringDomain result = this.mk((ExpressionInverseSet)this.lattice, (Map<Identifier, ExpressionInverseSet>)this.mkNewFunction(this.function, false));
        for (Identifier id : ids) {
            if (!test.test(id)) continue;
            result = result.forgetIdentifier(id);
        }
        return result;
    }

    public Satisfiability satisfies(ValueExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (this.isBottom() || !(expression instanceof BinaryExpression)) {
            return Satisfiability.UNKNOWN;
        }
        BinaryExpression binaryExpression = (BinaryExpression)expression;
        BinaryOperator binaryOperator = binaryExpression.getOperator();
        SymbolicExpression left = binaryExpression.getLeft();
        SymbolicExpression right = binaryExpression.getRight();
        if (binaryOperator instanceof StringContains) {
            if (!(left instanceof Variable)) {
                return Satisfiability.UNKNOWN;
            }
            return ((ExpressionInverseSet)this.getState((Identifier)left)).contains((Object)right) ? Satisfiability.SATISFIED : Satisfiability.UNKNOWN;
        }
        if (binaryOperator instanceof StringEquals || binaryOperator instanceof StringEndsWith || binaryOperator instanceof StringStartsWith) {
            if (!(left instanceof Variable) || !(right instanceof Variable)) {
                return Satisfiability.UNKNOWN;
            }
            return ((ExpressionInverseSet)this.getState((Identifier)left)).contains((Object)right) && ((ExpressionInverseSet)this.getState((Identifier)right)).contains((Object)left) ? Satisfiability.SATISFIED : Satisfiability.UNKNOWN;
        }
        if (binaryOperator instanceof LogicalOr) {
            if (!(left instanceof ValueExpression) || !(right instanceof ValueExpression)) {
                throw new SemanticException("!(left instanceof ValueExpression) || !(right instanceof ValueExpression)");
            }
            Satisfiability leftSatisfiability = this.satisfies((ValueExpression)left, pp, oracle);
            if (leftSatisfiability.equals((Object)Satisfiability.SATISFIED)) {
                return Satisfiability.SATISFIED;
            }
            Satisfiability rightSatisfiability = this.satisfies((ValueExpression)right, pp, oracle);
            return rightSatisfiability;
        }
        if (binaryOperator instanceof LogicalAnd) {
            if (!(left instanceof ValueExpression) || !(right instanceof ValueExpression)) {
                throw new SemanticException("!(left instanceof ValueExpression) || !(right instanceof ValueExpression)");
            }
            Satisfiability leftSatisfiability = this.satisfies((ValueExpression)left, pp, oracle);
            Satisfiability rightSatisfiability = this.satisfies((ValueExpression)right, pp, oracle);
            if (leftSatisfiability.equals((Object)Satisfiability.SATISFIED) && rightSatisfiability.equals((Object)Satisfiability.SATISFIED)) {
                return Satisfiability.SATISFIED;
            }
            return Satisfiability.UNKNOWN;
        }
        return Satisfiability.UNKNOWN;
    }

    public SubstringDomain pushScope(ScopeToken token) throws SemanticException {
        return new SubstringDomain(((ExpressionInverseSet)this.lattice).pushScope(token), this.mkNewFunction(this.function, true));
    }

    public SubstringDomain popScope(ScopeToken token) throws SemanticException {
        return new SubstringDomain(((ExpressionInverseSet)this.lattice).popScope(token), this.mkNewFunction(this.function, true));
    }

    private static List<ValueExpression> extr(ValueExpression expression) {
        ArrayList<ValueExpression> result = new ArrayList<ValueExpression>();
        if (expression instanceof BinaryExpression && ((BinaryExpression)expression).getOperator() instanceof StringConcat) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            ValueExpression left = (ValueExpression)binaryExpression.getLeft();
            ValueExpression right = (ValueExpression)binaryExpression.getRight();
            result.addAll(SubstringDomain.extr(left));
            result.addAll(SubstringDomain.extr(right));
        } else {
            result.add(expression);
        }
        return result;
    }

    private Set<SymbolicExpression> extrPlus(ValueExpression expression, ProgramPoint pp, SemanticOracle oracle, Type strType) throws SemanticException {
        List<ValueExpression> extracted = SubstringDomain.extr(expression);
        List<List<ValueExpression>> sub_expressions = this.split(extracted, pp, oracle, strType);
        for (int i = 0; i < sub_expressions.size(); ++i) {
            List<ValueExpression> list = sub_expressions.get(i);
            sub_expressions.set(i, SubstringDomain.mergeStringLiterals(list, strType));
        }
        HashSet<SymbolicExpression> result = new HashSet<SymbolicExpression>();
        for (List<ValueExpression> list : sub_expressions) {
            for (int l = 1; l <= list.size(); ++l) {
                for (int i = 0; i <= list.size() - l; ++i) {
                    ArrayList<Object> newList;
                    List<ValueExpression> subList = list.subList(i, i + l);
                    result.add(SubstringDomain.composeExpression(subList));
                    if (subList.size() == 1 && subList.get(0) instanceof Constant) {
                        Set<Constant> substrings = SubstringDomain.getSubstrings((Constant)subList.get(0));
                        for (Constant substring : substrings) {
                            newList = new ArrayList<Constant>();
                            newList.add(substring);
                            result.add(SubstringDomain.composeExpression(newList));
                        }
                        continue;
                    }
                    if (subList.get(0) instanceof Constant) {
                        Set<Constant> suffixes = SubstringDomain.getSuffix((Constant)subList.get(0));
                        for (Constant suffix : suffixes) {
                            newList = new ArrayList<ValueExpression>(subList);
                            newList.set(0, suffix);
                            if (subList.get(subList.size() - 1) instanceof Constant) {
                                Set<Constant> prefixes = SubstringDomain.getPrefix((Constant)subList.get(subList.size() - 1));
                                for (Constant prefix : prefixes) {
                                    newList.set(newList.size() - 1, prefix);
                                    result.add(SubstringDomain.composeExpression(newList));
                                }
                                continue;
                            }
                            result.add(SubstringDomain.composeExpression(newList));
                        }
                        continue;
                    }
                    if (!(subList.get(subList.size() - 1) instanceof Constant)) continue;
                    Set<Constant> prefixes = SubstringDomain.getPrefix((Constant)subList.get(subList.size() - 1));
                    for (Constant prefix : prefixes) {
                        newList = new ArrayList<ValueExpression>(subList);
                        newList.set(newList.size() - 1, prefix);
                        result.add(SubstringDomain.composeExpression(newList));
                    }
                }
            }
        }
        return new HashSet<SymbolicExpression>(result);
    }

    private List<List<ValueExpression>> split(List<ValueExpression> extracted, ProgramPoint pp, SemanticOracle oracle, Type strType) throws SemanticException {
        ArrayList<List<ValueExpression>> result = new ArrayList<List<ValueExpression>>();
        ArrayList<Object> temp = new ArrayList<Object>();
        for (ValueExpression s : extracted) {
            if (!(s instanceof Identifier) && !(s instanceof Constant)) {
                if (s instanceof TernaryExpression) {
                    Constant leftConstant;
                    List<ValueExpression> left;
                    TernaryExpression ternaryExpression = (TernaryExpression)s;
                    if (ternaryExpression.getOperator() instanceof StringReplace && ternaryExpression.getLeft() instanceof ValueExpression && ternaryExpression.getMiddle() instanceof ValueExpression && ternaryExpression.getRight() instanceof ValueExpression && this.hasOnlyConstants((ValueExpression)ternaryExpression.getLeft()) && this.hasOnlyConstants((ValueExpression)ternaryExpression.getMiddle()) && this.hasOnlyConstants((ValueExpression)ternaryExpression.getRight())) {
                        left = SubstringDomain.extr((ValueExpression)ternaryExpression.getLeft());
                        if ((left = SubstringDomain.mergeStringLiterals(left, strType)).size() != 1 && !(left.get(0) instanceof Constant)) {
                            throw new SemanticException("unexpected");
                        }
                        leftConstant = (Constant)left.get(0);
                        List<ValueExpression> middle = SubstringDomain.extr((ValueExpression)ternaryExpression.getMiddle());
                        if ((middle = SubstringDomain.mergeStringLiterals(middle, strType)).size() != 1 && !(middle.get(0) instanceof Constant)) {
                            throw new SemanticException("unexpected");
                        }
                        Constant middleConstant = (Constant)middle.get(0);
                        List<ValueExpression> right = SubstringDomain.extr((ValueExpression)ternaryExpression.getRight());
                        if ((right = SubstringDomain.mergeStringLiterals(right, strType)).size() != 1 && !(right.get(0) instanceof Constant)) {
                            throw new SemanticException("unexpected");
                        }
                        Constant rightConstant = (Constant)right.get(0);
                        String s1 = leftConstant.getValue() instanceof String ? (String)leftConstant.getValue() : leftConstant.getValue().toString();
                        String s2 = middleConstant.getValue() instanceof String ? (String)middleConstant.getValue() : middleConstant.getValue().toString();
                        String s3 = rightConstant.getValue() instanceof String ? (String)rightConstant.getValue() : rightConstant.getValue().toString();
                        temp.add(new Constant(strType, (Object)s1.replace(s2, s3), (CodeLocation)SyntheticLocation.INSTANCE));
                        continue;
                    }
                    if (ternaryExpression.getOperator() instanceof StringSubstring && ternaryExpression.getLeft() instanceof ValueExpression && ternaryExpression.getMiddle() instanceof Constant && ternaryExpression.getRight() instanceof Constant && this.hasOnlyConstants((ValueExpression)ternaryExpression.getLeft())) {
                        left = SubstringDomain.extr((ValueExpression)ternaryExpression.getLeft());
                        if ((left = SubstringDomain.mergeStringLiterals(left, strType)).size() != 1 && !(left.get(0) instanceof Constant)) {
                            throw new SemanticException("unexpected");
                        }
                        leftConstant = (Constant)left.get(0);
                        String s1 = leftConstant.getValue() instanceof String ? (String)leftConstant.getValue() : leftConstant.getValue().toString();
                        Integer i1 = (Integer)((Constant)ternaryExpression.getMiddle()).getValue();
                        Integer i2 = (Integer)((Constant)ternaryExpression.getRight()).getValue();
                        temp.add(new Constant(strType, (Object)s1.substring(i1, i2), (CodeLocation)SyntheticLocation.INSTANCE));
                        continue;
                    }
                }
                result.add(new ArrayList(temp));
                temp.clear();
                continue;
            }
            temp.add(s);
        }
        result.add(temp);
        return result;
    }

    private boolean hasOnlyConstants(ValueExpression expr) {
        if (expr instanceof Constant) {
            return true;
        }
        if (expr instanceof BinaryExpression && ((BinaryExpression)expr).getOperator() instanceof StringConcat) {
            BinaryExpression be = (BinaryExpression)expr;
            if (!(be.getLeft() instanceof ValueExpression) || !(be.getRight() instanceof ValueExpression)) {
                return false;
            }
            return this.hasOnlyConstants((ValueExpression)be.getLeft()) && this.hasOnlyConstants((ValueExpression)be.getRight());
        }
        return false;
    }

    private static List<ValueExpression> mergeStringLiterals(List<ValueExpression> extracted, Type strType) {
        ArrayList<ValueExpression> result = new ArrayList<ValueExpression>();
        StringBuilder recent = new StringBuilder();
        for (ValueExpression expr : extracted) {
            if (expr instanceof Constant) {
                Constant c = (Constant)expr;
                recent.append(c.getValue() instanceof String ? (String)c.getValue() : c.getValue().toString());
                continue;
            }
            if (recent.length() > 0) {
                result.add((ValueExpression)new Constant(strType, (Object)recent.toString(), (CodeLocation)SyntheticLocation.INSTANCE));
                recent.delete(0, recent.length());
            }
            result.add(expr);
        }
        if (recent.length() > 0) {
            result.add((ValueExpression)new Constant(strType, (Object)recent.toString(), (CodeLocation)SyntheticLocation.INSTANCE));
        }
        return result;
    }

    private static Set<Constant> getSubstrings(Constant c) {
        HashSet<Constant> result = new HashSet<Constant>();
        String str = c.getValue() instanceof String ? (String)c.getValue() : c.getValue().toString();
        for (int l = 1; l < str.length(); ++l) {
            for (int i = 0; i <= str.length() - l; ++i) {
                Constant substring = new Constant(c.getStaticType(), (Object)str.substring(i, i + l), (CodeLocation)SyntheticLocation.INSTANCE);
                result.add(substring);
            }
        }
        return result;
    }

    private static Set<Constant> getPrefix(Constant c) {
        HashSet<Constant> result = new HashSet<Constant>();
        String str = c.getValue() instanceof String ? (String)c.getValue() : c.getValue().toString();
        for (int i = 1; i <= str.length(); ++i) {
            Constant prefix = new Constant(c.getStaticType(), (Object)str.substring(0, i), (CodeLocation)SyntheticLocation.INSTANCE);
            result.add(prefix);
        }
        return result;
    }

    private static Set<Constant> getSuffix(Constant c) {
        HashSet<Constant> result = new HashSet<Constant>();
        String str = c.getValue() instanceof String ? (String)c.getValue() : c.getValue().toString();
        int length = str.length();
        for (int i = 1; i <= length; ++i) {
            Constant suffix = new Constant(c.getStaticType(), (Object)str.substring(length - i, length), (CodeLocation)SyntheticLocation.INSTANCE);
            result.add(suffix);
        }
        return result;
    }

    private static SymbolicExpression composeExpression(List<ValueExpression> expressions) {
        if (expressions.size() == 1) {
            return (SymbolicExpression)expressions.get(0);
        }
        return new BinaryExpression(expressions.get(0).getStaticType(), (SymbolicExpression)expressions.get(0), SubstringDomain.composeExpression(expressions.subList(1, expressions.size())), (BinaryOperator)StringConcat.INSTANCE, (CodeLocation)SyntheticLocation.INSTANCE);
    }

    protected SubstringDomain add(Set<SymbolicExpression> exprs, Identifier id) throws SemanticException {
        Map newFunction = this.mkNewFunction(this.function, false);
        HashSet<SymbolicExpression> expressionsToAdd = new HashSet<SymbolicExpression>();
        for (SymbolicExpression se : exprs) {
            if (SubstringDomain.appears(id, se)) continue;
            expressionsToAdd.add(se);
        }
        if (expressionsToAdd.isEmpty()) {
            return this;
        }
        ExpressionInverseSet newSet = new ExpressionInverseSet(expressionsToAdd);
        if (newFunction.get(id) != null) {
            newSet = (ExpressionInverseSet)newSet.glb((BaseLattice)((ExpressionInverseSet)newFunction.get(id)));
        }
        newFunction.put(id, newSet);
        return this.mk((ExpressionInverseSet)this.lattice, (Map<Identifier, ExpressionInverseSet>)newFunction);
    }

    protected SubstringDomain add(SymbolicExpression expr, Identifier id) throws SemanticException {
        HashSet<SymbolicExpression> expression = new HashSet<SymbolicExpression>();
        expression.add(expr);
        return this.add(expression, id);
    }

    private SubstringDomain remove(Set<SymbolicExpression> extracted, Identifier id) {
        Map newFunction = this.mkNewFunction(this.function, false);
        if (!extracted.contains(id)) {
            newFunction.remove(id);
        }
        for (Map.Entry entry : newFunction.entrySet()) {
            ExpressionInverseSet newSet = SubstringDomain.removeFromSet((ExpressionInverseSet)entry.getValue(), id);
            entry.setValue(newSet);
        }
        return this.mk((ExpressionInverseSet)this.lattice, (Map<Identifier, ExpressionInverseSet>)newFunction);
    }

    private static ExpressionInverseSet removeFromSet(ExpressionInverseSet source, Identifier id) {
        Set newSet = source.elements.stream().filter(element -> !SubstringDomain.appears(id, element)).collect(Collectors.toSet());
        return newSet.isEmpty() ? new ExpressionInverseSet().top() : new ExpressionInverseSet(newSet);
    }

    private SubstringDomain interasg(Identifier assignedId, SymbolicExpression assignedExpression) throws SemanticException {
        Map newFunction = this.mkNewFunction(this.function, false);
        if (!this.knowsIdentifier(assignedId)) {
            return this;
        }
        for (Map.Entry entry : this.function.entrySet()) {
            if (((Identifier)entry.getKey()).equals((Object)assignedId) || !((ExpressionInverseSet)entry.getValue()).contains((Object)assignedExpression)) continue;
            HashSet<Identifier> newRelation = new HashSet<Identifier>();
            newRelation.add(assignedId);
            ExpressionInverseSet newSet = (ExpressionInverseSet)((ExpressionInverseSet)newFunction.get(entry.getKey())).glb((BaseLattice)new ExpressionInverseSet(newRelation));
            newFunction.put((Identifier)entry.getKey(), newSet);
        }
        return this.mk((ExpressionInverseSet)this.lattice, (Map<Identifier, ExpressionInverseSet>)newFunction);
    }

    private SubstringDomain closure(Identifier id) throws SemanticException {
        if (this.isTop() || this.isBottom()) {
            return this;
        }
        SubstringDomain result = this.mk((ExpressionInverseSet)this.lattice, (Map<Identifier, ExpressionInverseSet>)this.mkNewFunction(this.function, false));
        ExpressionInverseSet set = (ExpressionInverseSet)result.getState(id);
        for (SymbolicExpression se : set) {
            Variable variable;
            if (!(se instanceof Variable) || !result.knowsIdentifier((Identifier)(variable = (Variable)se))) continue;
            HashSet<SymbolicExpression> add = new HashSet<SymbolicExpression>(((ExpressionInverseSet)result.getState((Object)variable)).elements);
            result = result.add(add, id);
        }
        return result;
    }

    protected SubstringDomain closure() throws SemanticException {
        SubstringDomain prev;
        if (this.isTop() || this.isBottom()) {
            return this;
        }
        SubstringDomain result = this.mk((ExpressionInverseSet)this.lattice, (Map<Identifier, ExpressionInverseSet>)this.mkNewFunction(this.function, false));
        do {
            prev = this.mk((ExpressionInverseSet)this.lattice, (Map<Identifier, ExpressionInverseSet>)this.mkNewFunction(result.function, false));
            Set set = prev.function.keySet();
            for (Identifier id : set) {
                result = result.closure(id);
            }
        } while (!prev.equals((Object)(result = result.clear())));
        return result;
    }

    private SubstringDomain clear() throws SemanticException {
        Map newMap = this.mkNewFunction(this.function, false);
        newMap.entrySet().removeIf(entry -> ((ExpressionInverseSet)entry.getValue()).isTop());
        return new SubstringDomain((ExpressionInverseSet)this.lattice, newMap);
    }

    private static boolean appears(Identifier id, SymbolicExpression expr) {
        if (expr instanceof Identifier) {
            return id.equals((Object)expr);
        }
        if (expr instanceof Constant) {
            return false;
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression expression = (BinaryExpression)expr;
            SymbolicExpression left = expression.getLeft();
            SymbolicExpression right = expression.getRight();
            return SubstringDomain.appears(id, left) || SubstringDomain.appears(id, right);
        }
        return false;
    }
}

