/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.string;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.nonrelational.value.BaseNonRelationalValueDomain;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonEq;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonGe;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonGt;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonLe;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonLt;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonNe;
import it.unive.lisa.symbolic.value.operator.binary.StringConcat;
import it.unive.lisa.symbolic.value.operator.ternary.StringReplace;
import it.unive.lisa.symbolic.value.operator.ternary.TernaryOperator;
import it.unive.lisa.symbolic.value.operator.unary.UnaryOperator;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;

public class StringConstantPropagation
implements BaseNonRelationalValueDomain<StringConstantPropagation> {
    private static final StringConstantPropagation TOP = new StringConstantPropagation(true, false);
    private static final StringConstantPropagation BOTTOM = new StringConstantPropagation(false, true);
    private final boolean isTop;
    private final boolean isBottom;
    private final String value;

    public StringConstantPropagation() {
        this(null, true, false);
    }

    private StringConstantPropagation(String value, boolean isTop, boolean isBottom) {
        this.value = value;
        this.isTop = isTop;
        this.isBottom = isBottom;
    }

    public StringConstantPropagation(String value) {
        this(value, false, false);
    }

    private StringConstantPropagation(boolean isTop, boolean isBottom) {
        this(null, isTop, isBottom);
    }

    public StringConstantPropagation top() {
        return TOP;
    }

    public boolean isTop() {
        return this.isTop;
    }

    public StringConstantPropagation bottom() {
        return BOTTOM;
    }

    public StructuredRepresentation representation() {
        if (this.isBottom()) {
            return Lattice.bottomRepresentation();
        }
        if (this.isTop()) {
            return Lattice.topRepresentation();
        }
        return new StringRepresentation(this.value);
    }

    public StringConstantPropagation evalNullConstant(ProgramPoint pp, SemanticOracle oracle) {
        return this.top();
    }

    public StringConstantPropagation evalNonNullConstant(Constant constant, ProgramPoint pp, SemanticOracle oracle) {
        if (constant.getValue() instanceof String) {
            return new StringConstantPropagation((String)constant.getValue());
        }
        return this.top();
    }

    public StringConstantPropagation evalUnaryExpression(UnaryOperator operator, StringConstantPropagation arg, ProgramPoint pp, SemanticOracle oracle) {
        return this.top();
    }

    public StringConstantPropagation evalBinaryExpression(BinaryOperator operator, StringConstantPropagation left, StringConstantPropagation right, ProgramPoint pp, SemanticOracle oracle) {
        if (operator instanceof StringConcat) {
            return left.isTop() || right.isTop() ? this.top() : new StringConstantPropagation(left.value + right.value);
        }
        return this.top();
    }

    public StringConstantPropagation evalTernaryExpression(TernaryOperator operator, StringConstantPropagation left, StringConstantPropagation middle, StringConstantPropagation right, ProgramPoint pp, SemanticOracle oracle) {
        if (operator instanceof StringReplace) {
            if (left.isTop() || right.isTop() || middle.isTop()) {
                return this.top();
            }
            String replaced = left.value;
            replaced = replaced.replace(middle.value, right.value);
            return new StringConstantPropagation(replaced);
        }
        return this.top();
    }

    public StringConstantPropagation lubAux(StringConstantPropagation other) throws SemanticException {
        return TOP;
    }

    public boolean lessOrEqualAux(StringConstantPropagation other) throws SemanticException {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isBottom ? 1231 : 1237);
        result = 31 * result + (this.isTop ? 1231 : 1237);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringConstantPropagation other = (StringConstantPropagation)obj;
        if (this.isBottom != other.isBottom) {
            return false;
        }
        if (this.isTop != other.isTop) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public Satisfiability satisfiesBinaryExpression(BinaryOperator operator, StringConstantPropagation left, StringConstantPropagation right, ProgramPoint pp, SemanticOracle oracle) {
        if (left.isTop() || right.isTop()) {
            return Satisfiability.UNKNOWN;
        }
        if (operator == ComparisonEq.INSTANCE) {
            return left.value.equals(right.value) ? Satisfiability.SATISFIED : Satisfiability.NOT_SATISFIED;
        }
        if (operator == ComparisonGe.INSTANCE) {
            return left.value.compareTo(right.value) >= 0 ? Satisfiability.SATISFIED : Satisfiability.NOT_SATISFIED;
        }
        if (operator == ComparisonGt.INSTANCE) {
            return left.value.compareTo(right.value) > 0 ? Satisfiability.SATISFIED : Satisfiability.NOT_SATISFIED;
        }
        if (operator == ComparisonLe.INSTANCE) {
            return left.value.compareTo(right.value) <= 0 ? Satisfiability.SATISFIED : Satisfiability.NOT_SATISFIED;
        }
        if (operator == ComparisonLt.INSTANCE) {
            return left.value.compareTo(right.value) < 0 ? Satisfiability.SATISFIED : Satisfiability.NOT_SATISFIED;
        }
        if (operator == ComparisonNe.INSTANCE) {
            return !left.value.equals(right.value) ? Satisfiability.SATISFIED : Satisfiability.NOT_SATISFIED;
        }
        return Satisfiability.UNKNOWN;
    }

    protected String getValue() throws SemanticException {
        if (this.isTop() || this.isBottom()) {
            throw new SemanticException("The abstract domain is top or bottom; can't get the constant value");
        }
        return this.value;
    }
}

