/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.string;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.nonrelational.value.BaseNonRelationalValueDomain;
import it.unive.lisa.analysis.string.ContainsCharProvider;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.binary.StringConcat;
import it.unive.lisa.symbolic.value.operator.binary.StringContains;
import it.unive.lisa.symbolic.value.operator.binary.StringEndsWith;
import it.unive.lisa.symbolic.value.operator.binary.StringEquals;
import it.unive.lisa.symbolic.value.operator.binary.StringIndexOf;
import it.unive.lisa.symbolic.value.operator.binary.StringStartsWith;
import it.unive.lisa.symbolic.value.operator.ternary.StringReplace;
import it.unive.lisa.symbolic.value.operator.ternary.TernaryOperator;
import it.unive.lisa.util.numeric.IntInterval;
import it.unive.lisa.util.numeric.MathNumber;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Objects;

public class Prefix
implements BaseNonRelationalValueDomain<Prefix>,
ContainsCharProvider {
    private static final Prefix TOP = new Prefix();
    private static final Prefix BOTTOM = new Prefix(null);
    private final String prefix;

    public Prefix() {
        this("");
    }

    public Prefix(String prefix) {
        this.prefix = prefix;
    }

    public Prefix lubAux(Prefix other) throws SemanticException {
        String otherPrefixString = other.prefix;
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i <= this.prefix.length() - 1 && i <= otherPrefixString.length() - 1 && this.prefix.charAt(i) == otherPrefixString.charAt(i)) {
            result.append(this.prefix.charAt(i++));
        }
        if (result.length() != 0) {
            return new Prefix(result.toString());
        }
        return TOP;
    }

    public boolean lessOrEqualAux(Prefix other) throws SemanticException {
        if (other.prefix.length() <= this.prefix.length()) {
            Prefix lub = this.lubAux(other);
            return lub.prefix.length() == other.prefix.length();
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Prefix prefix1 = (Prefix)o;
        return Objects.equals(this.prefix, prefix1.prefix);
    }

    public int hashCode() {
        return Objects.hash(this.prefix);
    }

    public Prefix top() {
        return TOP;
    }

    public Prefix bottom() {
        return BOTTOM;
    }

    public StructuredRepresentation representation() {
        if (this.isBottom()) {
            return Lattice.bottomRepresentation();
        }
        if (this.isTop()) {
            return Lattice.topRepresentation();
        }
        return new StringRepresentation(this.prefix + "*");
    }

    public Prefix evalNonNullConstant(Constant constant, ProgramPoint pp, SemanticOracle oracle) {
        String str;
        if (constant.getValue() instanceof String && !(str = (String)constant.getValue()).isEmpty()) {
            return new Prefix(str);
        }
        return TOP;
    }

    public Prefix evalBinaryExpression(BinaryOperator operator, Prefix left, Prefix right, ProgramPoint pp, SemanticOracle oracle) {
        if (operator == StringConcat.INSTANCE) {
            return left;
        }
        if (operator == StringContains.INSTANCE || operator == StringEndsWith.INSTANCE || operator == StringEquals.INSTANCE || operator == StringIndexOf.INSTANCE || operator == StringStartsWith.INSTANCE) {
            return TOP;
        }
        return TOP;
    }

    public Prefix evalTernaryExpression(TernaryOperator operator, Prefix left, Prefix middle, Prefix right, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (operator == StringReplace.INSTANCE) {
            String replace = right.getPrefix();
            String string = middle.getPrefix();
            String target = left.getPrefix();
            if (!target.contains(replace)) {
                return this;
            }
            return new Prefix(target.replace(replace, string));
        }
        return TOP;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Prefix substring(long begin, long end) {
        if (this.isTop() || this.isBottom()) {
            return this;
        }
        if (end <= (long)this.getPrefix().length()) {
            return new Prefix(this.getPrefix().substring((int)begin, (int)end));
        }
        if (begin < (long)this.getPrefix().length()) {
            return new Prefix(this.getPrefix().substring((int)begin));
        }
        return new Prefix("");
    }

    public IntInterval length() {
        return new IntInterval(new MathNumber((long)this.prefix.length()), MathNumber.PLUS_INFINITY);
    }

    public IntInterval indexOf(Prefix s) {
        return new IntInterval(MathNumber.MINUS_ONE, MathNumber.PLUS_INFINITY);
    }

    @Override
    public Satisfiability containsChar(char c) {
        if (this.isTop()) {
            return Satisfiability.UNKNOWN;
        }
        if (this.isBottom()) {
            return Satisfiability.BOTTOM;
        }
        return this.prefix.contains(String.valueOf(c)) ? Satisfiability.SATISFIED : Satisfiability.UNKNOWN;
    }
}

