/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.string;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.nonrelational.value.BaseNonRelationalValueDomain;
import it.unive.lisa.analysis.string.ContainsCharProvider;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.binary.StringConcat;
import it.unive.lisa.symbolic.value.operator.binary.StringContains;
import it.unive.lisa.symbolic.value.operator.binary.StringEndsWith;
import it.unive.lisa.symbolic.value.operator.binary.StringEquals;
import it.unive.lisa.symbolic.value.operator.binary.StringIndexOf;
import it.unive.lisa.symbolic.value.operator.binary.StringStartsWith;
import it.unive.lisa.symbolic.value.operator.ternary.StringReplace;
import it.unive.lisa.symbolic.value.operator.ternary.TernaryOperator;
import it.unive.lisa.util.numeric.IntInterval;
import it.unive.lisa.util.numeric.MathNumber;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CharInclusion
implements BaseNonRelationalValueDomain<CharInclusion>,
ContainsCharProvider {
    private final Set<Character> certainlyContained;
    private final Set<Character> maybeContained;
    private static final CharInclusion TOP = new CharInclusion();
    private static final CharInclusion BOTTOM = new CharInclusion(null, null);

    public CharInclusion() {
        this(new TreeSet<Character>(), null);
    }

    public CharInclusion(Set<Character> certainlyContained, Set<Character> maybeContained) {
        this.certainlyContained = certainlyContained;
        this.maybeContained = maybeContained;
    }

    public CharInclusion lubAux(CharInclusion other) throws SemanticException {
        TreeSet<Character> lubAuxMaybe;
        TreeSet<Character> lubAuxCertainly = new TreeSet<Character>();
        if (this.maybeContained == null || other.maybeContained == null) {
            lubAuxMaybe = null;
        } else {
            lubAuxMaybe = new TreeSet<Character>();
            lubAuxMaybe.addAll(this.maybeContained);
            lubAuxMaybe.addAll(other.maybeContained);
        }
        for (Character certainlyContainedChar : this.certainlyContained) {
            if (!other.certainlyContained.contains(certainlyContainedChar)) continue;
            lubAuxCertainly.add(certainlyContainedChar);
        }
        return new CharInclusion(lubAuxCertainly, lubAuxMaybe);
    }

    public boolean lessOrEqualAux(CharInclusion other) throws SemanticException {
        if (this.certainlyContained.size() > other.certainlyContained.size()) {
            return false;
        }
        if (!other.certainlyContained.containsAll(this.certainlyContained)) {
            return false;
        }
        if (other.maybeContained == null) {
            return true;
        }
        if (this.maybeContained == null) {
            return false;
        }
        if (this.maybeContained.size() > other.maybeContained.size()) {
            return false;
        }
        return other.maybeContained.containsAll(this.maybeContained);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharInclusion that = (CharInclusion)o;
        return Objects.equals(this.certainlyContained, that.certainlyContained) && Objects.equals(this.maybeContained, that.maybeContained);
    }

    public int hashCode() {
        return Objects.hash(this.certainlyContained, this.maybeContained);
    }

    public CharInclusion top() {
        return TOP;
    }

    public CharInclusion bottom() {
        return BOTTOM;
    }

    public StructuredRepresentation representation() {
        if (this.isBottom()) {
            return Lattice.bottomRepresentation();
        }
        if (this.isTop()) {
            return Lattice.topRepresentation();
        }
        return new StringRepresentation(this.formatRepresentation());
    }

    public Set<Character> getCertainlyContained() {
        return this.certainlyContained;
    }

    public Set<Character> getMaybeContained() {
        return this.maybeContained;
    }

    private String formatRepresentation() {
        return "CertainlyContained: {" + StringUtils.join(this.certainlyContained, (String)", ") + "}, MaybeContained: {" + (this.maybeContained == null ? "\u03a3" : StringUtils.join(this.maybeContained, (String)", ")) + "}";
    }

    public CharInclusion evalNonNullConstant(Constant constant, ProgramPoint pp, SemanticOracle oracle) {
        if (constant.getValue() instanceof String) {
            Set charsSet = ((String)constant.getValue()).chars().mapToObj(e -> Character.valueOf((char)e)).collect(Collectors.toCollection(TreeSet::new));
            return new CharInclusion(charsSet, charsSet);
        }
        return TOP;
    }

    public CharInclusion evalBinaryExpression(BinaryOperator operator, CharInclusion left, CharInclusion right, ProgramPoint pp, SemanticOracle oracle) {
        if (operator == StringConcat.INSTANCE) {
            TreeSet<Character> resultMaybeContained;
            TreeSet<Character> resultCertainlyContained = new TreeSet<Character>();
            resultCertainlyContained.addAll(left.certainlyContained);
            resultCertainlyContained.addAll(right.certainlyContained);
            if (left.maybeContained == null || right.maybeContained == null) {
                resultMaybeContained = null;
            } else {
                resultMaybeContained = new TreeSet<Character>();
                resultMaybeContained.addAll(left.maybeContained);
                resultMaybeContained.addAll(right.maybeContained);
            }
            return new CharInclusion(resultCertainlyContained, resultMaybeContained);
        }
        if (operator == StringContains.INSTANCE || operator == StringEndsWith.INSTANCE || operator == StringEquals.INSTANCE || operator == StringIndexOf.INSTANCE || operator == StringStartsWith.INSTANCE) {
            return TOP;
        }
        return TOP;
    }

    public CharInclusion evalTernaryExpression(TernaryOperator operator, CharInclusion left, CharInclusion middle, CharInclusion right, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (operator == StringReplace.INSTANCE) {
            if (!left.certainlyContained.containsAll(middle.certainlyContained)) {
                return this;
            }
            TreeSet<Character> included = new TreeSet<Character>(left.certainlyContained);
            TreeSet<Character> possibly = new TreeSet<Character>(left.maybeContained);
            included.removeAll(middle.certainlyContained);
            possibly.addAll(middle.certainlyContained);
            included.removeAll(middle.maybeContained);
            TreeSet<Character> tmp = new TreeSet<Character>(middle.maybeContained);
            tmp.retainAll(left.certainlyContained);
            possibly.addAll(tmp);
            possibly.addAll(right.certainlyContained);
            possibly.addAll(right.maybeContained);
            return new CharInclusion(included, possibly);
        }
        return TOP;
    }

    public Satisfiability satisfiesBinaryExpression(BinaryOperator operator, CharInclusion left, CharInclusion right, ProgramPoint pp, SemanticOracle oracle) {
        if (left.isTop() || right.isBottom()) {
            return Satisfiability.UNKNOWN;
        }
        if (operator == StringContains.INSTANCE && right.isEmptyString()) {
            return Satisfiability.SATISFIED;
        }
        return Satisfiability.UNKNOWN;
    }

    private boolean isEmptyString() {
        return this.maybeContained != null && this.maybeContained.isEmpty() && this.certainlyContained.isEmpty();
    }

    public CharInclusion substring(long begin, long end) {
        if (this.isTop() || this.isBottom()) {
            return this;
        }
        return new CharInclusion(new TreeSet<Character>(), this.maybeContained);
    }

    public IntInterval length() {
        return new IntInterval(new MathNumber((long)this.certainlyContained.size()), MathNumber.PLUS_INFINITY);
    }

    public IntInterval indexOf(CharInclusion s) {
        return new IntInterval(MathNumber.MINUS_ONE, MathNumber.PLUS_INFINITY);
    }

    @Override
    public Satisfiability containsChar(char c) {
        if (this.isTop()) {
            return Satisfiability.UNKNOWN;
        }
        if (this.isBottom()) {
            return Satisfiability.BOTTOM;
        }
        if (this.certainlyContained.contains(Character.valueOf(c))) {
            return Satisfiability.SATISFIED;
        }
        if (this.maybeContained == null || this.maybeContained.contains(Character.valueOf(c))) {
            return Satisfiability.UNKNOWN;
        }
        return Satisfiability.NOT_SATISFIED;
    }
}

