/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.stability;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.nonrelational.value.BaseNonRelationalValueDomain;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.PushInv;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Objects;
import java.util.Set;

public class Trend
implements BaseNonRelationalValueDomain<Trend> {
    public static final Trend TOP = new Trend(0);
    public static final Trend BOTTOM = new Trend(1);
    public static final Trend STABLE = new Trend(2);
    public static final Trend INC = new Trend(3);
    public static final Trend DEC = new Trend(4);
    public static final Trend NON_DEC = new Trend(5);
    public static final Trend NON_INC = new Trend(6);
    public static final Trend NON_STABLE = new Trend(7);
    private final byte trend;

    public Trend() {
        this(0);
    }

    private Trend(byte trend) {
        this.trend = trend;
    }

    public boolean isStable() {
        return this.trend == Trend.STABLE.trend;
    }

    public boolean isInc() {
        return this.trend == Trend.INC.trend;
    }

    public boolean isDec() {
        return this.trend == Trend.DEC.trend;
    }

    public boolean isNonDec() {
        return this.trend == Trend.NON_DEC.trend;
    }

    public boolean isNonInc() {
        return this.trend == Trend.NON_INC.trend;
    }

    public boolean isNonStable() {
        return this.trend == Trend.NON_STABLE.trend;
    }

    public Satisfiability isPossiblyGrowing() {
        return this.isInc() || this.isNonDec() ? Satisfiability.SATISFIED : (this.isDec() || this.isNonInc() ? Satisfiability.NOT_SATISFIED : Satisfiability.UNKNOWN);
    }

    public Trend combine(Trend other) throws SemanticException {
        if (this.isBottom() || other.isBottom()) {
            return BOTTOM;
        }
        if (this.isTop() || other.isTop()) {
            return TOP;
        }
        if (this.isStable()) {
            return other;
        }
        if (other.isStable()) {
            return this;
        }
        if (this.isNonStable() || other.isNonStable() || this.isPossiblyGrowing() != other.isPossiblyGrowing()) {
            return TOP;
        }
        if (this.lessOrEqual((BaseLattice)other)) {
            return this;
        }
        if (other.lessOrEqual((BaseLattice)this)) {
            return other;
        }
        return TOP;
    }

    public Trend invert() {
        if (this.isTop() || this.isBottom() || this.isStable() || this.isNonStable()) {
            return this;
        }
        if (this.isInc()) {
            return DEC;
        }
        if (this.isDec()) {
            return INC;
        }
        if (this.isNonInc()) {
            return NON_DEC;
        }
        if (this.isNonDec()) {
            return NON_INC;
        }
        return BOTTOM;
    }

    public int hashCode() {
        return Objects.hash(this.trend);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Trend other = (Trend)obj;
        return this.trend == other.trend;
    }

    public boolean lessOrEqualAux(Trend other) throws SemanticException {
        if (this.isStable()) {
            return other.isNonInc() || other.isNonDec();
        }
        if (this.isInc()) {
            return other.isNonDec() || other.isNonStable();
        }
        if (this.isDec()) {
            return other.isNonInc() || other.isNonStable();
        }
        return false;
    }

    public Trend lubAux(Trend other) throws SemanticException {
        if (this.lessOrEqual((BaseLattice)other)) {
            return other;
        }
        if (other.lessOrEqual((BaseLattice)this)) {
            return this;
        }
        if (this.isStable() && other.isInc() || this.isInc() && other.isStable()) {
            return NON_DEC;
        }
        if (this.isStable() && other.isDec() || this.isDec() && other.isStable()) {
            return NON_INC;
        }
        if (this.isInc() && other.isDec() || this.isDec() && other.isInc()) {
            return NON_STABLE;
        }
        return TOP;
    }

    public Trend glbAux(Trend other) throws SemanticException {
        if (this.lessOrEqual((BaseLattice)other)) {
            return this;
        }
        if (other.lessOrEqual((BaseLattice)this)) {
            return other;
        }
        if (this.isNonDec() && other.isNonStable() || this.isNonStable() && other.isNonDec()) {
            return INC;
        }
        if (this.isNonInc() && other.isNonStable() || this.isNonStable() && other.isNonInc()) {
            return DEC;
        }
        if (this.isNonDec() && other.isNonInc() || this.isNonInc() && other.isNonDec()) {
            return STABLE;
        }
        return BOTTOM;
    }

    public Trend top() {
        return TOP;
    }

    public Trend bottom() {
        return BOTTOM;
    }

    public StructuredRepresentation representation() {
        if (this.isBottom()) {
            return Lattice.bottomRepresentation();
        }
        if (this.isTop()) {
            return Lattice.topRepresentation();
        }
        String repr = this.isStable() ? "=" : (this.isInc() ? "\u2191" : (this.isDec() ? "\u2193" : (this.isNonDec() ? "\u2191=" : (this.isNonInc() ? "\u2193=" : "\u2260"))));
        return new StringRepresentation(repr);
    }

    public boolean canProcess(SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) {
        if (expression instanceof PushInv) {
            return expression.getStaticType().isNumericType();
        }
        Set rts = null;
        try {
            rts = oracle.getRuntimeTypesOf(expression, pp, oracle);
        }
        catch (SemanticException e) {
            return false;
        }
        if (rts == null || rts.isEmpty()) {
            return true;
        }
        return rts.stream().anyMatch(Type::isNumericType);
    }

    public String toString() {
        return this.representation().toString();
    }
}

