/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.numeric;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.nonrelational.value.BaseNonRelationalValueDomain;
import it.unive.lisa.analysis.nonrelational.value.ValueEnvironment;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.symbolic.value.operator.AdditionOperator;
import it.unive.lisa.symbolic.value.operator.DivisionOperator;
import it.unive.lisa.symbolic.value.operator.ModuloOperator;
import it.unive.lisa.symbolic.value.operator.MultiplicationOperator;
import it.unive.lisa.symbolic.value.operator.RemainderOperator;
import it.unive.lisa.symbolic.value.operator.SubtractionOperator;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonEq;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonGe;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonGt;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonLe;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonLt;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonNe;
import it.unive.lisa.symbolic.value.operator.ternary.TernaryOperator;
import it.unive.lisa.symbolic.value.operator.unary.NumericNegation;
import it.unive.lisa.symbolic.value.operator.unary.UnaryOperator;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;

public class Sign
implements BaseNonRelationalValueDomain<Sign> {
    public static final Sign POS = new Sign(4);
    public static final Sign NEG = new Sign(3);
    public static final Sign ZERO = new Sign(2);
    public static final Sign TOP = new Sign(0);
    public static final Sign BOTTOM = new Sign(1);
    private final byte sign;

    public Sign() {
        this(0);
    }

    public Sign(byte sign) {
        this.sign = sign;
    }

    public Sign top() {
        return TOP;
    }

    public Sign bottom() {
        return BOTTOM;
    }

    public String toString() {
        return this.representation().toString();
    }

    public StructuredRepresentation representation() {
        if (this.isBottom()) {
            return Lattice.bottomRepresentation();
        }
        if (this.isTop()) {
            return Lattice.topRepresentation();
        }
        String repr = this == ZERO ? "0" : (this == POS ? "+" : "-");
        return new StringRepresentation(repr);
    }

    public Sign evalNullConstant(ProgramPoint pp, SemanticOracle oracle) {
        return this.top();
    }

    public Sign evalNonNullConstant(Constant constant, ProgramPoint pp, SemanticOracle oracle) {
        if (constant.getValue() instanceof Integer) {
            Integer i = (Integer)constant.getValue();
            return i == 0 ? ZERO : (i > 0 ? POS : NEG);
        }
        return this.top();
    }

    public boolean isPositive() {
        return this == POS;
    }

    public boolean isZero() {
        return this == ZERO;
    }

    public boolean isNegative() {
        return this == NEG;
    }

    public Sign opposite() {
        if (this.isTop() || this.isBottom()) {
            return this;
        }
        return this.isPositive() ? NEG : (this.isNegative() ? POS : ZERO);
    }

    public Sign evalUnaryExpression(UnaryOperator operator, Sign arg, ProgramPoint pp, SemanticOracle oracle) {
        if (operator == NumericNegation.INSTANCE) {
            if (arg.isPositive()) {
                return NEG;
            }
            if (arg.isNegative()) {
                return POS;
            }
            if (arg.isZero()) {
                return ZERO;
            }
            return TOP;
        }
        return TOP;
    }

    public Sign evalBinaryExpression(BinaryOperator operator, Sign left, Sign right, ProgramPoint pp, SemanticOracle oracle) {
        if (operator instanceof AdditionOperator) {
            if (left.isZero()) {
                return right;
            }
            if (right.isZero()) {
                return left;
            }
            if (left.equals(right)) {
                return left;
            }
            return this.top();
        }
        if (operator instanceof SubtractionOperator) {
            if (left.isZero()) {
                return right.opposite();
            }
            if (right.isZero()) {
                return left;
            }
            if (left.equals(right)) {
                return this.top();
            }
            return left;
        }
        if (operator instanceof DivisionOperator) {
            if (right.isZero()) {
                return this.bottom();
            }
            if (left.isZero()) {
                return ZERO;
            }
            if (left.equals(right)) {
                return left.isTop() ? left : POS;
            }
            if (!left.isTop() && left.equals(right.opposite())) {
                return NEG;
            }
            return this.top();
        }
        if (operator instanceof ModuloOperator) {
            return right;
        }
        if (operator instanceof RemainderOperator) {
            return left;
        }
        if (operator instanceof MultiplicationOperator) {
            if (left.isZero() || right.isZero()) {
                return ZERO;
            }
            if (left.equals(right)) {
                return POS;
            }
            return NEG;
        }
        return TOP;
    }

    public Sign lubAux(Sign other) throws SemanticException {
        return TOP;
    }

    public boolean lessOrEqualAux(Sign other) throws SemanticException {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.sign;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sign other = (Sign)obj;
        return this.sign == other.sign;
    }

    public Satisfiability satisfiesBinaryExpression(BinaryOperator operator, Sign left, Sign right, ProgramPoint pp, SemanticOracle oracle) {
        if (left.isTop() || right.isTop()) {
            return Satisfiability.UNKNOWN;
        }
        if (operator == ComparisonEq.INSTANCE) {
            return left.eq(right);
        }
        if (operator == ComparisonGe.INSTANCE) {
            return left.eq(right).or(left.gt(right));
        }
        if (operator == ComparisonGt.INSTANCE) {
            return left.gt(right);
        }
        if (operator == ComparisonLe.INSTANCE) {
            return left.gt(right).negate();
        }
        if (operator == ComparisonLt.INSTANCE) {
            return left.gt(right).negate().and(left.eq(right).negate());
        }
        if (operator == ComparisonNe.INSTANCE) {
            return left.eq(right).negate();
        }
        return Satisfiability.UNKNOWN;
    }

    public Satisfiability eq(Sign other) {
        if (!this.equals(other)) {
            return Satisfiability.NOT_SATISFIED;
        }
        if (this.isZero()) {
            return Satisfiability.SATISFIED;
        }
        return Satisfiability.UNKNOWN;
    }

    public Satisfiability gt(Sign other) {
        if (this.equals(other)) {
            return this.isZero() ? Satisfiability.NOT_SATISFIED : Satisfiability.UNKNOWN;
        }
        if (this.isZero()) {
            return other.isPositive() ? Satisfiability.NOT_SATISFIED : Satisfiability.SATISFIED;
        }
        if (this.isPositive()) {
            return Satisfiability.SATISFIED;
        }
        return Satisfiability.NOT_SATISFIED;
    }

    public Satisfiability satisfiesTernaryExpression(TernaryOperator operator, Sign left, Sign middle, Sign right, ProgramPoint pp, SemanticOracle oracle) {
        return Satisfiability.UNKNOWN;
    }

    public ValueEnvironment<Sign> assumeBinaryExpression(ValueEnvironment<Sign> environment, BinaryOperator operator, ValueExpression left, ValueExpression right, ProgramPoint src, ProgramPoint dest, SemanticOracle oracle) throws SemanticException {
        boolean rightIsExpr;
        Identifier id;
        Sign eval;
        if (left instanceof Identifier) {
            eval = (Sign)this.eval(right, environment, src, oracle);
            id = (Identifier)left;
            rightIsExpr = true;
        } else if (right instanceof Identifier) {
            eval = (Sign)this.eval(left, environment, src, oracle);
            id = (Identifier)right;
            rightIsExpr = false;
        } else {
            return environment;
        }
        Sign starting = (Sign)environment.getState((Object)id);
        if (eval.isBottom() || starting.isBottom()) {
            return environment.bottom();
        }
        Sign update = null;
        if (operator == ComparisonEq.INSTANCE) {
            update = eval;
        } else if (operator == ComparisonGe.INSTANCE) {
            if (rightIsExpr && eval.isPositive()) {
                update = eval;
            } else if (!rightIsExpr && eval.isNegative()) {
                update = eval;
            }
        } else if (operator == ComparisonLe.INSTANCE) {
            if (rightIsExpr && eval.isNegative()) {
                update = eval;
            } else if (!rightIsExpr && eval.isPositive()) {
                update = eval;
            }
        } else if (operator == ComparisonLt.INSTANCE) {
            if (rightIsExpr && (eval.isNegative() || eval.isZero())) {
                update = NEG;
            } else if (!rightIsExpr && (eval.isPositive() || eval.isZero())) {
                update = POS;
            }
        } else if (operator == ComparisonGt.INSTANCE) {
            if (rightIsExpr && (eval.isPositive() || eval.isZero())) {
                update = POS;
            } else if (!rightIsExpr && (eval.isNegative() || eval.isZero())) {
                update = NEG;
            }
        }
        if (update == null) {
            return environment;
        }
        if (update.isBottom()) {
            return environment.bottom();
        }
        return (ValueEnvironment)environment.putState((Object)id, (Lattice)update);
    }
}

