/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.numeric;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.nonrelational.value.NonRelationalValueDomain;
import it.unive.lisa.analysis.nonrelational.value.ValueEnvironment;
import it.unive.lisa.analysis.numeric.Interval;
import it.unive.lisa.analysis.numeric.UpperBounds;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.BinaryExpression;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.symbolic.value.operator.RemainderOperator;
import it.unive.lisa.symbolic.value.operator.SubtractionOperator;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.util.numeric.MathNumber;
import it.unive.lisa.util.representation.MapRepresentation;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.collections4.CollectionUtils;

public class Pentagon
implements ValueDomain<Pentagon>,
BaseLattice<Pentagon> {
    private final ValueEnvironment<Interval> intervals;
    private final ValueEnvironment<UpperBounds> upperBounds;

    public Pentagon() {
        this.intervals = new ValueEnvironment((NonRelationalValueDomain)new Interval()).top();
        this.upperBounds = new ValueEnvironment((NonRelationalValueDomain)new UpperBounds(true)).top();
    }

    public Pentagon(ValueEnvironment<Interval> intervals, ValueEnvironment<UpperBounds> upperBounds) {
        this.intervals = intervals;
        this.upperBounds = upperBounds;
    }

    public Pentagon assign(Identifier id, ValueExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        ValueEnvironment newBounds = (ValueEnvironment)this.upperBounds.assign(id, (SymbolicExpression)expression, pp, oracle);
        ValueEnvironment newIntervals = (ValueEnvironment)this.intervals.assign(id, (SymbolicExpression)expression, pp, oracle);
        if (expression instanceof BinaryExpression) {
            BinaryExpression be = (BinaryExpression)expression;
            BinaryOperator op = be.getOperator();
            if (op instanceof SubtractionOperator) {
                if (be.getLeft() instanceof Identifier) {
                    Identifier y;
                    Identifier x = (Identifier)be.getLeft();
                    if (be.getRight() instanceof Constant) {
                        newBounds = (ValueEnvironment)newBounds.putState((Object)id, (Lattice)((UpperBounds)this.upperBounds.getState((Object)x)).add(x));
                    } else if (be.getRight() instanceof Identifier && ((UpperBounds)newBounds.getState((Object)(y = (Identifier)be.getRight()))).contains(x)) {
                        newIntervals = (ValueEnvironment)newIntervals.putState((Object)id, (Lattice)((Interval)((Interval)newIntervals.getState((Object)id)).glb((BaseLattice)new Interval(MathNumber.ONE, MathNumber.PLUS_INFINITY))));
                    }
                }
            } else if (op instanceof RemainderOperator && be.getRight() instanceof Identifier) {
                Identifier d = (Identifier)be.getRight();
                MathNumber low = ((Interval)this.intervals.getState((Object)d)).interval.getLow();
                newBounds = low.isPositive() || low.isZero() ? (ValueEnvironment)newBounds.putState((Object)id, (Lattice)new UpperBounds(Collections.singleton(d))) : (ValueEnvironment)newBounds.putState((Object)id, (Lattice)new UpperBounds().top());
            }
        }
        return new Pentagon((ValueEnvironment<Interval>)newIntervals, (ValueEnvironment<UpperBounds>)newBounds).closure();
    }

    public Pentagon smallStepSemantics(ValueExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return new Pentagon((ValueEnvironment<Interval>)((ValueEnvironment)this.intervals.smallStepSemantics((SymbolicExpression)expression, pp, oracle)), (ValueEnvironment<UpperBounds>)((ValueEnvironment)this.upperBounds.smallStepSemantics((SymbolicExpression)expression, pp, oracle)));
    }

    public Pentagon assume(ValueExpression expression, ProgramPoint src, ProgramPoint dest, SemanticOracle oracle) throws SemanticException {
        return new Pentagon((ValueEnvironment<Interval>)((ValueEnvironment)this.intervals.assume((SymbolicExpression)expression, src, dest, oracle)), (ValueEnvironment<UpperBounds>)((ValueEnvironment)this.upperBounds.assume((SymbolicExpression)expression, src, dest, oracle)));
    }

    public Pentagon forgetIdentifier(Identifier id) throws SemanticException {
        return new Pentagon((ValueEnvironment<Interval>)((ValueEnvironment)this.intervals.forgetIdentifier(id)), (ValueEnvironment<UpperBounds>)((ValueEnvironment)this.upperBounds.forgetIdentifier(id)));
    }

    public Pentagon forgetIdentifiersIf(Predicate<Identifier> test) throws SemanticException {
        return new Pentagon((ValueEnvironment<Interval>)((ValueEnvironment)this.intervals.forgetIdentifiersIf(test)), (ValueEnvironment<UpperBounds>)((ValueEnvironment)this.upperBounds.forgetIdentifiersIf(test)));
    }

    public Satisfiability satisfies(ValueExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return this.intervals.satisfies((SymbolicExpression)expression, pp, oracle).glb(this.upperBounds.satisfies((SymbolicExpression)expression, pp, oracle));
    }

    public Pentagon pushScope(ScopeToken token) throws SemanticException {
        return new Pentagon((ValueEnvironment<Interval>)((ValueEnvironment)this.intervals.pushScope(token)), (ValueEnvironment<UpperBounds>)((ValueEnvironment)this.upperBounds.pushScope(token)));
    }

    public Pentagon popScope(ScopeToken token) throws SemanticException {
        return new Pentagon((ValueEnvironment<Interval>)((ValueEnvironment)this.intervals.popScope(token)), (ValueEnvironment<UpperBounds>)((ValueEnvironment)this.upperBounds.popScope(token)));
    }

    public StructuredRepresentation representation() {
        if (this.isTop()) {
            return Lattice.topRepresentation();
        }
        if (this.isBottom()) {
            return Lattice.bottomRepresentation();
        }
        HashMap<StringRepresentation, StringRepresentation> mapping = new HashMap<StringRepresentation, StringRepresentation>();
        for (Identifier id : CollectionUtils.union((Iterable)this.intervals.getKeys(), (Iterable)this.upperBounds.getKeys())) {
            mapping.put(new StringRepresentation((Object)id), new StringRepresentation(((Interval)this.intervals.getState((Object)id)).toString() + ", " + ((UpperBounds)this.upperBounds.getState((Object)id)).representation()));
        }
        return new MapRepresentation(mapping);
    }

    public Pentagon top() {
        return new Pentagon((ValueEnvironment<Interval>)this.intervals.top(), (ValueEnvironment<UpperBounds>)this.upperBounds.top());
    }

    public boolean isTop() {
        return this.intervals.isTop() && this.upperBounds.isTop();
    }

    public Pentagon bottom() {
        return new Pentagon((ValueEnvironment<Interval>)this.intervals.bottom(), (ValueEnvironment<UpperBounds>)this.upperBounds.bottom());
    }

    public boolean isBottom() {
        return this.intervals.isBottom() && this.upperBounds.isBottom();
    }

    private Pentagon closure() throws SemanticException {
        ValueEnvironment newBounds = new ValueEnvironment((NonRelationalValueDomain)((UpperBounds)this.upperBounds.lattice), this.upperBounds.getMap());
        for (Identifier id1 : this.intervals.getKeys()) {
            HashSet<Identifier> closure = new HashSet<Identifier>();
            for (Identifier id2 : this.intervals.getKeys()) {
                if (id1.equals((Object)id2) || ((Interval)this.intervals.getState((Object)id1)).interval.getHigh().compareTo(((Interval)this.intervals.getState((Object)id2)).interval.getLow()) >= 0) continue;
                closure.add(id2);
            }
            if (closure.isEmpty()) continue;
            newBounds = (ValueEnvironment)newBounds.putState((Object)id1, (Lattice)((UpperBounds)((UpperBounds)newBounds.getState((Object)id1)).glb((BaseLattice)new UpperBounds(closure))));
        }
        return new Pentagon(this.intervals, (ValueEnvironment<UpperBounds>)newBounds);
    }

    public Pentagon lubAux(Pentagon other) throws SemanticException {
        HashSet<Identifier> closure;
        ValueEnvironment newBounds = (ValueEnvironment)this.upperBounds.lub(other.upperBounds);
        for (Map.Entry entry : this.upperBounds) {
            closure = new HashSet<Identifier>();
            for (Identifier bound : (UpperBounds)entry.getValue()) {
                if (((Interval)other.intervals.getState((Object)((Identifier)entry.getKey()))).interval.getHigh().compareTo(((Interval)other.intervals.getState((Object)bound)).interval.getLow()) >= 0) continue;
                closure.add(bound);
            }
            if (closure.isEmpty()) continue;
            newBounds = (ValueEnvironment)newBounds.putState((Object)((Identifier)entry.getKey()), (Lattice)((UpperBounds)((UpperBounds)newBounds.getState((Object)((Identifier)entry.getKey()))).glb((BaseLattice)new UpperBounds(closure))));
        }
        for (Map.Entry entry : other.upperBounds) {
            closure = new HashSet();
            for (Identifier bound : (UpperBounds)entry.getValue()) {
                if (((Interval)this.intervals.getState((Object)((Identifier)entry.getKey()))).interval.getHigh().compareTo(((Interval)this.intervals.getState((Object)bound)).interval.getLow()) >= 0) continue;
                closure.add(bound);
            }
            if (closure.isEmpty()) continue;
            newBounds = (ValueEnvironment)newBounds.putState((Object)((Identifier)entry.getKey()), (Lattice)((UpperBounds)((UpperBounds)newBounds.getState((Object)((Identifier)entry.getKey()))).glb((BaseLattice)new UpperBounds(closure))));
        }
        return new Pentagon((ValueEnvironment<Interval>)((ValueEnvironment)this.intervals.lub(other.intervals)), (ValueEnvironment<UpperBounds>)newBounds);
    }

    public Pentagon wideningAux(Pentagon other) throws SemanticException {
        return new Pentagon((ValueEnvironment<Interval>)((ValueEnvironment)this.intervals.widening(other.intervals)), (ValueEnvironment<UpperBounds>)((ValueEnvironment)this.upperBounds.widening(other.upperBounds)));
    }

    public boolean lessOrEqualAux(Pentagon other) throws SemanticException {
        if (!this.intervals.lessOrEqual(other.intervals)) {
            return false;
        }
        for (Map.Entry entry : other.upperBounds) {
            for (Identifier bound : (UpperBounds)entry.getValue()) {
                if (((UpperBounds)this.upperBounds.getState((Object)((Identifier)entry.getKey()))).contains(bound) || ((Interval)this.intervals.getState((Object)((Identifier)entry.getKey()))).interval.getHigh().compareTo(((Interval)this.intervals.getState((Object)bound)).interval.getLow()) < 0) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.intervals, this.upperBounds);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pentagon other = (Pentagon)obj;
        return Objects.equals(this.intervals, other.intervals) && Objects.equals(this.upperBounds, other.upperBounds);
    }

    public String toString() {
        return this.representation().toString();
    }

    public boolean knowsIdentifier(Identifier id) {
        return this.intervals.knowsIdentifier(id) || this.upperBounds.knowsIdentifier(id);
    }
}

