/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.numeric;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.nonrelational.value.BaseNonRelationalValueDomain;
import it.unive.lisa.analysis.nonrelational.value.ValueEnvironment;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.symbolic.value.operator.AdditionOperator;
import it.unive.lisa.symbolic.value.operator.DivisionOperator;
import it.unive.lisa.symbolic.value.operator.ModuloOperator;
import it.unive.lisa.symbolic.value.operator.MultiplicationOperator;
import it.unive.lisa.symbolic.value.operator.RemainderOperator;
import it.unive.lisa.symbolic.value.operator.SubtractionOperator;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonEq;
import it.unive.lisa.symbolic.value.operator.unary.NumericNegation;
import it.unive.lisa.symbolic.value.operator.unary.UnaryOperator;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;

public class Parity
implements BaseNonRelationalValueDomain<Parity> {
    public static final Parity EVEN = new Parity(3);
    public static final Parity ODD = new Parity(2);
    public static final Parity TOP = new Parity(0);
    public static final Parity BOTTOM = new Parity(1);
    private final byte parity;

    public Parity() {
        this(0);
    }

    public Parity(byte parity) {
        this.parity = parity;
    }

    public Parity top() {
        return TOP;
    }

    public Parity bottom() {
        return BOTTOM;
    }

    public StructuredRepresentation representation() {
        if (this.isBottom()) {
            return Lattice.bottomRepresentation();
        }
        if (this.isTop()) {
            return Lattice.topRepresentation();
        }
        String repr = this == EVEN ? "Even" : "Odd";
        return new StringRepresentation(repr);
    }

    public Parity evalNullConstant(ProgramPoint pp, SemanticOracle oracle) {
        return this.top();
    }

    public Parity evalNonNullConstant(Constant constant, ProgramPoint pp, SemanticOracle oracle) {
        if (constant.getValue() instanceof Integer) {
            Integer i = (Integer)constant.getValue();
            return i % 2 == 0 ? EVEN : ODD;
        }
        return this.top();
    }

    public boolean isEven() {
        return this == EVEN;
    }

    public boolean isOdd() {
        return this == ODD;
    }

    public Parity evalUnaryExpression(UnaryOperator operator, Parity arg, ProgramPoint pp, SemanticOracle oracle) {
        if (operator == NumericNegation.INSTANCE) {
            return arg;
        }
        return this.top();
    }

    public Parity evalBinaryExpression(BinaryOperator operator, Parity left, Parity right, ProgramPoint pp, SemanticOracle oracle) {
        if (left.isTop() || right.isTop()) {
            return this.top();
        }
        if (operator instanceof AdditionOperator || operator instanceof SubtractionOperator) {
            if (right.equals(left)) {
                return EVEN;
            }
            return ODD;
        }
        if (operator instanceof MultiplicationOperator) {
            if (left.isEven() || right.isEven()) {
                return EVEN;
            }
            return ODD;
        }
        if (operator instanceof DivisionOperator) {
            if (left.isOdd()) {
                return right.isOdd() ? ODD : EVEN;
            }
            return right.isOdd() ? EVEN : TOP;
        }
        if (operator instanceof ModuloOperator || operator instanceof RemainderOperator) {
            return TOP;
        }
        return TOP;
    }

    public Parity lubAux(Parity other) throws SemanticException {
        return TOP;
    }

    public boolean lessOrEqualAux(Parity other) throws SemanticException {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.parity;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Parity other = (Parity)obj;
        return this.parity == other.parity;
    }

    public ValueEnvironment<Parity> assumeBinaryExpression(ValueEnvironment<Parity> environment, BinaryOperator operator, ValueExpression left, ValueExpression right, ProgramPoint src, ProgramPoint dest, SemanticOracle oracle) throws SemanticException {
        if (operator == ComparisonEq.INSTANCE) {
            if (left instanceof Identifier) {
                Parity eval = (Parity)this.eval(right, environment, src, oracle);
                if (eval.isBottom()) {
                    return environment.bottom();
                }
                return (ValueEnvironment)environment.putState((Object)((Identifier)left), (Lattice)eval);
            }
            if (right instanceof Identifier) {
                Parity eval = (Parity)this.eval(left, environment, src, oracle);
                if (eval.isBottom()) {
                    return environment.bottom();
                }
                return (ValueEnvironment)environment.putState((Object)((Identifier)right), (Lattice)eval);
            }
        }
        return environment;
    }
}

