/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.nonRedundantSet;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.nonRedundantSet.NonRedundantPowersetOfBaseNonRelationalValueDomain;
import it.unive.lisa.analysis.nonrelational.value.ValueEnvironment;
import it.unive.lisa.analysis.numeric.Interval;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonEq;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonGe;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonGt;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonLe;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonLt;
import it.unive.lisa.util.numeric.MathNumber;
import java.util.SortedSet;
import java.util.TreeSet;

public class NonRedundantPowersetOfInterval
extends NonRedundantPowersetOfBaseNonRelationalValueDomain<NonRedundantPowersetOfInterval, Interval> {
    public NonRedundantPowersetOfInterval() {
        super(new TreeSet(), Interval.BOTTOM);
    }

    public NonRedundantPowersetOfInterval(SortedSet<Interval> elements) {
        super(elements, Interval.BOTTOM);
    }

    @Override
    protected NonRedundantPowersetOfInterval EgliMilnerConnector(NonRedundantPowersetOfInterval other) throws SemanticException {
        TreeSet<Interval> newElementsSet = new TreeSet<Interval>();
        TreeSet<Interval> notCoverSet = new TreeSet<Interval>();
        for (Interval s2 : other.elementsSet) {
            boolean existsLower = false;
            for (Interval s1 : this.elementsSet) {
                if (!s1.lessOrEqual((BaseLattice)s2)) continue;
                existsLower = true;
                break;
            }
            if (existsLower) {
                newElementsSet.add(s2);
                continue;
            }
            notCoverSet.add(s2);
        }
        for (Interval s2 : notCoverSet) {
            MathNumber middlePoint;
            MathNumber closestValue = middlePoint = this.middlePoint(s2);
            MathNumber closestDiff = closestValue.subtract(middlePoint).abs();
            Interval closest = Interval.TOP;
            for (Interval s1 : this.elementsSet) {
                if (closestValue.compareTo(middlePoint) == 0) {
                    closest = s1;
                    closestValue = this.middlePoint(s1);
                    closestDiff = closestValue.subtract(middlePoint).abs();
                    continue;
                }
                MathNumber s1Diff = this.middlePoint(s1).subtract(middlePoint).abs();
                if (s1Diff.compareTo(closestDiff) >= 0) continue;
                closest = s1;
                closestValue = this.middlePoint(s1);
                closestDiff = closestValue.subtract(middlePoint).abs();
            }
            newElementsSet.add((Interval)s2.lub((BaseLattice)closest));
        }
        return (NonRedundantPowersetOfInterval)((NonRedundantPowersetOfInterval)new NonRedundantPowersetOfInterval(newElementsSet).removeRedundancy()).removeOverlapping();
    }

    protected MathNumber middlePoint(Interval interval) {
        if (interval.interval.isFinite()) {
            return interval.interval.getLow().add(interval.interval.getHigh()).divide(new MathNumber(2L));
        }
        if (interval.interval.getHigh().isFinite() && !interval.interval.getLow().isFinite()) {
            return interval.interval.getHigh();
        }
        if (!interval.interval.getHigh().isFinite() && interval.interval.getLow().isFinite()) {
            return interval.interval.getLow().subtract(MathNumber.ONE);
        }
        return MathNumber.ZERO;
    }

    public ValueEnvironment<NonRedundantPowersetOfInterval> assumeBinaryExpression(ValueEnvironment<NonRedundantPowersetOfInterval> environment, BinaryOperator operator, ValueExpression left, ValueExpression right, ProgramPoint src, ProgramPoint dest, SemanticOracle oracle) throws SemanticException {
        boolean rightIsExpr;
        Identifier id;
        NonRedundantPowersetOfInterval eval;
        if (left instanceof Identifier) {
            eval = (NonRedundantPowersetOfInterval)this.eval(right, environment, src, oracle);
            id = (Identifier)left;
            rightIsExpr = true;
        } else if (right instanceof Identifier) {
            eval = (NonRedundantPowersetOfInterval)this.eval(left, environment, src, oracle);
            id = (Identifier)right;
            rightIsExpr = false;
        } else {
            return environment;
        }
        NonRedundantPowersetOfInterval starting = (NonRedundantPowersetOfInterval)environment.getState((Object)id);
        if (eval.isBottom() || starting.isBottom()) {
            return environment.bottom();
        }
        TreeSet<Interval> newSet = new TreeSet<Interval>();
        for (Interval startingInterval : starting.elementsSet) {
            for (Interval interval : eval.elementsSet) {
                boolean lowIsMinusInfinity = interval.interval.lowIsMinusInfinity();
                Interval low_inf = new Interval(interval.interval.getLow(), MathNumber.PLUS_INFINITY);
                Interval lowp1_inf = new Interval(interval.interval.getLow().add(MathNumber.ONE), MathNumber.PLUS_INFINITY);
                Interval inf_high = new Interval(MathNumber.MINUS_INFINITY, interval.interval.getHigh());
                Interval inf_highm1 = new Interval(MathNumber.MINUS_INFINITY, interval.interval.getHigh().subtract(MathNumber.ONE));
                if (operator == ComparisonEq.INSTANCE) {
                    newSet.add(interval);
                    continue;
                }
                if (operator == ComparisonGe.INSTANCE) {
                    if (rightIsExpr) {
                        if (lowIsMinusInfinity) {
                            newSet.add(startingInterval);
                            continue;
                        }
                        newSet.add((Interval)startingInterval.glb((BaseLattice)low_inf));
                        continue;
                    }
                    newSet.add((Interval)startingInterval.glb((BaseLattice)inf_high));
                    continue;
                }
                if (operator == ComparisonGt.INSTANCE) {
                    if (rightIsExpr) {
                        newSet.add((Interval)startingInterval.glb((BaseLattice)lowp1_inf));
                        continue;
                    }
                    newSet.add(lowIsMinusInfinity ? interval : (Interval)startingInterval.glb((BaseLattice)inf_highm1));
                    continue;
                }
                if (operator == ComparisonLe.INSTANCE) {
                    if (rightIsExpr) {
                        newSet.add((Interval)startingInterval.glb((BaseLattice)inf_high));
                        continue;
                    }
                    if (lowIsMinusInfinity) {
                        newSet.add(startingInterval);
                        continue;
                    }
                    newSet.add((Interval)startingInterval.glb((BaseLattice)low_inf));
                    continue;
                }
                if (operator == ComparisonLt.INSTANCE) {
                    if (rightIsExpr) {
                        newSet.add(lowIsMinusInfinity ? interval : (Interval)startingInterval.glb((BaseLattice)inf_highm1));
                        continue;
                    }
                    if (lowIsMinusInfinity) {
                        newSet.add(startingInterval);
                        continue;
                    }
                    newSet.add((Interval)startingInterval.glb((BaseLattice)lowp1_inf));
                    continue;
                }
                newSet.add(startingInterval);
            }
        }
        NonRedundantPowersetOfInterval intervals = (NonRedundantPowersetOfInterval)((NonRedundantPowersetOfInterval)new NonRedundantPowersetOfInterval(newSet).removeRedundancy()).removeOverlapping();
        if (intervals.isBottom()) {
            return environment.bottom();
        }
        return (ValueEnvironment)environment.putState((Object)id, (Lattice)intervals);
    }

    @Override
    protected NonRedundantPowersetOfInterval mk(SortedSet<Interval> elements) {
        return new NonRedundantPowersetOfInterval(elements);
    }
}

