/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.heap;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.heap.BaseHeapDomain;
import it.unive.lisa.analysis.heap.HeapSemanticOperation;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.ExpressionVisitor;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.heap.AccessChild;
import it.unive.lisa.symbolic.heap.HeapDereference;
import it.unive.lisa.symbolic.heap.HeapExpression;
import it.unive.lisa.symbolic.heap.HeapReference;
import it.unive.lisa.symbolic.heap.MemoryAllocation;
import it.unive.lisa.symbolic.value.HeapLocation;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.MemoryPointer;
import it.unive.lisa.type.ReferenceType;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.Untyped;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;

public class MonolithicHeap
implements BaseHeapDomain<MonolithicHeap> {
    private static final MonolithicHeap TOP = new MonolithicHeap();
    private static final MonolithicHeap BOTTOM = new MonolithicHeap();
    private static final String MONOLITH_NAME = "heap";
    private static final StructuredRepresentation REPR = new StringRepresentation("monolith");

    public ExpressionSet rewrite(SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return (ExpressionSet)expression.accept((ExpressionVisitor)Rewriter.SINGLETON, new Object[]{pp});
    }

    public List<HeapSemanticOperation.HeapReplacement> getSubstitution() {
        return Collections.emptyList();
    }

    public MonolithicHeap assign(Identifier id, SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return this;
    }

    public MonolithicHeap mk(MonolithicHeap reference) {
        return TOP;
    }

    public MonolithicHeap mk(MonolithicHeap reference, List<HeapSemanticOperation.HeapReplacement> replacements) {
        return TOP;
    }

    public MonolithicHeap semanticsOf(HeapExpression expression, ProgramPoint pp, SemanticOracle oracle) {
        return this;
    }

    public MonolithicHeap assume(SymbolicExpression expression, ProgramPoint src, ProgramPoint dest, SemanticOracle oracle) throws SemanticException {
        return this;
    }

    public Satisfiability satisfies(SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return Satisfiability.UNKNOWN;
    }

    public MonolithicHeap forgetIdentifier(Identifier id) throws SemanticException {
        return this;
    }

    public MonolithicHeap forgetIdentifiersIf(Predicate<Identifier> test) throws SemanticException {
        return this;
    }

    public MonolithicHeap lubAux(MonolithicHeap other) throws SemanticException {
        return TOP;
    }

    public MonolithicHeap glbAux(MonolithicHeap other) throws SemanticException {
        return TOP;
    }

    public boolean lessOrEqualAux(MonolithicHeap other) throws SemanticException {
        return true;
    }

    public MonolithicHeap top() {
        return TOP;
    }

    public MonolithicHeap bottom() {
        return BOTTOM;
    }

    public StructuredRepresentation representation() {
        return this.isBottom() ? Lattice.bottomRepresentation() : REPR;
    }

    public int hashCode() {
        return MonolithicHeap.class.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MonolithicHeap other = (MonolithicHeap)obj;
        return this.isTop() == other.isTop() && this.isBottom() == other.isBottom();
    }

    public boolean knowsIdentifier(Identifier id) {
        return false;
    }

    public Satisfiability alias(SymbolicExpression x, SymbolicExpression y, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return Satisfiability.UNKNOWN;
    }

    public Satisfiability isReachableFrom(SymbolicExpression x, SymbolicExpression y, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return Satisfiability.UNKNOWN;
    }

    public static class Rewriter
    extends BaseHeapDomain.Rewriter {
        public static final Rewriter SINGLETON = new Rewriter();

        public ExpressionSet visit(AccessChild expression, ExpressionSet receiver, ExpressionSet child, Object ... params) throws SemanticException {
            HashSet acc = new HashSet();
            child.forEach(e -> acc.add(e.getStaticType()));
            Type refType = Type.commonSupertype(acc, (Type)Untyped.INSTANCE);
            HeapLocation e2 = new HeapLocation(refType, MonolithicHeap.MONOLITH_NAME, true, expression.getCodeLocation());
            return new ExpressionSet((SymbolicExpression)e2);
        }

        public ExpressionSet visit(MemoryAllocation expression, Object ... params) throws SemanticException {
            HeapLocation e = new HeapLocation(expression.getStaticType(), MonolithicHeap.MONOLITH_NAME, true, expression.getCodeLocation());
            return new ExpressionSet((SymbolicExpression)e);
        }

        public ExpressionSet visit(HeapReference expression, ExpressionSet ref, Object ... params) throws SemanticException {
            HashSet acc = new HashSet();
            ref.forEach(e -> acc.add(e.getStaticType()));
            Type refType = Type.commonSupertype(acc, (Type)Untyped.INSTANCE);
            HeapLocation loc = new HeapLocation(refType, MonolithicHeap.MONOLITH_NAME, true, expression.getCodeLocation());
            MemoryPointer e2 = new MemoryPointer((Type)new ReferenceType(refType), loc, expression.getCodeLocation());
            return new ExpressionSet((SymbolicExpression)e2);
        }

        public ExpressionSet visit(HeapDereference expression, ExpressionSet deref, Object ... params) throws SemanticException {
            return deref;
        }
    }
}

