/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.combination;

import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.FunctionalLattice;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.nonrelational.Environment;
import it.unive.lisa.analysis.nonrelational.value.BaseNonRelationalValueDomain;
import it.unive.lisa.analysis.nonrelational.value.NonRelationalValueDomain;
import it.unive.lisa.analysis.nonrelational.value.ValueEnvironment;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.util.representation.ListRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Map;

public abstract class NonRelationalValueCartesianProduct<C extends NonRelationalValueCartesianProduct<C, T1, T2>, T1 extends NonRelationalValueDomain<T1>, T2 extends NonRelationalValueDomain<T2>>
implements BaseNonRelationalValueDomain<C> {
    public final T1 left;
    public final T2 right;

    public NonRelationalValueCartesianProduct(T1 left, T2 right) {
        this.left = left;
        this.right = right;
    }

    public abstract C mk(T1 var1, T2 var2);

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
        result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NonRelationalValueCartesianProduct other = (NonRelationalValueCartesianProduct)obj;
        if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
            return false;
        }
        return !(this.right == null ? other.right != null : !this.right.equals(other.right));
    }

    public StructuredRepresentation representation() {
        return new ListRepresentation(new StructuredRepresentation[]{this.left.representation(), this.right.representation()});
    }

    public C top() {
        return this.mk((NonRelationalValueDomain)this.left.top(), (NonRelationalValueDomain)this.right.top());
    }

    public boolean isTop() {
        return this.left.isTop() && this.right.isTop();
    }

    public C bottom() {
        return this.mk((NonRelationalValueDomain)this.left.bottom(), (NonRelationalValueDomain)this.right.bottom());
    }

    public boolean isBottom() {
        return this.left.isBottom() && this.right.isBottom();
    }

    public C lubAux(C other) throws SemanticException {
        return this.mk((NonRelationalValueDomain)this.left.lub(((NonRelationalValueCartesianProduct)other).left), (NonRelationalValueDomain)this.right.lub(((NonRelationalValueCartesianProduct)other).right));
    }

    public C wideningAux(C other) throws SemanticException {
        return this.mk((NonRelationalValueDomain)this.left.widening(((NonRelationalValueCartesianProduct)other).left), (NonRelationalValueDomain)this.right.widening(((NonRelationalValueCartesianProduct)other).right));
    }

    public boolean lessOrEqualAux(C other) throws SemanticException {
        return this.left.lessOrEqual(((NonRelationalValueCartesianProduct)other).left) && this.right.lessOrEqual(((NonRelationalValueCartesianProduct)other).right);
    }

    public C eval(ValueExpression expression, ValueEnvironment<C> environment, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        ValueEnvironment lenv = new ValueEnvironment(this.left);
        ValueEnvironment renv = new ValueEnvironment(this.right);
        for (Map.Entry entry : environment) {
            lenv = (ValueEnvironment)lenv.putState((Object)((Identifier)entry.getKey()), ((NonRelationalValueCartesianProduct)entry.getValue()).left);
            renv = (ValueEnvironment)renv.putState((Object)((Identifier)entry.getKey()), ((NonRelationalValueCartesianProduct)entry.getValue()).right);
        }
        return this.mk((NonRelationalValueDomain)this.left.eval((SymbolicExpression)expression, (Environment)lenv, pp, oracle), (NonRelationalValueDomain)this.right.eval((SymbolicExpression)expression, (Environment)renv, pp, oracle));
    }

    public Satisfiability satisfies(ValueExpression expression, ValueEnvironment<C> environment, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        ValueEnvironment lenv = new ValueEnvironment(this.left);
        ValueEnvironment renv = new ValueEnvironment(this.right);
        for (Map.Entry entry : environment) {
            lenv = (ValueEnvironment)lenv.putState((Object)((Identifier)entry.getKey()), ((NonRelationalValueCartesianProduct)entry.getValue()).left);
            renv = (ValueEnvironment)renv.putState((Object)((Identifier)entry.getKey()), ((NonRelationalValueCartesianProduct)entry.getValue()).right);
        }
        return this.left.satisfies((SymbolicExpression)expression, (FunctionalLattice)lenv, pp, oracle).glb(this.right.satisfies((SymbolicExpression)expression, (FunctionalLattice)renv, pp, oracle));
    }

    public ValueEnvironment<C> assume(ValueEnvironment<C> environment, ValueExpression expression, ProgramPoint src, ProgramPoint dest, SemanticOracle oracle) throws SemanticException {
        ValueEnvironment lenv = new ValueEnvironment(this.left);
        ValueEnvironment renv = new ValueEnvironment(this.right);
        for (Map.Entry entry : environment) {
            lenv = (ValueEnvironment)lenv.putState((Object)((Identifier)entry.getKey()), ((NonRelationalValueCartesianProduct)entry.getValue()).left);
            renv = (ValueEnvironment)renv.putState((Object)((Identifier)entry.getKey()), ((NonRelationalValueCartesianProduct)entry.getValue()).right);
        }
        ValueEnvironment lassume = (ValueEnvironment)this.left.assume((FunctionalLattice)lenv, (SymbolicExpression)expression, src, dest, oracle);
        ValueEnvironment rassume = (ValueEnvironment)this.right.assume((FunctionalLattice)renv, (SymbolicExpression)expression, src, dest, oracle);
        ValueEnvironment res = new ValueEnvironment((NonRelationalValueDomain)this);
        for (Map.Entry entry : lassume) {
            res = (ValueEnvironment)res.putState((Object)((Identifier)entry.getKey()), this.mk((NonRelationalValueDomain)entry.getValue(), (NonRelationalValueDomain)rassume.getState((Object)((Identifier)entry.getKey()))));
        }
        for (Map.Entry entry : rassume) {
            if (res.getKeys().contains(entry.getKey())) continue;
            res = (ValueEnvironment)res.putState((Object)((Identifier)entry.getKey()), this.mk((NonRelationalValueDomain)this.left.bottom(), (NonRelationalValueDomain)entry.getValue()));
        }
        return res;
    }

    public C glb(C other) throws SemanticException {
        return this.mk((NonRelationalValueDomain)this.left.glb(((NonRelationalValueCartesianProduct)other).left), (NonRelationalValueDomain)this.right.glb(((NonRelationalValueCartesianProduct)other).right));
    }

    public C fixedVariable(Identifier id, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return this.mk((NonRelationalValueDomain)this.left.fixedVariable(id, pp, oracle), (NonRelationalValueDomain)this.right.fixedVariable(id, pp, oracle));
    }

    public boolean canProcess(SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) {
        return this.left.canProcess(expression, pp, oracle) || this.right.canProcess(expression, pp, oracle);
    }
}

