/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.combination;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.nonrelational.Environment;
import it.unive.lisa.analysis.nonrelational.NonRelationalDomain;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.util.representation.ListRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Collection;
import java.util.function.Predicate;

public abstract class CartesianProduct<C extends CartesianProduct<C, T1, T2, E, I>, T1 extends SemanticDomain<T1, E, I> & Lattice<T1>, T2 extends SemanticDomain<T2, E, I> & Lattice<T2>, E extends SymbolicExpression, I extends Identifier>
implements SemanticDomain<C, E, I>,
Lattice<C> {
    public final T1 left;
    public final T2 right;

    public CartesianProduct(T1 left, T2 right) {
        this.left = left;
        this.right = right;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
        result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CartesianProduct other = (CartesianProduct)obj;
        if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
            return false;
        }
        return !(this.right == null ? other.right != null : !this.right.equals(other.right));
    }

    public String toString() {
        if (this.left instanceof Environment && this.right instanceof Environment) {
            Environment leftEnv = (Environment)this.left;
            Environment rightEnv = (Environment)this.right;
            if (!leftEnv.isTop() && !leftEnv.isBottom()) {
                StringBuilder result = new StringBuilder();
                for (Identifier x : leftEnv.getKeys()) {
                    result.append(x).append(": (").append(((NonRelationalDomain)leftEnv.getState((Object)x)).representation()).append(", ").append(((NonRelationalDomain)rightEnv.getState((Object)x)).representation()).append(")\n");
                }
                return result.toString();
            }
            if (!rightEnv.isTop() && !rightEnv.isBottom()) {
                StringBuilder result = new StringBuilder();
                for (Identifier x : rightEnv.getKeys()) {
                    result.append(x).append(": (").append(((NonRelationalDomain)leftEnv.getState((Object)x)).representation()).append(", ").append(((NonRelationalDomain)rightEnv.getState((Object)x)).representation()).append(")\n");
                }
                return result.toString();
            }
        }
        return "(" + this.left.representation() + ", " + this.right.representation() + ")";
    }

    public abstract C mk(T1 var1, T2 var2);

    public StructuredRepresentation representation() {
        return new ListRepresentation(new StructuredRepresentation[]{this.left.representation(), this.right.representation()});
    }

    public C assign(I id, E expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        SemanticDomain newLeft = this.left.assign(id, expression, pp, oracle);
        SemanticDomain newRight = this.right.assign(id, expression, pp, oracle);
        return this.mk(newLeft, newRight);
    }

    public C smallStepSemantics(E expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        SemanticDomain newLeft = this.left.smallStepSemantics(expression, pp, oracle);
        SemanticDomain newRight = this.right.smallStepSemantics(expression, pp, oracle);
        return this.mk(newLeft, newRight);
    }

    public C assume(E expression, ProgramPoint src, ProgramPoint dest, SemanticOracle oracle) throws SemanticException {
        SemanticDomain newLeft = this.left.assume(expression, src, dest, oracle);
        SemanticDomain newRight = this.right.assume(expression, src, dest, oracle);
        return this.mk(newLeft, newRight);
    }

    public C forgetIdentifier(Identifier id) throws SemanticException {
        SemanticDomain newLeft = this.left.forgetIdentifier(id);
        SemanticDomain newRight = this.right.forgetIdentifier(id);
        return this.mk(newLeft, newRight);
    }

    public C forgetIdentifiersIf(Predicate<Identifier> test) throws SemanticException {
        SemanticDomain newLeft = this.left.forgetIdentifiersIf(test);
        SemanticDomain newRight = this.right.forgetIdentifiersIf(test);
        return this.mk(newLeft, newRight);
    }

    public C pushScope(ScopeToken scope) throws SemanticException {
        SemanticDomain newLeft = (SemanticDomain)this.left.pushScope(scope);
        SemanticDomain newRight = (SemanticDomain)this.right.pushScope(scope);
        return this.mk(newLeft, newRight);
    }

    public C popScope(ScopeToken scope) throws SemanticException {
        SemanticDomain newLeft = (SemanticDomain)this.left.popScope(scope);
        SemanticDomain newRight = (SemanticDomain)this.right.popScope(scope);
        return this.mk(newLeft, newRight);
    }

    public Satisfiability satisfies(E expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return this.left.satisfies(expression, pp, oracle).and(this.right.satisfies(expression, pp, oracle));
    }

    public C lub(C other) throws SemanticException {
        return this.mk((SemanticDomain)((Lattice)this.left).lub(((CartesianProduct)other).left), (SemanticDomain)((Lattice)this.right).lub(((CartesianProduct)other).right));
    }

    public C widening(C other) throws SemanticException {
        return this.mk((SemanticDomain)((Lattice)this.left).widening(((CartesianProduct)other).left), (SemanticDomain)((Lattice)this.right).widening(((CartesianProduct)other).right));
    }

    public boolean lessOrEqual(C other) throws SemanticException {
        return ((Lattice)this.left).lessOrEqual(((CartesianProduct)other).left) && ((Lattice)this.right).lessOrEqual(((CartesianProduct)other).right);
    }

    public C top() {
        return this.mk((SemanticDomain)((Lattice)this.left).top(), (SemanticDomain)((Lattice)this.right).top());
    }

    public boolean isTop() {
        return ((Lattice)this.left).isTop() && ((Lattice)this.right).isTop();
    }

    public C bottom() {
        return this.mk((SemanticDomain)((Lattice)this.left).bottom(), (SemanticDomain)((Lattice)this.right).bottom());
    }

    public boolean isBottom() {
        return ((Lattice)this.left).isBottom() && ((Lattice)this.right).isBottom();
    }

    public <T extends SemanticDomain<?, ?, ?>> Collection<T> getAllDomainInstances(Class<T> domain) {
        Collection result = super.getAllDomainInstances(domain);
        result.addAll(this.left.getAllDomainInstances(domain));
        result.addAll(this.right.getAllDomainInstances(domain));
        return result;
    }
}

