/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.heap.HeapSemanticOperation;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.type.TypeDomain;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.heap.MemoryAllocation;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.representation.ObjectRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class SimpleAbstractState<H extends HeapDomain<H>, V extends ValueDomain<V>, T extends TypeDomain<T>>
implements BaseLattice<SimpleAbstractState<H, V, T>>,
AbstractState<SimpleAbstractState<H, V, T>> {
    public static final String HEAP_REPRESENTATION_KEY = "heap";
    public static final String TYPE_REPRESENTATION_KEY = "type";
    public static final String VALUE_REPRESENTATION_KEY = "value";
    private final H heapState;
    private final V valueState;
    private final T typeState;

    public SimpleAbstractState(H heapState, V valueState, T typeState) {
        this.heapState = heapState;
        this.valueState = valueState;
        this.typeState = typeState;
    }

    public H getHeapState() {
        return this.heapState;
    }

    public V getValueState() {
        return this.valueState;
    }

    public T getTypeState() {
        return this.typeState;
    }

    public SimpleAbstractState<H, V, T> assign(Identifier id, SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (!expression.mightNeedRewriting()) {
            ValueExpression ve = (ValueExpression)expression;
            return new SimpleAbstractState<HeapDomain, ValueDomain, TypeDomain>((HeapDomain)this.heapState.assign(id, expression, pp, (SemanticOracle)this), (ValueDomain)this.valueState.assign(id, (SymbolicExpression)ve, pp, (SemanticOracle)this), (TypeDomain)this.typeState.assign(id, (SymbolicExpression)ve, pp, (SemanticOracle)this));
        }
        MutableOracle<H, V, T> mo = new MutableOracle<H, V, T>(this.heapState, this.valueState, this.typeState);
        mo.heap = (HeapDomain)mo.heap.assign(id, expression, pp, mo);
        ExpressionSet exprs = mo.heap.rewrite(expression, pp, mo);
        if (exprs.isEmpty()) {
            return this.bottom();
        }
        SimpleAbstractState.applySubstitution(mo, pp);
        if (exprs.elements.size() == 1) {
            SymbolicExpression expr = (SymbolicExpression)exprs.elements.iterator().next();
            if (!(expr instanceof ValueExpression)) {
                throw new SemanticException("Rewriting failed for expression " + expr);
            }
            ValueExpression ve = (ValueExpression)expr;
            TypeDomain t = (TypeDomain)mo.type.assign(id, (SymbolicExpression)ve, pp, mo);
            ValueDomain v = (ValueDomain)mo.value.assign(id, (SymbolicExpression)ve, pp, mo);
            return new SimpleAbstractState(mo.heap, v, t);
        }
        TypeDomain typeRes = (TypeDomain)mo.type.bottom();
        ValueDomain valueRes = (ValueDomain)mo.value.bottom();
        for (SymbolicExpression expr : exprs) {
            if (!(expr instanceof ValueExpression)) {
                throw new SemanticException("Rewriting failed for expression " + expr);
            }
            ValueExpression ve = (ValueExpression)expr;
            TypeDomain t = (TypeDomain)mo.type.assign(id, (SymbolicExpression)ve, pp, mo);
            ValueDomain v = (ValueDomain)mo.value.assign(id, (SymbolicExpression)ve, pp, mo);
            typeRes = (TypeDomain)typeRes.lub((Lattice)t);
            valueRes = (ValueDomain)valueRes.lub((Lattice)v);
        }
        return new SimpleAbstractState(mo.heap, valueRes, typeRes);
    }

    public SimpleAbstractState<H, V, T> smallStepSemantics(SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (!expression.mightNeedRewriting()) {
            ValueExpression ve = (ValueExpression)expression;
            return new SimpleAbstractState<HeapDomain, ValueDomain, TypeDomain>((HeapDomain)this.heapState.smallStepSemantics(expression, pp, (SemanticOracle)this), (ValueDomain)this.valueState.smallStepSemantics((SymbolicExpression)ve, pp, (SemanticOracle)this), (TypeDomain)this.typeState.smallStepSemantics((SymbolicExpression)ve, pp, (SemanticOracle)this));
        }
        MutableOracle<H, V, T> mo = new MutableOracle<H, V, T>(this.heapState, this.valueState, this.typeState);
        mo.heap = (HeapDomain)mo.heap.smallStepSemantics(expression, pp, mo);
        ExpressionSet exprs = mo.heap.rewrite(expression, pp, mo);
        if (exprs.isEmpty()) {
            return this.bottom();
        }
        SimpleAbstractState.applySubstitution(mo, pp);
        if (exprs.elements.size() == 1) {
            SymbolicExpression expr = (SymbolicExpression)exprs.elements.iterator().next();
            if (!(expr instanceof ValueExpression)) {
                throw new SemanticException("Rewriting failed for expression " + expr);
            }
            ValueExpression ve = (ValueExpression)expr;
            TypeDomain t = (TypeDomain)mo.type.smallStepSemantics((SymbolicExpression)ve, pp, mo);
            if (expression instanceof MemoryAllocation && expr instanceof Identifier) {
                t = (TypeDomain)t.assign((Identifier)ve, (SymbolicExpression)ve, pp, mo);
            }
            ValueDomain v = (ValueDomain)mo.value.smallStepSemantics((SymbolicExpression)ve, pp, mo);
            return new SimpleAbstractState(mo.heap, v, t);
        }
        TypeDomain typeRes = (TypeDomain)mo.type.bottom();
        ValueDomain valueRes = (ValueDomain)mo.value.bottom();
        for (SymbolicExpression expr : exprs) {
            if (!(expr instanceof ValueExpression)) {
                throw new SemanticException("Rewriting failed for expression " + expr);
            }
            ValueExpression ve = (ValueExpression)expr;
            TypeDomain t = (TypeDomain)mo.type.smallStepSemantics((SymbolicExpression)ve, pp, mo);
            if (expression instanceof MemoryAllocation && expr instanceof Identifier) {
                t = (TypeDomain)t.assign((Identifier)ve, (SymbolicExpression)ve, pp, mo);
            }
            ValueDomain v = (ValueDomain)mo.value.smallStepSemantics((SymbolicExpression)ve, pp, mo);
            typeRes = (TypeDomain)typeRes.lub((Lattice)t);
            valueRes = (ValueDomain)valueRes.lub((Lattice)v);
        }
        return new SimpleAbstractState(mo.heap, valueRes, typeRes);
    }

    private static <H extends HeapDomain<H>, V extends ValueDomain<V>, T extends TypeDomain<T>> void applySubstitution(MutableOracle<H, V, T> mo, ProgramPoint pp) throws SemanticException {
        List subs = mo.heap.getSubstitution();
        if (subs != null) {
            for (HeapSemanticOperation.HeapReplacement repl : subs) {
                TypeDomain t = mo.type.applyReplacement(repl, pp, mo);
                ValueDomain v = mo.value.applyReplacement(repl, pp, mo);
                mo.type = t;
                mo.value = v;
            }
        }
    }

    public SimpleAbstractState<H, V, T> assume(SymbolicExpression expression, ProgramPoint src, ProgramPoint dest, SemanticOracle oracle) throws SemanticException {
        if (!expression.mightNeedRewriting()) {
            ValueExpression ve = (ValueExpression)expression;
            HeapDomain h = (HeapDomain)this.heapState.assume(expression, src, dest, (SemanticOracle)this);
            if (h.isBottom()) {
                return this.bottom();
            }
            TypeDomain t = (TypeDomain)this.typeState.assume((SymbolicExpression)ve, src, dest, (SemanticOracle)this);
            if (t.isBottom()) {
                return this.bottom();
            }
            ValueDomain v = (ValueDomain)this.valueState.assume((SymbolicExpression)ve, src, dest, (SemanticOracle)this);
            if (v.isBottom()) {
                return this.bottom();
            }
            return new SimpleAbstractState<HeapDomain, ValueDomain, TypeDomain>(h, v, t);
        }
        MutableOracle<H, V, T> mo = new MutableOracle<H, V, T>(this.heapState, this.valueState, this.typeState);
        mo.heap = (HeapDomain)mo.heap.assume(expression, src, dest, mo);
        if (mo.heap.isBottom()) {
            return this.bottom();
        }
        ExpressionSet exprs = mo.heap.rewrite(expression, src, mo);
        if (exprs.isEmpty()) {
            return this.bottom();
        }
        SimpleAbstractState.applySubstitution(mo, src);
        if (exprs.elements.size() == 1) {
            SymbolicExpression expr = (SymbolicExpression)exprs.elements.iterator().next();
            if (!(expr instanceof ValueExpression)) {
                throw new SemanticException("Rewriting failed for expression " + expr);
            }
            ValueExpression ve = (ValueExpression)expr;
            TypeDomain t = (TypeDomain)mo.type.assume((SymbolicExpression)ve, src, dest, mo);
            if (t.isBottom()) {
                return this.bottom();
            }
            ValueDomain v = (ValueDomain)mo.value.assume((SymbolicExpression)ve, src, dest, mo);
            if (v.isBottom()) {
                return this.bottom();
            }
            return new SimpleAbstractState(mo.heap, v, t);
        }
        TypeDomain typeRes = (TypeDomain)mo.type.bottom();
        ValueDomain valueRes = (ValueDomain)mo.value.bottom();
        for (SymbolicExpression expr : exprs) {
            if (!(expr instanceof ValueExpression)) {
                throw new SemanticException("Rewriting failed for expression " + expr);
            }
            ValueExpression ve = (ValueExpression)expr;
            TypeDomain t = (TypeDomain)mo.type.assume((SymbolicExpression)ve, src, dest, mo);
            ValueDomain v = (ValueDomain)mo.value.assume((SymbolicExpression)ve, src, dest, mo);
            typeRes = (TypeDomain)typeRes.lub((Lattice)t);
            valueRes = (ValueDomain)valueRes.lub((Lattice)v);
        }
        if (typeRes.isBottom() || valueRes.isBottom()) {
            return this.bottom();
        }
        return new SimpleAbstractState(mo.heap, valueRes, typeRes);
    }

    public Satisfiability satisfies(SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        Satisfiability heapsat = this.heapState.satisfies(expression, pp, (SemanticOracle)this);
        if (heapsat == Satisfiability.BOTTOM) {
            return Satisfiability.BOTTOM;
        }
        if (!expression.mightNeedRewriting()) {
            ValueExpression ve = (ValueExpression)expression;
            Satisfiability typesat = this.typeState.satisfies((SymbolicExpression)ve, pp, (SemanticOracle)this);
            if (typesat == Satisfiability.BOTTOM) {
                return Satisfiability.BOTTOM;
            }
            Satisfiability valuesat = this.valueState.satisfies((SymbolicExpression)ve, pp, (SemanticOracle)this);
            if (valuesat == Satisfiability.BOTTOM) {
                return Satisfiability.BOTTOM;
            }
            return heapsat.glb(typesat).glb(valuesat);
        }
        ExpressionSet exprs = this.heapState.rewrite(expression, pp, (SemanticOracle)this);
        if (exprs.isEmpty()) {
            return Satisfiability.BOTTOM;
        }
        if (exprs.elements.size() == 1) {
            SymbolicExpression expr = (SymbolicExpression)exprs.elements.iterator().next();
            if (!(expr instanceof ValueExpression)) {
                throw new SemanticException("Rewriting failed for expression " + expr);
            }
            ValueExpression ve = (ValueExpression)expression;
            Satisfiability typesat = this.typeState.satisfies((SymbolicExpression)ve, pp, (SemanticOracle)this);
            if (typesat == Satisfiability.BOTTOM) {
                return Satisfiability.BOTTOM;
            }
            Satisfiability valuesat = this.valueState.satisfies((SymbolicExpression)ve, pp, (SemanticOracle)this);
            if (valuesat == Satisfiability.BOTTOM) {
                return Satisfiability.BOTTOM;
            }
            return heapsat.glb(typesat).glb(valuesat);
        }
        Satisfiability typesat = Satisfiability.BOTTOM;
        Satisfiability valuesat = Satisfiability.BOTTOM;
        for (SymbolicExpression expr : exprs) {
            if (!(expr instanceof ValueExpression)) {
                throw new SemanticException("Rewriting failed for expression " + expr);
            }
            ValueExpression ve = (ValueExpression)expr;
            Satisfiability sat = this.typeState.satisfies((SymbolicExpression)ve, pp, (SemanticOracle)this);
            if (sat == Satisfiability.BOTTOM) {
                return sat;
            }
            typesat = (Satisfiability)typesat.lub((Lattice)sat);
            sat = this.valueState.satisfies((SymbolicExpression)ve, pp, (SemanticOracle)this);
            if (sat == Satisfiability.BOTTOM) {
                return sat;
            }
            valuesat = (Satisfiability)valuesat.lub((Lattice)sat);
        }
        return heapsat.glb(typesat).glb(valuesat);
    }

    public SimpleAbstractState<H, V, T> pushScope(ScopeToken scope) throws SemanticException {
        return new SimpleAbstractState<HeapDomain, ValueDomain, TypeDomain>((HeapDomain)this.heapState.pushScope(scope), (ValueDomain)this.valueState.pushScope(scope), (TypeDomain)this.typeState.pushScope(scope));
    }

    public SimpleAbstractState<H, V, T> popScope(ScopeToken scope) throws SemanticException {
        return new SimpleAbstractState<HeapDomain, ValueDomain, TypeDomain>((HeapDomain)this.heapState.popScope(scope), (ValueDomain)this.valueState.popScope(scope), (TypeDomain)this.typeState.popScope(scope));
    }

    public SimpleAbstractState<H, V, T> lubAux(SimpleAbstractState<H, V, T> other) throws SemanticException {
        return new SimpleAbstractState<HeapDomain, ValueDomain, TypeDomain>((HeapDomain)this.heapState.lub(other.heapState), (ValueDomain)this.valueState.lub(other.valueState), (TypeDomain)this.typeState.lub(other.typeState));
    }

    public SimpleAbstractState<H, V, T> glbAux(SimpleAbstractState<H, V, T> other) throws SemanticException {
        return new SimpleAbstractState<HeapDomain, ValueDomain, TypeDomain>((HeapDomain)this.heapState.glb(other.heapState), (ValueDomain)this.valueState.glb(other.valueState), (TypeDomain)this.typeState.glb(other.typeState));
    }

    public SimpleAbstractState<H, V, T> wideningAux(SimpleAbstractState<H, V, T> other) throws SemanticException {
        return new SimpleAbstractState<HeapDomain, ValueDomain, TypeDomain>((HeapDomain)this.heapState.widening(other.heapState), (ValueDomain)this.valueState.widening(other.valueState), (TypeDomain)this.typeState.widening(other.typeState));
    }

    public SimpleAbstractState<H, V, T> narrowingAux(SimpleAbstractState<H, V, T> other) throws SemanticException {
        return new SimpleAbstractState<HeapDomain, ValueDomain, TypeDomain>((HeapDomain)this.heapState.narrowing(other.heapState), (ValueDomain)this.valueState.narrowing(other.valueState), (TypeDomain)this.typeState.narrowing(other.typeState));
    }

    public boolean lessOrEqualAux(SimpleAbstractState<H, V, T> other) throws SemanticException {
        return this.heapState.lessOrEqual(other.heapState) && this.valueState.lessOrEqual(other.valueState) && this.typeState.lessOrEqual(other.typeState);
    }

    public SimpleAbstractState<H, V, T> top() {
        return new SimpleAbstractState<HeapDomain, ValueDomain, TypeDomain>((HeapDomain)this.heapState.top(), (ValueDomain)this.valueState.top(), (TypeDomain)this.typeState.top());
    }

    public SimpleAbstractState<H, V, T> bottom() {
        return new SimpleAbstractState<HeapDomain, ValueDomain, TypeDomain>((HeapDomain)this.heapState.bottom(), (ValueDomain)this.valueState.bottom(), (TypeDomain)this.typeState.bottom());
    }

    public boolean isTop() {
        return this.heapState.isTop() && this.valueState.isTop() && this.typeState.isTop();
    }

    public boolean isBottom() {
        return this.heapState.isBottom() && this.valueState.isBottom() && this.typeState.isBottom();
    }

    public SimpleAbstractState<H, V, T> forgetIdentifier(Identifier id) throws SemanticException {
        return new SimpleAbstractState<HeapDomain, ValueDomain, TypeDomain>((HeapDomain)this.heapState.forgetIdentifier(id), (ValueDomain)this.valueState.forgetIdentifier(id), (TypeDomain)this.typeState.forgetIdentifier(id));
    }

    public SimpleAbstractState<H, V, T> forgetIdentifiersIf(Predicate<Identifier> test) throws SemanticException {
        return new SimpleAbstractState<HeapDomain, ValueDomain, TypeDomain>((HeapDomain)this.heapState.forgetIdentifiersIf(test), (ValueDomain)this.valueState.forgetIdentifiersIf(test), (TypeDomain)this.typeState.forgetIdentifiersIf(test));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.heapState == null ? 0 : this.heapState.hashCode());
        result = 31 * result + (this.valueState == null ? 0 : this.valueState.hashCode());
        result = 31 * result + (this.typeState == null ? 0 : this.typeState.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleAbstractState other = (SimpleAbstractState)obj;
        if (this.heapState == null ? other.heapState != null : !this.heapState.equals(other.heapState)) {
            return false;
        }
        if (this.valueState == null ? other.valueState != null : !this.valueState.equals(other.valueState)) {
            return false;
        }
        return !(this.typeState == null ? other.typeState != null : !this.typeState.equals(other.typeState));
    }

    public StructuredRepresentation representation() {
        if (this.isBottom()) {
            return Lattice.bottomRepresentation();
        }
        if (this.isTop()) {
            return Lattice.topRepresentation();
        }
        StructuredRepresentation h = this.heapState.representation();
        StructuredRepresentation t = this.typeState.representation();
        StructuredRepresentation v = this.valueState.representation();
        return new ObjectRepresentation(Map.of(HEAP_REPRESENTATION_KEY, h, TYPE_REPRESENTATION_KEY, t, VALUE_REPRESENTATION_KEY, v));
    }

    public String toString() {
        return this.representation().toString();
    }

    public <D extends SemanticDomain<?, ?, ?>> Collection<D> getAllDomainInstances(Class<D> domain) {
        Collection result = super.getAllDomainInstances(domain);
        result.addAll(this.heapState.getAllDomainInstances(domain));
        result.addAll(this.typeState.getAllDomainInstances(domain));
        result.addAll(this.valueState.getAllDomainInstances(domain));
        return result;
    }

    public ExpressionSet rewrite(SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (!expression.mightNeedRewriting()) {
            return new ExpressionSet(expression);
        }
        return this.heapState.rewrite(expression, pp, oracle);
    }

    public ExpressionSet rewrite(ExpressionSet expressions, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return this.heapState.rewrite(expressions, pp, oracle);
    }

    public Set<Type> getRuntimeTypesOf(SymbolicExpression e, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return this.typeState.getRuntimeTypesOf(e, pp, oracle);
    }

    public Type getDynamicTypeOf(SymbolicExpression e, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return this.typeState.getDynamicTypeOf(e, pp, oracle);
    }

    public boolean knowsIdentifier(Identifier id) {
        return this.heapState.knowsIdentifier(id) || this.valueState.knowsIdentifier(id) || this.typeState.knowsIdentifier(id);
    }

    public SimpleAbstractState<H, V, T> withTopMemory() {
        return new SimpleAbstractState<HeapDomain, V, T>((HeapDomain)this.heapState.top(), this.valueState, this.typeState);
    }

    public SimpleAbstractState<H, V, T> withTopValues() {
        return new SimpleAbstractState<H, ValueDomain, T>(this.heapState, (ValueDomain)this.valueState.top(), this.typeState);
    }

    public SimpleAbstractState<H, V, T> withTopTypes() {
        return new SimpleAbstractState<H, V, TypeDomain>(this.heapState, this.valueState, (TypeDomain)this.typeState.top());
    }

    public Satisfiability alias(SymbolicExpression x, SymbolicExpression y, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return this.heapState.alias(x, y, pp, oracle);
    }

    public Satisfiability isReachableFrom(SymbolicExpression x, SymbolicExpression y, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return this.heapState.isReachableFrom(x, y, pp, oracle);
    }

    private static class MutableOracle<H extends HeapDomain<H>, V extends ValueDomain<V>, T extends TypeDomain<T>>
    implements SemanticOracle {
        private H heap;
        private V value;
        private T type;

        public MutableOracle(H heap, V value, T type) {
            this.heap = heap;
            this.value = value;
            this.type = type;
        }

        public ExpressionSet rewrite(SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
            if (!expression.mightNeedRewriting()) {
                return new ExpressionSet(expression);
            }
            return this.heap.rewrite(expression, pp, (SemanticOracle)this);
        }

        public Set<Type> getRuntimeTypesOf(SymbolicExpression e, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
            return this.type.getRuntimeTypesOf(e, pp, (SemanticOracle)this);
        }

        public Type getDynamicTypeOf(SymbolicExpression e, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
            return this.type.getDynamicTypeOf(e, pp, (SemanticOracle)this);
        }

        public String toString() {
            if (this.heap.isBottom() || this.type.isBottom() || this.value.isBottom()) {
                return Lattice.bottomRepresentation().toString();
            }
            if (this.heap.isTop() && this.type.isTop() && this.value.isTop()) {
                return Lattice.topRepresentation().toString();
            }
            StructuredRepresentation h = this.heap.representation();
            StructuredRepresentation t = this.type.representation();
            StructuredRepresentation v = this.value.representation();
            return new ObjectRepresentation(Map.of(SimpleAbstractState.HEAP_REPRESENTATION_KEY, h, SimpleAbstractState.TYPE_REPRESENTATION_KEY, t, SimpleAbstractState.VALUE_REPRESENTATION_KEY, v)).toString();
        }

        public Satisfiability alias(SymbolicExpression x, SymbolicExpression y, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
            return this.heap.alias(x, y, pp, oracle);
        }

        public Satisfiability isReachableFrom(SymbolicExpression x, SymbolicExpression y, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
            return this.heap.isReachableFrom(x, y, pp, oracle);
        }
    }
}

