/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa;

import it.unive.lisa.AnalysisSetupException;
import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.dataflow.DataflowElement;
import it.unive.lisa.analysis.dataflow.DefiniteDataflowDomain;
import it.unive.lisa.analysis.dataflow.PossibleDataflowDomain;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.nonrelational.heap.HeapEnvironment;
import it.unive.lisa.analysis.nonrelational.heap.NonRelationalHeapDomain;
import it.unive.lisa.analysis.nonrelational.inference.InferenceSystem;
import it.unive.lisa.analysis.nonrelational.inference.InferredValue;
import it.unive.lisa.analysis.nonrelational.value.NonRelationalTypeDomain;
import it.unive.lisa.analysis.nonrelational.value.NonRelationalValueDomain;
import it.unive.lisa.analysis.nonrelational.value.TypeEnvironment;
import it.unive.lisa.analysis.nonrelational.value.ValueEnvironment;
import it.unive.lisa.analysis.type.TypeDomain;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.interprocedural.callgraph.CallGraph;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;

public final class LiSAFactory {
    private LiSAFactory() {
    }

    private static <T> T construct(Class<T> component, Class<?>[] argTypes, Object[] params) throws AnalysisSetupException {
        if (argTypes.length == 0) {
            try {
                Method method = component.getMethod("getSingleton", new Class[0]);
                if (method != null && Modifier.isStatic(method.getModifiers())) {
                    return (T)method.invoke(null, new Object[0]);
                }
            }
            catch (NoSuchMethodException method) {
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                throw new AnalysisSetupException("Unable to instantiate " + component.getSimpleName(), (Throwable)e);
            }
        }
        try {
            Constructor<T> constructor = component.getConstructor(argTypes);
            return constructor.newInstance(params);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new AnalysisSetupException("Unable to instantiate " + component.getSimpleName(), (Throwable)e);
        }
    }

    private static Class<?>[] findConstructorSignature(Class<?> component, Object[] params) throws AnalysisSetupException {
        IdentityHashMap candidates = new IdentityHashMap();
        block0: for (Constructor<?> constructor : component.getConstructors()) {
            Class<?>[] types = constructor.getParameterTypes();
            if (params.length != types.length) continue;
            ArrayList<Integer> toWrap = new ArrayList<Integer>();
            for (int i = 0; i < types.length; ++i) {
                if (LiSAFactory.needsWrapping(params[i].getClass(), types[i])) {
                    toWrap.add(i);
                    continue;
                }
                if (!types[i].isAssignableFrom(params[i].getClass())) continue block0;
            }
            candidates.put(constructor, toWrap);
        }
        if (candidates.isEmpty()) {
            throw new AnalysisSetupException("No suitable constructor of " + component.getSimpleName() + " found for argument types " + Arrays.toString(Arrays.stream(params).map(Object::getClass).toArray(Class[]::new)));
        }
        if (candidates.size() > 1) {
            throw new AnalysisSetupException("Constructor call of " + component.getSimpleName() + " is ambiguous for argument types " + Arrays.toString(Arrays.stream(params).map(Object::getClass).toArray(Class[]::new)));
        }
        Iterator iterator = ((List)candidates.values().iterator().next()).iterator();
        while (iterator.hasNext()) {
            int p = (Integer)iterator.next();
            params[p] = LiSAFactory.wrapParam(params[p]);
        }
        return ((Constructor)candidates.keySet().iterator().next()).getParameterTypes();
    }

    private static boolean needsWrapping(Class<?> actual, Class<?> desired) {
        if (NonRelationalHeapDomain.class.isAssignableFrom(actual) && desired.isAssignableFrom(HeapDomain.class)) {
            return true;
        }
        if (NonRelationalValueDomain.class.isAssignableFrom(actual) && desired.isAssignableFrom(ValueDomain.class)) {
            return true;
        }
        if (NonRelationalTypeDomain.class.isAssignableFrom(actual) && desired.isAssignableFrom(TypeDomain.class)) {
            return true;
        }
        if (InferredValue.class.isAssignableFrom(actual) && desired.isAssignableFrom(ValueDomain.class)) {
            return true;
        }
        return DataflowElement.class.isAssignableFrom(actual) && desired.isAssignableFrom(ValueDomain.class);
    }

    private static Object wrapParam(Object param) {
        if (NonRelationalHeapDomain.class.isAssignableFrom(param.getClass())) {
            return new HeapEnvironment((NonRelationalHeapDomain)param);
        }
        if (NonRelationalValueDomain.class.isAssignableFrom(param.getClass())) {
            return new ValueEnvironment((NonRelationalValueDomain)param);
        }
        if (NonRelationalTypeDomain.class.isAssignableFrom(param.getClass())) {
            return new TypeEnvironment((NonRelationalTypeDomain)param);
        }
        if (InferredValue.class.isAssignableFrom(param.getClass())) {
            return new InferenceSystem((InferredValue)param);
        }
        if (DataflowElement.class.isAssignableFrom(param.getClass())) {
            Class<?> elem = param.getClass();
            if (elem.getGenericInterfaces().length == 0) {
                return param;
            }
            for (Type gi : elem.getGenericInterfaces()) {
                if (!(gi instanceof ParameterizedType) || ((ParameterizedType)gi).getRawType() != DataflowElement.class) continue;
                Type domain = ((ParameterizedType)gi).getActualTypeArguments()[0];
                if (((ParameterizedType)domain).getRawType() == PossibleDataflowDomain.class) {
                    return new PossibleDataflowDomain((DataflowElement)param);
                }
                if (((ParameterizedType)domain).getRawType() == DefiniteDataflowDomain.class) {
                    return new DefiniteDataflowDomain((DataflowElement)param);
                }
                return param;
            }
        }
        return param;
    }

    public static <T> T getInstance(Class<T> component, Object ... params) throws AnalysisSetupException {
        try {
            if (params != null && params.length != 0) {
                return LiSAFactory.construct(component, LiSAFactory.findConstructorSignature(component, params), params);
            }
            return LiSAFactory.construct(component, ArrayUtils.EMPTY_CLASS_ARRAY, ArrayUtils.EMPTY_OBJECT_ARRAY);
        }
        catch (NullPointerException e) {
            throw new AnalysisSetupException("Unable to instantiate default " + component.getSimpleName(), (Throwable)e);
        }
    }

    public static Collection<ConfigurableComponent> configurableComponents() {
        ArrayList<ConfigurableComponent> in = new ArrayList<ConfigurableComponent>();
        in.add(new ConfigurableComponent(InterproceduralAnalysis.class));
        in.add(new ConfigurableComponent(CallGraph.class));
        in.add(new ConfigurableComponent(AbstractState.class));
        in.add(new ConfigurableComponent(HeapDomain.class));
        in.add(new ConfigurableComponent(ValueDomain.class));
        in.add(new ConfigurableComponent(TypeDomain.class));
        in.add(new ConfigurableComponent(NonRelationalHeapDomain.class));
        in.add(new ConfigurableComponent(NonRelationalValueDomain.class));
        in.add(new ConfigurableComponent(NonRelationalTypeDomain.class));
        in.add(new ConfigurableComponent(InferredValue.class));
        in.add(new ConfigurableComponent(DataflowElement.class));
        return in;
    }

    public static final class ConfigurableComponent {
        private static final Reflections scanner = new Reflections("", new Scanner[]{new SubTypesScanner()});
        private final Class<?> component;
        private final Set<Class<?>> alternatives;

        private ConfigurableComponent(Class<?> component) {
            this.component = component;
            this.alternatives = new HashSet();
            Set subtypes = scanner.getSubTypesOf(component);
            for (Object sub : subtypes) {
                Class subtype = (Class)sub;
                if (Modifier.isAbstract(subtype.getModifiers()) || subtype.isInterface()) continue;
                this.alternatives.add(subtype);
            }
        }

        public Class<?> getComponent() {
            return this.component;
        }

        public Set<Class<?>> getAlternatives() {
            return this.alternatives;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.alternatives == null ? 0 : this.alternatives.hashCode());
            result = 31 * result + (this.component == null ? 0 : this.component.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConfigurableComponent other = (ConfigurableComponent)obj;
            if (this.component == null ? other.component != null : !this.component.equals(other.component)) {
                return false;
            }
            return !(this.alternatives == null ? other.alternatives != null : !this.alternatives.equals(other.alternatives));
        }

        public String toString() {
            Object result = this.component.getName();
            Object[] alternatives = (String[])this.alternatives.stream().map(e -> e.getName()).toArray(String[]::new);
            result = (String)result + " possible implementations: " + StringUtils.join((Object[])alternatives, (String)", ");
            return result;
        }
    }
}

