/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.provenance.impl;

import com.oracle.labs.mlrg.olcut.provenance.PrimitiveProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.ProvenanceException;
import com.oracle.labs.mlrg.olcut.provenance.primitives.DateTimeProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.StringProvenance;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.tribuo.Trainer;
import org.tribuo.provenance.TrainerProvenance;

public final class TimestampedTrainerProvenance
implements TrainerProvenance {
    private static final long serialVersionUID = 1L;
    public static final String CREATION_TIME = "creation-time";
    private final DateTimeProvenance creationTime;
    private final StringProvenance version;

    public TimestampedTrainerProvenance() {
        this.creationTime = new DateTimeProvenance(CREATION_TIME, OffsetDateTime.now());
        this.version = new StringProvenance("tribuo-version", "4.2.0");
    }

    public TimestampedTrainerProvenance(Map<String, Provenance> map) {
        Provenance tmp = map.get("tribuo-version");
        if (tmp != null) {
            if (!StringProvenance.class.isInstance(tmp)) {
                throw new ProvenanceException("Failed to cast tribuo-version when constructing TimestampedTrainerProvenance, found " + tmp);
            }
        } else {
            throw new ProvenanceException("Failed to find tribuo-version when constructing TimestampedTrainerProvenance");
        }
        this.version = (StringProvenance)tmp;
        tmp = map.get(CREATION_TIME);
        if (tmp != null) {
            if (!DateTimeProvenance.class.isInstance(tmp)) {
                throw new ProvenanceException("Failed to cast creation-time when constructing TimestampedTrainerProvenance, found " + tmp);
            }
        } else {
            throw new ProvenanceException("Failed to find creation-time when constructing TimestampedTrainerProvenance");
        }
        this.creationTime = (DateTimeProvenance)tmp;
    }

    public Map<String, PrimitiveProvenance<?>> getInstanceValues() {
        HashMap provMap = new HashMap();
        provMap.put(CREATION_TIME, (PrimitiveProvenance<?>)this.creationTime);
        provMap.put("tribuo-version", (PrimitiveProvenance<?>)this.version);
        return provMap;
    }

    public Map<String, Provenance> getConfiguredParameters() {
        return Collections.emptyMap();
    }

    public String getClassName() {
        return Trainer.class.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimestampedTrainerProvenance pairs = (TimestampedTrainerProvenance)o;
        return this.creationTime.equals((Object)pairs.creationTime) && this.version.equals((Object)pairs.version);
    }

    public int hashCode() {
        return Objects.hash(this.creationTime, this.version);
    }

    public String toString() {
        return this.generateString("Trainer");
    }
}

