/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.provenance;

import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.StringProvenance;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.tribuo.provenance.DataProvenance;
import org.tribuo.provenance.ModelProvenance;

public final class EvaluationProvenance
implements ObjectProvenance {
    private static final long serialVersionUID = 1L;
    private static final String MODEL_PROVENANCE_NAME = "model-provenance";
    private static final String DATASET_PROVENANCE_NAME = "dataset-provenance";
    private static final String TRIBUO_VERSION_STRING = "tribuo-version";
    private final StringProvenance className;
    private final ModelProvenance modelProvenance;
    private final DataProvenance datasetProvenance;
    private final StringProvenance versionString;

    public EvaluationProvenance(ModelProvenance modelProvenance, DataProvenance datasetProvenance) {
        this.className = new StringProvenance("class-name", EvaluationProvenance.class.getName());
        this.modelProvenance = modelProvenance;
        this.datasetProvenance = datasetProvenance;
        this.versionString = new StringProvenance(TRIBUO_VERSION_STRING, "4.2.0");
    }

    public EvaluationProvenance(Map<String, Provenance> map) {
        this.className = (StringProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)"class-name", StringProvenance.class, (String)EvaluationProvenance.class.getSimpleName());
        this.modelProvenance = (ModelProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)MODEL_PROVENANCE_NAME, ModelProvenance.class, (String)EvaluationProvenance.class.getSimpleName());
        this.datasetProvenance = (DataProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)DATASET_PROVENANCE_NAME, DataProvenance.class, (String)EvaluationProvenance.class.getSimpleName());
        this.versionString = (StringProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)TRIBUO_VERSION_STRING, StringProvenance.class, (String)EvaluationProvenance.class.getSimpleName());
    }

    public String getClassName() {
        return this.className.getValue();
    }

    public DataProvenance getTestDatasetProvenance() {
        return this.datasetProvenance;
    }

    public ModelProvenance getModelProvenance() {
        return this.modelProvenance;
    }

    public String getTribuoVersion() {
        return this.versionString.getValue();
    }

    public Iterator<Pair<String, Provenance>> iterator() {
        ArrayList<Pair> list = new ArrayList<Pair>();
        list.add(new Pair((Object)"class-name", (Object)this.className));
        list.add(new Pair((Object)MODEL_PROVENANCE_NAME, (Object)this.modelProvenance));
        list.add(new Pair((Object)DATASET_PROVENANCE_NAME, (Object)this.datasetProvenance));
        list.add(new Pair((Object)TRIBUO_VERSION_STRING, (Object)this.versionString));
        return list.iterator();
    }

    public String toString() {
        return this.generateString("Evaluation");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvaluationProvenance pairs = (EvaluationProvenance)o;
        return Objects.equals(this.className, pairs.className) && Objects.equals(this.modelProvenance, pairs.modelProvenance) && Objects.equals(this.datasetProvenance, pairs.datasetProvenance) && Objects.equals(this.versionString, pairs.versionString);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.modelProvenance, this.datasetProvenance, this.versionString);
    }
}

