/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.representation;

import it.unive.lisa.outputs.serializableGraph.SerializableValue;
import it.unive.lisa.util.collections.CollectionUtilities;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class StructuredRepresentation
implements Comparable<StructuredRepresentation> {
    private final SortedMap<String, String> properties = new TreeMap<String, String>();

    public SortedMap<String, String> getProperties() {
        return this.properties;
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public abstract SerializableValue toSerializableValue();

    @Override
    public final int compareTo(StructuredRepresentation o) {
        if (o == null) {
            return 1;
        }
        if (this.getClass() != o.getClass()) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        return CollectionUtilities.nullSafeCompare(true, this.toString(), o.toString(), String::compareTo);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructuredRepresentation other = (StructuredRepresentation)obj;
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public abstract String toString();
}

