/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.representation;

import it.unive.lisa.outputs.serializableGraph.SerializableArray;
import it.unive.lisa.outputs.serializableGraph.SerializableValue;
import it.unive.lisa.util.StringUtilities;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SetRepresentation
extends StructuredRepresentation {
    protected final SortedSet<StructuredRepresentation> elements;

    public <E> SetRepresentation(Set<E> elements, Function<E, StructuredRepresentation> mapper) {
        this(SetRepresentation.mapAndSort(elements, mapper));
    }

    public SetRepresentation(Set<StructuredRepresentation> elements) {
        this.elements = elements instanceof SortedSet ? (SortedSet<Object>)elements : new TreeSet<StructuredRepresentation>(elements);
    }

    private static <E> SortedSet<StructuredRepresentation> mapAndSort(Iterable<E> elements, Function<E, StructuredRepresentation> mapper) {
        TreeSet<StructuredRepresentation> result = new TreeSet<StructuredRepresentation>();
        for (E e : elements) {
            result.add(mapper.apply(e));
        }
        return result;
    }

    @Override
    public SerializableValue toSerializableValue() {
        ArrayList<SerializableValue> values = new ArrayList<SerializableValue>(this.elements.size());
        for (StructuredRepresentation e : this.elements) {
            values.add(e.toSerializableValue());
        }
        return new SerializableArray(this.getProperties(), values);
    }

    @Override
    public String toString() {
        if (this.elements.isEmpty()) {
            return "()";
        }
        List strs = this.elements.stream().map(Object::toString).collect(Collectors.toList());
        if (strs.stream().noneMatch(s -> s.contains("\n"))) {
            return "(" + StringUtils.join(strs, (String)", ") + ")";
        }
        StringBuilder sb = new StringBuilder("(");
        boolean first = true;
        for (String e : strs) {
            sb.append(first ? "\n" : ",\n").append(StringUtilities.indent(e.toString(), "  ", 1));
            first = false;
        }
        sb.append("\n)");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetRepresentation other = (SetRepresentation)obj;
        return !(this.elements == null ? other.elements != null : !this.elements.equals(other.elements));
    }
}

